/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jd.gui.api.model.TreeNodeData;

public class TreeNodeRenderer
implements TreeCellRenderer {
    protected Color textSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color textDisabledColor;
    protected Color backgroundDisabledColor;
    protected JPanel panel = new JPanel(new BorderLayout());
    protected JLabel icon = new JLabel();
    protected JLabel label;

    public TreeNodeRenderer() {
        this.panel.add((Component)this.icon, "West");
        this.label = new JLabel();
        this.panel.add((Component)this.label, "Center");
        this.panel.setOpaque(false);
        this.textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        this.backgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this.textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        this.backgroundNonSelectionColor = UIManager.getColor("Tree.textBackground");
        this.textDisabledColor = UIManager.getColor("Tree.disabledText");
        this.backgroundDisabledColor = UIManager.getColor("Tree.disabled");
        Insets margins = UIManager.getInsets("Tree.rendererMargins");
        this.icon.setForeground(this.textNonSelectionColor);
        this.icon.setOpaque(false);
        this.icon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.label.setOpaque(false);
        if (margins != null) {
            this.label.setBorder(BorderFactory.createEmptyBorder(margins.top, margins.left, margins.bottom, margins.right));
        } else {
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object data = ((DefaultMutableTreeNode)value).getUserObject();
        if (data instanceof TreeNodeData) {
            TreeNodeData tnd = (TreeNodeData)data;
            this.icon.setIcon(expanded && tnd.getOpenIcon() != null ? tnd.getOpenIcon() : tnd.getIcon());
            this.label.setText(tnd.getLabel());
        } else {
            this.icon.setIcon(null);
            this.label.setText("" + data);
        }
        if (selected) {
            if (hasFocus) {
                this.label.setForeground(this.textSelectionColor);
                this.label.setBackground(this.backgroundSelectionColor);
            } else {
                this.label.setForeground(this.textDisabledColor);
                this.label.setBackground(this.backgroundDisabledColor);
            }
            this.label.setOpaque(true);
        } else {
            this.label.setForeground(this.textNonSelectionColor);
            this.label.setOpaque(false);
        }
        return this.panel;
    }
}

