/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.util;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.util.containers.HashMap;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class DataProvidingPanel
extends JPanel
implements DataProvider {
    private final Map<String, Object> myOwnData = new HashMap();
    private final List<DataProvider> myProviders = new ArrayList<DataProvider>();

    public DataProvidingPanel(LayoutManager layout) {
        super(layout);
    }

    @Nullable
    public Object getData(String dataId) {
        Object data = this.myOwnData.get(dataId);
        if (data != null) {
            return data;
        }
        for (DataProvider provider : this.myProviders) {
            data = provider.getData(dataId);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public void putData(String id, Object data) {
        if (data != null) {
            this.myOwnData.put(id, data);
        } else {
            this.myOwnData.remove(id);
        }
    }

    public void addProvider(DataProvider provider) {
        this.myProviders.add(provider);
    }
}

