/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink;

import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.PatternIndexer;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.WeakList;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.Lifespan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelCache {
    private static ModelCache ourInstance = new ModelCache();
    private final List<PropertyChangeEvent> myEvents = new ArrayList<PropertyChangeEvent>(1);
    private final WeakList<PatternIndexer> myIndexers = new WeakList();
    private final Runnable myApplyingJob = new Runnable(){

        public void run() {
            ModelCache.this.trimEvents();
            if (!ModelCache.this.myEvents.isEmpty()) {
                PatternIndexer[] indexers;
                for (PatternIndexer propertyChangeListener : indexers = (PatternIndexer[])ModelCache.this.myIndexers.toArray((Object[])new PatternIndexer[ModelCache.this.myIndexers.size()])) {
                    for (PropertyChangeEvent myEvent : ModelCache.this.myEvents) {
                        propertyChangeListener.propertyChange(myEvent);
                    }
                }
            }
        }
    };
    private final Runnable myResetJob = new Runnable(){

        public void run() {
            ModelCache.this.myEvents.clear();
        }
    };
    private HashMap<Project, IssueLinkModel> myModels = new HashMap(1);

    public static synchronized ModelCache getInstance() {
        return ourInstance;
    }

    private ModelCache() {
    }

    public void addModel(final @NotNull Project project, final @NotNull IssueLinkModel model, @NotNull Lifespan lifespan) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/ModelCache.addModel must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/ModelCache.addModel must not be null");
        }
        if (lifespan == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/almworks/tracklink/ModelCache.addModel must not be null");
        }
        this.myModels.put((Object)project, (Object)model);
        final TableModelListener modelListener = new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() == e.getLastRow()) {
                    switch (e.getType()) {
                        case 1: {
                            ModelCache.this.myEvents.add(ModelCache.this.createEvent(null, model.get(e.getFirstRow())));
                            break;
                        }
                        case 0: {
                            ModelCache.this.myEvents.add(ModelCache.this.createEvent(model.getOld(e.getFirstRow()), model.get(e.getFirstRow())));
                            break;
                        }
                        case -1: {
                            ModelCache.this.myEvents.add(ModelCache.this.createEvent(model.getOld(e.getFirstRow()), null));
                        }
                    }
                }
            }
        };
        model.getListTableModel().addTableModelListener(modelListener);
        model.addApplyingJob(this.myApplyingJob);
        model.addResetJob(this.myResetJob);
        lifespan.add(new Detach(){

            protected void doDetach() {
                ModelCache.this.myModels.remove((Object)project);
                model.getListTableModel().removeTableModelListener(modelListener);
                model.removeApplyingJob(ModelCache.this.myApplyingJob);
                model.removeResetJob(ModelCache.this.myResetJob);
            }
        });
    }

    private void trimEvents() {
        PropertyChangeEvent[] propertyChangeEvents;
        for (PropertyChangeEvent event : propertyChangeEvents = this.myEvents.toArray(new PropertyChangeEvent[this.myEvents.size()])) {
            if (event.getOldValue() == null && event.getNewValue() == null) {
                this.myEvents.remove(event);
            }
            if (!Utils.equals(event.getOldValue(), event.getNewValue())) continue;
            this.myEvents.remove(event);
        }
    }

    private PropertyChangeEvent createEvent(CodeLinkType oldCodeLinkType, CodeLinkType newCodeLinkType) {
        return new PropertyChangeEvent(this, "indexPatterns", (Object)oldCodeLinkType, (Object)newCodeLinkType);
    }

    public void registerPatternIndexer(PatternIndexer patternIndexer) {
        this.myIndexers.add((Object)patternIndexer);
    }

    public PatternIndexer getPatternIndexer() {
        if (this.myIndexers.size() > 0) {
            return (PatternIndexer)this.myIndexers.get(0);
        }
        return null;
    }

    public CodeLinkType[] getReferenceTypes() {
        HashSet result = new HashSet();
        Collection models = this.myModels.values();
        for (IssueLinkModel model : models) {
            result.addAll(model.getReferenceTypes());
        }
        return result.toArray(new CodeLinkType[result.size()]);
    }

    @Nullable
    public IssueLinkModel getModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/ModelCache.getModel must not be null");
        }
        return (IssueLinkModel)this.myModels.get((Object)project);
    }
}

