//
// NamespaceStrategy.h
//
// $Id: //poco/1.4/XML/include/Poco/XML/NamespaceStrategy.h#1 $
//
// Library: XML
// Package: XML
// Module:  NamespaceStrategy
//
// Definition of the NamespaceStrategy class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef XML_NamespaceStrategy_INCLUDED
#define XML_NamespaceStrategy_INCLUDED


#include "Poco/XML/XML.h"
#include "Poco/XML/XMLString.h"
#include "Poco/SAX/NamespaceSupport.h"
#include "Poco/SAX/AttributesImpl.h"


namespace Poco {
namespace XML {


class ContentHandler;


class XML_API NamespaceStrategy
	/// This class is used by ParserEngine to handle the
	/// startElement, endElement, startPrefixMapping and
	/// endPrefixMapping events.
{
public:
	virtual ~NamespaceStrategy();

	virtual void startElement(const XMLChar* name, const XMLChar** atts, int specifiedCount, ContentHandler* pContentHandler) = 0;
		/// Translate the arguments as delivered by Expat and
		/// call the startElement() method of the ContentHandler.
		
	virtual void endElement(const XMLChar* name, ContentHandler* pContentHandler) = 0;
		/// Translate the arguments as delivered by Expat and
		/// call the endElement() method of the ContentHandler.

protected:
	static void splitName(const XMLChar* qname, XMLString& uri, XMLString& localName);
	static void splitName(const XMLChar* qname, XMLString& uri, XMLString& localName, XMLString& prefix);

	static const XMLString NOTHING;
};


class XML_API NoNamespacesStrategy: public NamespaceStrategy
	/// The NamespaceStrategy implementation used if no namespaces
	/// processing is requested.
{
public:
	NoNamespacesStrategy();
	~NoNamespacesStrategy();
	
	void startElement(const XMLChar* name, const XMLChar** atts, int specifiedCount, ContentHandler* pContentHandler);
	void endElement(const XMLChar* name, ContentHandler* pContentHandler);
	
private:
	XMLString _name;
	AttributesImpl _attrs;
};


class XML_API NoNamespacePrefixesStrategy: public NamespaceStrategy
	/// The NamespaceStrategy implementation used if namespaces
	/// processing is requested, but prefixes are not reported.
{
public:
	NoNamespacePrefixesStrategy();
	~NoNamespacePrefixesStrategy();
	
	void startElement(const XMLChar* name, const XMLChar** atts, int specifiedCount, ContentHandler* pContentHandler);
	void endElement(const XMLChar* name, ContentHandler* pContentHandler);

private:
	XMLString _uri;
	XMLString _local;
	AttributesImpl _attrs;
};


class XML_API NamespacePrefixesStrategy: public NamespaceStrategy
	/// The NamespaceStrategy implementation used if namespaces
	/// processing is requested and prefixes are reported.
{
public:
	NamespacePrefixesStrategy();
	~NamespacePrefixesStrategy();
	
	void startElement(const XMLChar* name, const XMLChar** atts, int specifiedCount, ContentHandler* pContentHandler);
	void endElement(const XMLChar* name, ContentHandler* pContentHandler);
	
private:
	XMLString _uri;
	XMLString _local;
	XMLString _qname;
	AttributesImpl _attrs;
};


} } // namespace Poco::XML


#endif // XML_NamespaceStrategy_INCLUDED
