/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00042\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0000\u001aD\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0006\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"notifySuccess", "", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete;", "title", "", "content", "undoProgressTitle", "undoImpossibleTitle", "undoErrorTitle", "notifyUndoError", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Error;", "project", "Lcom/intellij/openapi/project/Project;", "notifyUndoImpossible", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "undoInBackground", "result", "expireUndoAction", "Lkotlin/Function0;", "intellij.vcs.git"})
public final class GitCommitEditingNotificationsKt {
    public static final void notifySuccess(@NotNull GitCommitEditingOperationResult.Complete $this$notifySuccess, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @Nullable String content, @NlsContexts.ProgressTitle @NotNull String undoProgressTitle, @NlsContexts.ProgressTitle @NotNull String undoImpossibleTitle, @NlsContexts.ProgressTitle @NotNull String undoErrorTitle) {
        Intrinsics.checkNotNullParameter((Object)$this$notifySuccess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)undoProgressTitle, (String)"undoProgressTitle");
        Intrinsics.checkNotNullParameter((Object)undoImpossibleTitle, (String)"undoImpossibleTitle");
        Intrinsics.checkNotNullParameter((Object)undoErrorTitle, (String)"undoErrorTitle");
        Project project = $this$notifySuccess.getRepository().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CharSequence charSequence = content;
        Notification notification = charSequence == null || charSequence.length() == 0 ? VcsNotifier.standardNotification().createNotification(title, NotificationType.INFORMATION) : VcsNotifier.standardNotification().createNotification(title, content, NotificationType.INFORMATION);
        notification.setDisplayId("git.commit.edit.success");
        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)GitBundle.messagePointer((String)"action.NotificationAction.GitRewordOperation.text.undo", (Object[])new Object[0]), () -> GitCommitEditingNotificationsKt.notifySuccess$lambda$1(project2, undoProgressTitle, undoImpossibleTitle, undoErrorTitle, $this$notifySuccess, notification)));
        MessageBusConnection connection = project2.getMessageBus().connect();
        notification.whenExpired(() -> GitCommitEditingNotificationsKt.notifySuccess$lambda$2(connection));
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic, arg_0 -> GitCommitEditingNotificationsKt.notifySuccess$lambda$4($this$notifySuccess, notification, arg_0));
        VcsNotifier.getInstance((Project)project2).notify(notification);
    }

    public static final void notifyUndoError(@NotNull GitCommitEditingOperationResult.Complete.UndoResult.Error $this$notifyUndoError, @NotNull Project project, @NlsContexts.NotificationTitle @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyUndoError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VcsNotifier.getInstance((Project)project).notifyError("git.rebase.commit.edit.undo.error", title, $this$notifyUndoError.getErrorHtml());
    }

    public static final void notifyUndoImpossible(@NotNull GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible $this$notifyUndoImpossible, @NotNull Project project, @NlsContexts.NotificationTitle @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyUndoImpossible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VcsNotifier notifier = VcsNotifier.getInstance((Project)project);
        GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible impossible = $this$notifyUndoImpossible;
        if (Intrinsics.areEqual((Object)impossible, (Object)GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible.HeadMoved.INSTANCE)) {
            v0 = notifier.notifyError("git.rebase.commit.edit.undo.error.repo.changed", title, GitBundle.message((String)"rebase.log.reword.action.notification.undo.not.allowed.repository.changed.message", (Object[])new Object[0]));
        } else if (impossible instanceof GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible.PushedToProtectedBranch) {
            Object[] objectArray = new Object[]{((GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible.PushedToProtectedBranch)$this$notifyUndoImpossible).getBranch()};
            v0 = notifier.notifyError("git.rebase.commit.edit.undo.error.protected.branch", title, GitBundle.message((String)"rebase.log.undo.impossible.pushed.to.protected.branch.notification.text", (Object[])objectArray));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void undoInBackground(Project project, @NlsContexts.ProgressTitle String undoProgressTitle, @NlsContexts.ProgressTitle String undoImpossibleTitle, @NlsContexts.ProgressTitle String undoErrorTitle, GitCommitEditingOperationResult.Complete result2, Function0<Unit> expireUndoAction) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, undoProgressTitle, result2, undoImpossibleTitle, expireUndoAction, undoErrorTitle){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitCommitEditingOperationResult.Complete $result;
            final /* synthetic */ String $undoImpossibleTitle;
            final /* synthetic */ Function0<Unit> $expireUndoAction;
            final /* synthetic */ String $undoErrorTitle;
            {
                this.$project = $project;
                this.$result = $result;
                this.$undoImpossibleTitle = $undoImpossibleTitle;
                this.$expireUndoAction = $expireUndoAction;
                this.$undoErrorTitle = $undoErrorTitle;
                super($project, $undoProgressTitle);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult.Complete.UndoPossibility possibility = this.$result.checkUndoPossibility();
                if (possibility instanceof GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible) {
                    GitCommitEditingNotificationsKt.notifyUndoImpossible((GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible)possibility, this.$project, this.$undoImpossibleTitle);
                    this.$expireUndoAction.invoke();
                    return;
                }
                GitCommitEditingOperationResult.Complete.UndoResult undoResult = this.$result.undo();
                if (undoResult instanceof GitCommitEditingOperationResult.Complete.UndoResult.Error) {
                    GitCommitEditingNotificationsKt.notifyUndoError((GitCommitEditingOperationResult.Complete.UndoResult.Error)undoResult, this.$project, this.$undoErrorTitle);
                } else if (undoResult instanceof GitCommitEditingOperationResult.Complete.UndoResult.Success) {
                    this.$expireUndoAction.invoke();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        });
    }

    private static final Unit notifySuccess$lambda$1$lambda$0(Notification $notification) {
        $notification.expire();
        return Unit.INSTANCE;
    }

    private static final void notifySuccess$lambda$1(Project $project, String $undoProgressTitle, String $undoImpossibleTitle, String $undoErrorTitle, GitCommitEditingOperationResult.Complete $this_notifySuccess, Notification $notification) {
        GitCommitEditingNotificationsKt.undoInBackground($project, $undoProgressTitle, $undoImpossibleTitle, $undoErrorTitle, $this_notifySuccess, (Function0<Unit>)((Function0)() -> GitCommitEditingNotificationsKt.notifySuccess$lambda$1$lambda$0($notification)));
    }

    private static final void notifySuccess$lambda$2(MessageBusConnection $connection) {
        $connection.disconnect();
    }

    private static final void notifySuccess$lambda$4$lambda$3(GitCommitEditingOperationResult.Complete $this_notifySuccess, Notification $notification) {
        if ($this_notifySuccess.checkUndoPossibility() != GitCommitEditingOperationResult.Complete.UndoPossibility.Possible.INSTANCE) {
            $notification.expire();
        }
    }

    private static final void notifySuccess$lambda$4(GitCommitEditingOperationResult.Complete $this_notifySuccess, Notification $notification, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it, (Object)$this_notifySuccess.getRepository())) {
            BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)$this_notifySuccess.getRepository()), () -> GitCommitEditingNotificationsKt.notifySuccess$lambda$4$lambda$3($this_notifySuccess, $notification));
        }
    }
}

