/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.anchorlink.internal;

import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.anchorlink.internal.AnchorLinkOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnchorLinkNodeRenderer
implements NodeRenderer {
    private final AnchorLinkOptions options;

    public AnchorLinkNodeRenderer(DataHolder options) {
        this.options = new AnchorLinkOptions(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<AnchorLink>(AnchorLink.class, this::render));
        return set;
    }

    private void render(AnchorLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            if (this.options.wrapText) {
                context.renderChildren(node);
            }
        } else {
            String id = context.getNodeId(node.getParent());
            if (id != null) {
                html.attr("href", "#" + id);
                if (this.options.setId) {
                    html.attr("id", id);
                }
                if (this.options.setName) {
                    html.attr("name", id);
                }
                if (!this.options.anchorClass.isEmpty()) {
                    html.attr("class", this.options.anchorClass);
                }
                if (!this.options.wrapText) {
                    html.withAttr().tag("a");
                    if (!this.options.textPrefix.isEmpty()) {
                        html.raw(this.options.textPrefix);
                    }
                    if (!this.options.textSuffix.isEmpty()) {
                        html.raw(this.options.textSuffix);
                    }
                    html.tag("/a");
                } else {
                    html.withAttr().tag("a", false, false, () -> {
                        if (!this.options.textPrefix.isEmpty()) {
                            html.raw(this.options.textPrefix);
                        }
                        context.renderChildren(node);
                        if (!this.options.textSuffix.isEmpty()) {
                            html.raw(this.options.textSuffix);
                        }
                    });
                }
            } else if (this.options.wrapText) {
                context.renderChildren(node);
            }
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new AnchorLinkNodeRenderer(options);
        }
    }
}

