/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import org.jetbrains.annotations.NotNull;

public class VcsSelection {
    private final Document myDocument;
    @NotNull
    private final TextRange myTextRange;
    private final @NlsActions.ActionText String myActionName;
    @NlsContexts.DialogTitle
    private final String myDialogTitle;

    public VcsSelection(@NotNull Document document, @NotNull TextRange textRange, String actionName) {
        if (document == null) {
            VcsSelection.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            VcsSelection.$$$reportNull$$$0(1);
        }
        this.myDocument = document;
        this.myTextRange = textRange;
        this.myActionName = VcsBundle.message("show.history.action.name.template", actionName);
        this.myDialogTitle = VcsBundle.message("show.history.dialog.title.template", actionName);
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            VcsSelection.$$$reportNull$$$0(2);
        }
        return document;
    }

    public int getSelectionStartLineNumber() {
        return this.safeGetDocumentLine(this.myTextRange.getStartOffset());
    }

    public int getSelectionEndLineNumber() {
        return this.safeGetDocumentLine(this.myTextRange.getEndOffset());
    }

    private int safeGetDocumentLine(int offset) {
        if (offset >= this.myDocument.getTextLength()) {
            return this.myDocument.getLineCount() - 1;
        }
        return this.myDocument.getLineNumber(offset);
    }

    @NlsActions.ActionText
    public String getActionName() {
        return this.myActionName;
    }

    @NlsContexts.DialogTitle
    public String getDialogTitle() {
        return this.myDialogTitle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsSelection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

