/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.platform.execution.frontend.split.debugger.ProtocolUtilsKt;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebuggerEvaluatorKt;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientEditorsProviderBase;
import com.intellij.platform.execution.frontend.split.debugger.ThinExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.codeWithMe.model.DebuggerWatchesInfo;
import com.jetbrains.codeWithMe.model.SourcePositionModel;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.SourcePositionBase;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rdclient.document.FrontendDocumentExtensionsProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerWatchesProvider;", "Lcom/jetbrains/rdclient/document/FrontendDocumentExtensionsProvider;", "<init>", "()V", "getExtensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientDebuggerWatchesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientDebuggerWatchesProvider.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerWatchesProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,28:1\n24#2:29\n*S KotlinDebug\n*F\n+ 1 ThinClientDebuggerWatchesProvider.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerWatchesProvider\n*L\n22#1:29\n*E\n"})
public final class ThinClientDebuggerWatchesProvider
implements FrontendDocumentExtensionsProvider {
    @NotNull
    public List<DocumentExtension> getExtensions(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (ThinClientEditorsProviderBase.Companion.getProviderKind(document) != ThinClientEditorsProviderBase.Kind.Watch) {
            return CollectionsKt.emptyList();
        }
        Boxed<XSourcePosition> boxed = ThinClientEditorsProviderBase.Companion.getSourcePosition(document);
        if (boxed == null) {
            return CollectionsKt.emptyList();
        }
        Boxed<XSourcePosition> position = boxed;
        XSourcePosition xSourcePosition = (XSourcePosition)position.getValue();
        SourcePositionModel positionModel = xSourcePosition != null ? ProtocolUtilsKt.toModel(xSourcePosition) : null;
        ThinExpression thinExpression = ThinClientEditorsProviderBase.Companion.getInitialExpression(document);
        if (thinExpression == null) {
            String string = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            thinExpression = ThinExpression.Companion.createDefault(string);
        }
        ThinExpression expression = thinExpression;
        RdProjectId rdProjectId = ThinClientEditorsProviderBase.Companion.getDebuggerRdProjectId(document);
        if (rdProjectId == null) {
            boolean bl = false;
            ThinClientDebuggerWatchesProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ThinClientDebuggerWatchesProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("rdProjectId is not set for document: " + document);
            return CollectionsKt.emptyList();
        }
        RdProjectId projectId = rdProjectId;
        return CollectionsKt.listOf((Object)new DebuggerWatchesInfo(projectId, ThinClientDebuggerEvaluatorKt.toCodeWithMeExpressionModel(expression), (SourcePositionBase)positionModel));
    }
}

