/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import com.jetbrains.rd.platform.codeWithMe.blockmap.ChunkInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMap;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirMergerKt;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileHash;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.misc.FileCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.RecursiveAction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BW\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t0\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J4\u0010\u0011\u001a\u00020\u00102\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t0\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/CopyChunksFromFileTask;", "Ljava/util/concurrent/RecursiveAction;", "localDirs", "", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMap;", "newBlockMap", "localBlockMaps", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/ChunkInfo;", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/Chunks;", "fileInfo", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FileInfo;", "outputPath", "<init>", "(Ljava/util/Map;Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMap;Ljava/util/Map;Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FileInfo;Ljava/lang/String;)V", "compute", "", "mergeFile", "output", "Ljava/io/RandomAccessFile;", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nLocalFilesTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFilesTasks.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/CopyChunksFromFileTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class CopyChunksFromFileTask
extends RecursiveAction {
    @NotNull
    private final Map<String, DirBlockMap> localDirs;
    @NotNull
    private final DirBlockMap newBlockMap;
    @NotNull
    private final Map<String, Map<String, ChunkInfo>> localBlockMaps;
    @NotNull
    private final FileInfo fileInfo;
    @NotNull
    private final String outputPath;

    public CopyChunksFromFileTask(@NotNull Map<String, DirBlockMap> localDirs, @NotNull DirBlockMap newBlockMap, @NotNull Map<String, ? extends Map<String, ChunkInfo>> localBlockMaps, @NotNull FileInfo fileInfo, @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter(localDirs, (String)"localDirs");
        Intrinsics.checkNotNullParameter((Object)newBlockMap, (String)"newBlockMap");
        Intrinsics.checkNotNullParameter(localBlockMaps, (String)"localBlockMaps");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.localDirs = localDirs;
        this.newBlockMap = newBlockMap;
        this.localBlockMaps = localBlockMaps;
        this.fileInfo = fileInfo;
        this.outputPath = outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compute() {
        FileHash fileHash;
        Object object;
        Object object2 = new String[]{this.fileInfo.getName()};
        File targetFile = Paths.get(this.outputPath, object2).toFile();
        object2 = new RandomAccessFile(targetFile, "rw");
        Object object3 = null;
        try {
            RandomAccessFile output = (RandomAccessFile)object2;
            boolean bl = false;
            this.mergeFile(this.localBlockMaps, output);
            object = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            object3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        object3 = new FileInputStream(targetFile);
        object = null;
        try {
            FileInputStream input = (FileInputStream)object3;
            boolean bl = false;
            fileHash = new FileHash(input, null, 2, null);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object);
        }
        FileHash curFileHash = fileHash;
        if (!Intrinsics.areEqual((Object)curFileHash.getHash(), (Object)this.fileInfo.getHash())) {
            throw new IOException("Hashes doesn't match: " + targetFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeFile(Map<String, ? extends Map<String, ChunkInfo>> localBlockMaps, RandomAccessFile output) {
        AutoCloseable autoCloseable = new FileCache(null, 0, 3, null);
        Throwable throwable = null;
        try {
            FileCache fileCache = (FileCache)autoCloseable;
            boolean bl = false;
            int n = this.fileInfo.getEndChunkIdx();
            for (int chunkId = this.fileInfo.getStartChunkIdx(); chunkId < n; ++chunkId) {
                Chunk chunk = this.newBlockMap.getChunks().get(chunkId).getChunk();
                Pair<String, ChunkInfo> pair = DirMergerKt.findLocalChunk(chunk.getHash(), localBlockMaps);
                String localPath = (String)pair.component1();
                ChunkInfo localChunk = (ChunkInfo)pair.component2();
                if (localChunk == null) continue;
                DirBlockMap dirBlockMap = this.localDirs.get(localPath);
                Intrinsics.checkNotNull((Object)dirBlockMap);
                FileInfo localFileInfo = dirBlockMap.getFileInfos().get(localChunk.getFileIdx());
                String string = localPath;
                Intrinsics.checkNotNull((Object)string);
                String[] stringArray = new String[]{localFileInfo.getName()};
                String fileName = ((Object)Paths.get(string, stringArray)).toString();
                output.seek(chunk.getOffset());
                output.write(fileCache.readBytes(fileName, localChunk.getChunk().getOffset(), localChunk.getChunk().getLength()));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

