/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.ComponentListPanelFactory;
import com.intellij.collaboration.ui.EditableComponentFactory;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.CodeReviewChatItemUIUtil;
import com.intellij.collaboration.ui.codereview.CodeReviewTimelineUIUtil;
import com.intellij.collaboration.ui.codereview.comment.CodeReviewCommentTextFieldFactory;
import com.intellij.collaboration.ui.codereview.comment.CodeReviewCommentUIUtil;
import com.intellij.collaboration.ui.codereview.comment.CodeReviewSubmittableTextViewModel;
import com.intellij.collaboration.ui.codereview.comment.CodeReviewTextEditingViewModel;
import com.intellij.collaboration.ui.codereview.comment.CodeReviewTextEditingViewModelKt;
import com.intellij.collaboration.ui.codereview.comment.CommentInputActionsComponentFactory;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageComponentFactory;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageType;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.collaboration.util.ComputedResult;
import com.intellij.collaboration.util.ComputedResultKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.InlineIconButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommitShort;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverterKt;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRDetailsFull;
import org.jetbrains.plugins.github.pullrequest.ui.emoji.GHReactionsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.emoji.GHReactionsPickerComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemUIUtil;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineCommentViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineReviewViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineThreadComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineThreadViewModel;
import org.jetbrains.plugins.github.ui.util.GHHtmlPaneUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0003H\u0096\u0002J\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0014\u0010\u001a\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010\u001a\u001a\u00020\u0004*\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0002J\u001f\u0010\"\u001a\u00020#*\u00020\u00022\u0011\u0010$\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b&0%H\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineItem;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "timelineVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;)V", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "prAuthor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "eventComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "invoke", "cs", "item", "createComponent", "commits", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommitShort;", "comment", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineCommentViewModel;", "review", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineReviewViewModel;", "createHtmlPane", "Ljavax/swing/JEditorPane;", "text", "Lkotlinx/coroutines/flow/Flow;", "Lorg/jetbrains/annotations/Nls;", "createReviewStatus", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRTimelineItemComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineItemComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 HtmlChunkUtil.kt\ncom/intellij/openapi/util/text/HtmlChunkUtilKt\n*L\n1#1,233:1\n1292#2,3:234\n18#3:237\n*S KotlinDebug\n*F\n+ 1 GHPRTimelineItemComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory\n*L\n110#1:234,3\n88#1:237\n*E\n"})
public final class GHPRTimelineItemComponentFactory
implements Function2<CoroutineScope, GHPRTimelineItem, JComponent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRTimelineViewModel timelineVm;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final GHUser ghostUser;
    @Nullable
    private final GHActor prAuthor;
    @NotNull
    private final GHPRTimelineEventComponentFactoryImpl eventComponentFactory;
    @NotNull
    private static final String COMMIT_HREF_PREFIX = "commit://";

    public GHPRTimelineItemComponentFactory(@NotNull Project project, @NotNull GHPRTimelineViewModel timelineVm) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timelineVm, (String)"timelineVm");
        this.project = project;
        this.timelineVm = timelineVm;
        this.avatarIconsProvider = this.timelineVm.getAvatarIconsProvider();
        this.htmlImageLoader = this.timelineVm.getHtmlImageLoader();
        this.ghostUser = this.timelineVm.getGhostUser();
        Object object2 = ((ComputedResult)this.timelineVm.getDetailsVm().getDetails().getValue()).unbox-impl();
        this.prAuthor = object2 != null && (object2 = (GHPRDetailsFull)(Result.isFailure-impl((Object)(object = object2.unbox-impl())) ? null : object)) != null ? ((GHPRDetailsFull)object2).getAuthor() : null;
        this.eventComponentFactory = new GHPRTimelineEventComponentFactoryImpl(this.timelineVm);
    }

    @NotNull
    public JComponent invoke(@NotNull CoroutineScope cs, @NotNull GHPRTimelineItem item) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GHPRTimelineItem gHPRTimelineItem = item;
        if (gHPRTimelineItem instanceof GHPRTimelineItem.Review) {
            jComponent = this.createComponent(cs, (GHPRTimelineReviewViewModel)((Object)item));
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Comment) {
            jComponent = this.createComponent(cs, (GHPRTimelineCommentViewModel)((Object)item));
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Commits) {
            jComponent = this.createComponent(this.project, ((GHPRTimelineItem.Commits)item).getCommits());
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Event) {
            JComponent jComponent2;
            try {
                jComponent2 = this.eventComponentFactory.createComponent(((GHPRTimelineItem.Event)item).getEvent());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{e.getMessage()};
                String string = GithubBundle.message("cannot.display.item", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String body = string;
                GHActor gHActor = this.prAuthor;
                if (gHActor == null) {
                    gHActor = this.ghostUser;
                }
                jComponent2 = GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, gHActor, null, HtmlEditorPaneUtilKt.SimpleHtmlPane((String)body), null, 16, null);
            }
            jComponent = jComponent2;
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown) {
            Object[] objectArray = new Object[]{((GHPRTimelineItem.Unknown)item).getTypename()};
            String string = GithubBundle.message("cannot.display.item", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String body = string;
            GHActor gHActor = this.prAuthor;
            if (gHActor == null) {
                gHActor = this.ghostUser;
            }
            jComponent = GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, gHActor, null, HtmlEditorPaneUtilKt.SimpleHtmlPane((String)body), null, 16, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(Project project, List<GHPullRequestCommitShort> commits2) {
        GHActor gHActor;
        String string;
        Object object;
        void $this$fold$iv;
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)commits2), GHPRTimelineItemComponentFactory::createComponent$lambda$0), arg_0 -> GHPRTimelineItemComponentFactory.createComponent$lambda$2(project, this, arg_0)), arg_0 -> GHPRTimelineItemComponentFactory.createComponent$lambda$5(this, arg_0));
        JPanel initial$iv = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean $i$f$fold = false;
        JPanel accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void commitPane;
            JPanel jPanel;
            object = (JEditorPane)element$iv;
            JPanel panel2 = accumulator$iv;
            boolean bl = false;
            JPanel $this$createComponent_u24lambda_u247_u24lambda_u246 = jPanel = panel2;
            boolean bl2 = false;
            $this$createComponent_u24lambda_u247_u24lambda_u246.add((Component)commitPane);
            accumulator$iv = jPanel;
        }
        JPanel commitsPanels2 = accumulator$iv;
        int commitsCount = commits2.size();
        JPanel $this$createComponent_u24lambda_u248 = $i$f$fold = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean bl = false;
        if (commitsCount == 1) {
            string = GithubBundle.message("pull.request.timeline.commit.added", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{commitsCount};
            string = GithubBundle.message("pull.request.timeline.commits.added", objectArray);
        }
        object = string;
        Intrinsics.checkNotNull((Object)object);
        Object titleText = object;
        $this$createComponent_u24lambda_u248.add(HtmlEditorPaneUtilKt.SimpleHtmlPane((String)titleText));
        $this$createComponent_u24lambda_u248.add(StatusMessageComponentFactory.create$default((StatusMessageComponentFactory)StatusMessageComponentFactory.INSTANCE, (JComponent)commitsPanels2, null, (int)2, null));
        JPanel contentPanel = $i$f$fold;
        Object object2 = (GHPullRequestCommitShort)CollectionsKt.singleOrNull(commits2);
        if (object2 != null && (object2 = ((GHPullRequestCommitShort)object2).getCommit()) != null && (object2 = ((GHCommitShort)object2).getAuthor()) != null && (object2 = ((GHGitActor)object2).getUser()) != null) {
            gHActor = (GHActor)object2;
        } else {
            gHActor = this.prAuthor;
            if (gHActor == null) {
                gHActor = this.ghostUser;
            }
        }
        GHActor actor = gHActor;
        Object object3 = (GHPullRequestCommitShort)CollectionsKt.singleOrNull(commits2);
        return GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, actor, object3 != null && (object3 = ((GHPullRequestCommitShort)object3).getCommit()) != null && (object3 = ((GHCommitShort)object3).getAuthor()) != null ? ((GHGitActor)object3).getDate() : null, contentPanel, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(CoroutineScope $this$createComponent, GHPRTimelineCommentViewModel comment2) {
        JPanel jPanel;
        JPanel jPanel2;
        CoroutineScope cs = $this$createComponent;
        JEditorPane textPane2 = this.createHtmlPane($this$createComponent, (Flow<String>)((Flow)comment2.getBodyHtml()));
        JComponent content2 = EditableComponentFactory.INSTANCE.create(cs, (JComponent)textPane2, (Flow)comment2.getEditVm(), GHPRTimelineItemComponentFactory::createComponent$lambda$9);
        JPanel $this$createComponent_u24lambda_u2410 = jPanel2 = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean bl = false;
        $this$createComponent_u24lambda_u2410.add(content2);
        $this$createComponent_u24lambda_u2410.add(GHReactionsComponentFactory.INSTANCE.create(cs, comment2.getReactionsVm()));
        JPanel mainPanel2 = jPanel2;
        JPanel $this$createComponent_u24lambda_u2415 = jPanel = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
        boolean bl2 = false;
        if (comment2.getCanEdit()) {
            void $this$createComponent_u24lambda_u2415_u24lambda_u2412;
            InlineIconButton inlineIconButton;
            InlineIconButton inlineIconButton2 = inlineIconButton = CodeReviewCommentUIUtil.INSTANCE.createEditButton(arg_0 -> GHPRTimelineItemComponentFactory.createComponent$lambda$15$lambda$11(comment2, arg_0));
            JPanel jPanel3 = $this$createComponent_u24lambda_u2415;
            boolean bl3 = false;
            SwingBindingsKt.bindDisabledIn((JComponent)((JComponent)$this$createComponent_u24lambda_u2415_u24lambda_u2412), (CoroutineScope)cs, (Flow)((Flow)comment2.isBusy()));
            jPanel3.add((Component)inlineIconButton);
        }
        if (comment2.getCanDelete()) {
            $this$createComponent_u24lambda_u2415.add(CodeReviewCommentUIUtil.INSTANCE.createDeleteCommentIconButton(arg_0 -> GHPRTimelineItemComponentFactory.createComponent$lambda$15$lambda$13(comment2, arg_0)));
        }
        if (comment2.getCanReact()) {
            $this$createComponent_u24lambda_u2415.add((Component)CodeReviewCommentUIUtil.INSTANCE.createAddReactionButton(arg_0 -> GHPRTimelineItemComponentFactory.createComponent$lambda$15$lambda$14(comment2, arg_0)));
        }
        JPanel actionsPanel2 = jPanel;
        return GHPRTimelineItemUIUtil.INSTANCE.createTimelineItem(this.avatarIconsProvider, comment2.getAuthor(), comment2.getCreatedAt(), mainPanel2, actionsPanel2);
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(CoroutineScope $this$createComponent, GHPRTimelineReviewViewModel review) {
        JPanel jPanel;
        void $this$createComponent_u24lambda_u2419_u24lambda_u2418;
        InlineIconButton inlineIconButton;
        JPanel jPanel2;
        CoroutineScope cs = $this$createComponent;
        JEditorPane textPane2 = this.createHtmlPane($this$createComponent, (Flow<String>)((Flow)review.getBodyHtml()));
        JComponent content2 = EditableComponentFactory.wrapTextComponent$default((EditableComponentFactory)EditableComponentFactory.INSTANCE, (CoroutineScope)cs, (JComponent)textPane2, (Flow)((Flow)review.getEditVm()), null, (int)8, null);
        JPanel $this$createComponent_u24lambda_u2416 = jPanel2 = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        boolean bl = false;
        $this$createComponent_u24lambda_u2416.add(content2);
        $this$createComponent_u24lambda_u2416.add(this.createReviewStatus(review));
        JPanel contentPanel = jPanel2;
        JPanel $this$createComponent_u24lambda_u2419 = $this$createComponent_u24lambda_u2416 = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
        boolean bl2 = false;
        InlineIconButton inlineIconButton2 = inlineIconButton = CodeReviewCommentUIUtil.INSTANCE.createEditButton(arg_0 -> GHPRTimelineItemComponentFactory.createComponent$lambda$19$lambda$17(review, arg_0));
        JPanel jPanel3 = $this$createComponent_u24lambda_u2419;
        boolean bl3 = false;
        SwingBindingsKt.bindVisibilityIn((JComponent)((JComponent)$this$createComponent_u24lambda_u2419_u24lambda_u2418), (CoroutineScope)cs, (Flow)((Flow)review.getCanEdit()));
        SwingBindingsKt.bindDisabledIn((JComponent)((JComponent)$this$createComponent_u24lambda_u2419_u24lambda_u2418), (CoroutineScope)cs, (Flow)((Flow)review.isBusy()));
        jPanel3.add((Component)inlineIconButton);
        JPanel actionsPanel2 = $this$createComponent_u24lambda_u2416;
        JComponent reviewItem = GHPRTimelineItemUIUtil.INSTANCE.createTimelineItem(this.avatarIconsProvider, review.getAuthor(), review.getCreatedAt(), contentPanel, actionsPanel2);
        JPanel $this$createComponent_u24lambda_u2424 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel((int)0);
        boolean bl4 = false;
        $this$createComponent_u24lambda_u2424.add(reviewItem);
        SwingBindingsKt.bindChildIn$default((JPanel)$this$createComponent_u24lambda_u2424, (CoroutineScope)cs, (Flow)((Flow)review.getThreads()), null, (Integer)0, GHPRTimelineItemComponentFactory::createComponent$lambda$24$lambda$23, (int)4, null);
        return jPanel;
    }

    private final JEditorPane createHtmlPane(CoroutineScope $this$createHtmlPane, Flow<String> text) {
        Object object = this.htmlImageLoader;
        Object $this$createHtmlPane_u24lambda_u2425 = object = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, (AsyncHtmlImageLoader)object, null, null, (int)25, null);
        boolean bl = false;
        GHHtmlPaneUtilKt.addGithubHyperlinkListener((JEditorPane)$this$createHtmlPane_u24lambda_u2425, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this.timelineVm){

            public final void invoke(long p0) {
                ((GHPRTimelineViewModel)this.receiver).openPullRequestInfoAndTimeline(p0);
            }
        }));
        SwingBindingsKt.bindTextIn((JEditorPane)$this$createHtmlPane_u24lambda_u2425, (CoroutineScope)$this$createHtmlPane, text);
        return object;
    }

    private final JComponent createReviewStatus(GHPRTimelineReviewViewModel review) {
        String string = switch (WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1 -> GithubBundle.message("pull.request.timeline.approved.changes", new Object[0]);
            case 2 -> GithubBundle.message("pull.request.timeline.requested.changes", new Object[0]);
            case 3 -> GithubBundle.message("pull.request.timeline.started.review", new Object[0]);
            case 4, 5 -> GithubBundle.message("pull.request.timeline.reviewed", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)string);
        String stateText = string;
        StatusMessageType stateType = switch (WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1 -> StatusMessageType.SUCCESS;
            case 2 -> StatusMessageType.ERROR;
            case 3 -> StatusMessageType.SECONDARY_INFO;
            case 4, 5 -> StatusMessageType.INFO;
            default -> throw new NoWhenBranchMatchedException();
        };
        return StatusMessageComponentFactory.INSTANCE.create((JComponent)HtmlEditorPaneUtilKt.SimpleHtmlPane((String)stateText), stateType);
    }

    private static final GHCommitShort createComponent$lambda$0(GHPullRequestCommitShort it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCommit();
    }

    private static final String createComponent$lambda$2(Project $project, GHPRTimelineItemComponentFactory this$0, GHCommitShort it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.link((String)(COMMIT_HREF_PREFIX + it.getOid()), (String)it.getAbbreviatedOid()), HtmlChunk.nbsp(), HtmlChunk.raw((String)GHMarkdownToHtmlConverterKt.convertToHtml(it.getMessageHeadline(), $project))};
        HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.p().children(htmlChunkArray));
        GHGitActor author = it.getAuthor();
        if (author != null) {
            HtmlBuilder htmlBuilder;
            GHUser gHUser = author.getUser();
            if (gHUser == null) {
                gHUser = this$0.ghostUser;
            }
            GHUser actor = gHUser;
            Date date = author.getDate();
            HtmlChunk.Element element = HtmlChunk.p();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"p(...)");
            HtmlChunk.Element $this$buildChildren$iv = element;
            boolean $i$f$buildChildren = false;
            HtmlBuilder $this$createComponent_u24lambda_u242_u24lambda_u241 = htmlBuilder = new HtmlBuilder();
            boolean bl = false;
            $this$createComponent_u24lambda_u242_u24lambda_u241.append((HtmlChunk)HtmlChunk.link((String)actor.getUrl(), (String)actor.getPresentableName()));
            if (date != null) {
                $this$createComponent_u24lambda_u242_u24lambda_u241.append(HtmlChunk.nbsp());
                $this$createComponent_u24lambda_u242_u24lambda_u241.append(DateFormatUtil.formatPrettyDateTime((Date)date));
            }
            HtmlChunk.Element element2 = htmlBuilder.wrapWith($this$buildChildren$iv);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"wrapWith(...)");
            HtmlChunk.Element chunk = element2;
            builder.append((HtmlChunk)chunk);
        }
        return builder.toString();
    }

    private static final Unit createComponent$lambda$5$lambda$4$lambda$3(GHPRTimelineItemComponentFactory this$0, HyperlinkEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String href = e.getDescription();
        Intrinsics.checkNotNull((Object)href);
        if (StringsKt.startsWith$default((String)href, (String)COMMIT_HREF_PREFIX, (boolean)false, (int)2, null)) {
            this$0.timelineVm.showCommit(StringsKt.removePrefix((String)href, (CharSequence)COMMIT_HREF_PREFIX));
            return Unit.INSTANCE;
        }
        GHHtmlPaneUtilKt.handleGithubHyperlink(e, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this$0.timelineVm){

            public final void invoke(long p0) {
                ((GHPRTimelineViewModel)this.receiver).openPullRequestInfoAndTimeline(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final JEditorPane createComponent$lambda$5(GHPRTimelineItemComponentFactory this$0, String text) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        JEditorPane $this$createComponent_u24lambda_u245_u24lambda_u244 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, null, (int)29, null);
        boolean bl = false;
        HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)$this$createComponent_u24lambda_u245_u24lambda_u244, (String)text);
        HtmlEditorPaneUtilKt.onHyperlinkActivated((JEditorPane)$this$createComponent_u24lambda_u245_u24lambda_u244, arg_0 -> GHPRTimelineItemComponentFactory.createComponent$lambda$5$lambda$4$lambda$3(this$0, arg_0));
        return jEditorPane;
    }

    private static final JComponent createComponent$lambda$9(CoroutineScope $this$create, CodeReviewTextEditingViewModel it) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommentInputActionsComponentFactory.Config actions2 = CodeReviewTextEditingViewModelKt.createEditActionsConfig$default((CoroutineScope)$this$create, (CodeReviewTextEditingViewModel)it, null, (int)2, null);
        JComponent editor = CodeReviewCommentTextFieldFactory.createIn$default((CodeReviewCommentTextFieldFactory)CodeReviewCommentTextFieldFactory.INSTANCE, (CoroutineScope)$this$create, (CodeReviewSubmittableTextViewModel)((CodeReviewSubmittableTextViewModel)it), (CommentInputActionsComponentFactory.Config)actions2, null, (int)8, null);
        it.requestFocus();
        return editor;
    }

    private static final Unit createComponent$lambda$15$lambda$11(GHPRTimelineCommentViewModel $comment, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $comment.editBody();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$15$lambda$13(GHPRTimelineCommentViewModel $comment, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $comment.delete();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$15$lambda$14(GHPRTimelineCommentViewModel $comment, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent parentComponent = (JComponent)object;
        GHReactionsPickerComponentFactory.INSTANCE.showPopup($comment.getReactionsVm(), parentComponent);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$19$lambda$17(GHPRTimelineReviewViewModel $review, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $review.editBody();
        return Unit.INSTANCE;
    }

    private static final JComponent createComponent$lambda$24$lambda$23$lambda$22(CoroutineScope $this$createVertical, GHPRTimelineThreadViewModel it) {
        Intrinsics.checkNotNullParameter((Object)$this$createVertical, (String)"$this$createVertical");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GHPRTimelineThreadComponentFactory.INSTANCE.createIn($this$createVertical, it);
    }

    private static final JComponent createComponent$lambda$24$lambda$23(CoroutineScope $this$bindChildIn, ComputedResult it) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)$this$bindChildIn, (String)"$this$bindChildIn");
        List threads2 = (List)ComputedResultKt.getOrNull-dyXsKJo((Result)it.unbox-impl());
        if (threads2 == null) {
            JComponent jComponent2;
            JLabel it2 = CollaborationToolsUIUtilKt.LoadingTextLabel();
            boolean bl = false;
            JComponent $this$createComponent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421 = jComponent2 = CollaborationToolsUIUtil.wrapWithLimitedSize$default((CollaborationToolsUIUtil)CollaborationToolsUIUtil.INSTANCE, (JComponent)it2, (Integer)CodeReviewChatItemUIUtil.INSTANCE.getTEXT_CONTENT_WIDTH(), null, (int)4, null);
            boolean bl2 = false;
            $this$createComponent_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421.setBorder(CodeReviewTimelineUIUtil.INSTANCE.getITEM_BORDER());
            jComponent = jComponent2;
        } else {
            jComponent = ComponentListPanelFactory.createVertical$default((ComponentListPanelFactory)ComponentListPanelFactory.INSTANCE, (CoroutineScope)$this$bindChildIn, (Flow)((Flow)StateFlowKt.MutableStateFlow((Object)threads2)), null, (int)0, GHPRTimelineItemComponentFactory::createComponent$lambda$24$lambda$23$lambda$22, (int)12, null);
        }
        return jComponent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Companion;", "", "<init>", "()V", "COMMIT_HREF_PREFIX", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GHPullRequestReviewState.values().length];
            try {
                nArray[GHPullRequestReviewState.APPROVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.CHANGES_REQUESTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.COMMENTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.DISMISSED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

