/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.spell.lists.WordList;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.grazie.dictionary.EditableWordListAdapter;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b0\fj\b\u0012\u0004\u0012\u00020\b`\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/WordListAdapter;", "Lai/grazie/spell/lists/WordList;", "Lcom/intellij/spellchecker/grazie/dictionary/EditableWordListAdapter;", "<init>", "()V", "isAlien", "", "word", "", "contains", "caseSensitive", "suggest", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nWordListAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordListAdapter.kt\ncom/intellij/spellchecker/grazie/dictionary/WordListAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1740#2,3:47\n1761#2,3:50\n1761#2,3:53\n*S KotlinDebug\n*F\n+ 1 WordListAdapter.kt\ncom/intellij/spellchecker/grazie/dictionary/WordListAdapter\n*L\n11#1:47,3\n16#1:50,3\n21#1:53,3\n*E\n"})
public final class WordListAdapter
extends EditableWordListAdapter
implements WordList {
    public final boolean isAlien(@NotNull String word) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Dictionary it = (Dictionary)element$iv;
                    boolean bl2 = false;
                    if (it.lookup(word) == Dictionary.LookupStatus.Alien) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl && !WordList.contains$default((WordList)this.getAggregator(), (String)word, (boolean)false, (int)2, null);
    }

    public boolean contains(@NotNull String word, boolean caseSensitive) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            if (caseSensitive) {
                Collection<Dictionary> collection = this.getDictionaries().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Dictionary it = (Dictionary)element$iv;
                        boolean bl2 = false;
                        if (!(it.lookup(word) == Dictionary.LookupStatus.Present)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                String string = word.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String lowered = string;
                Collection<Dictionary> collection = this.getDictionaries().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Dictionary it = (Dictionary)element$iv;
                        boolean bl3 = false;
                        if (!(it.lookup(word) == Dictionary.LookupStatus.Present || it.lookup(lowered) == Dictionary.LookupStatus.Present)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
        }
        boolean inDictionary = bl;
        return inDictionary || this.getAggregator().contains(word, caseSensitive);
    }

    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<Dictionary> iterator = this.getDictionaries().values().iterator();
        while (iterator.hasNext()) {
            Dictionary dictionary;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            dictionary.consumeSuggestions(word, (Consumer<String>)((Consumer)arg_0 -> WordListAdapter.suggest$lambda$3(word, result, arg_0)));
        }
        result.addAll((Collection)this.getAggregator().suggest(word));
        result.remove("");
        return result;
    }

    private static final void suggest$lambda$3(String $word, LinkedHashSet $result, String it) {
        Intrinsics.checkNotNull((Object)it);
        if (((CharSequence)it).length() == 0) {
            return;
        }
        int distance = Levenshtein.distance$default((String)$word, (String)it, (int)4, (boolean)false, (int)8, null);
        if (distance <= 3) {
            $result.add(it);
        }
    }
}

