/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.annotation.ThreadSafeAction;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.FrameTitleQuery;
import org.assertj.swing.driver.WindowDriver;
import org.assertj.swing.driver.WindowLikeContainers;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.ToolkitProvider;

@InternalApi
public class FrameDriver
extends WindowDriver {
    public FrameDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void iconify(@Nonnull Frame frame) {
        this.moveMouseIgnoringAnyError(frame, FrameDriver.iconifyInfo(frame));
        this.robot.waitForIdle();
        this.updateFrameExtendedState(frame, 1);
    }

    @RunsInEDT
    private static Point iconifyInfo(@Nonnull Frame frame) {
        return GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(frame);
            return WindowLikeContainers.iconifyButtonLocation(frame);
        });
    }

    @RunsInEDT
    public void deiconify(@Nonnull Frame frame) {
        FrameDriver.checkInEdtEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void normalize(@Nonnull Frame frame) {
        FrameDriver.checkInEdtEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void maximize(@Nonnull Frame frame) {
        this.moveMouseIgnoringAnyError(frame, FrameDriver.maximizeInfo(frame));
        if (!FrameDriver.supportsMaximize(ToolkitProvider.instance().defaultToolkit())) {
            throw ActionFailedException.actionFailure("Platform does not support maximizing frames");
        }
        this.updateFrameExtendedState(frame, 6);
    }

    @Nonnull
    @RunsInEDT
    private static Point maximizeInfo(@Nonnull Frame frame) {
        Point result = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(frame);
            return WindowLikeContainers.maximizeButtonLocation(frame);
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @ThreadSafeAction
    private void updateFrameExtendedState(@Nonnull Frame frame, int state) {
        frame.setExtendedState(state);
        this.robot.waitForIdle();
    }

    private static boolean supportsMaximize(@Nonnull Toolkit toolkit) {
        return toolkit.isFrameStateSupported(6);
    }

    @RunsInEDT
    public void requireTitle(@Nonnull Frame frame, String expected) {
        String actual = FrameTitleQuery.titleOf(frame);
        ((AbstractStringAssert)Assertions.assertThat((String)actual).as(FrameDriver.propertyName(frame, "title"))).isEqualTo(expected);
    }
}

