/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDoubleAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleCountIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleSumIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;

public class JRDoubleIncrementerFactory
implements JRIncrementerFactory {
    protected static final Double ZERO = new Double(0.0);
    private static JRDoubleIncrementerFactory mainInstance = new JRDoubleIncrementerFactory();

    private JRDoubleIncrementerFactory() {
    }

    public static JRDoubleIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRDoubleCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRDoubleSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRDoubleAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRDoubleStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRDoubleVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

