/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.util.ArrayList;
import java.util.List;

public class Brackets {
    private volatile List<Integer> offsets = null;
    int pos;

    public void invalidate() {
        this.offsets = null;
    }

    public int findMatchingBracket(String text, int pos) {
        int p;
        int direction;
        char beta;
        if (pos < 0 || pos > text.length()) {
            return -1;
        }
        char alpha = text.charAt(pos);
        switch (alpha) {
            case '(': {
                beta = ')';
                direction = 1;
                break;
            }
            case ')': {
                beta = '(';
                direction = -1;
                break;
            }
            case '[': {
                beta = ']';
                direction = 1;
                break;
            }
            case ']': {
                beta = '[';
                direction = -1;
                break;
            }
            case '{': {
                beta = '}';
                direction = 1;
                break;
            }
            case '}': {
                beta = '{';
                direction = -1;
                break;
            }
            default: {
                return -1;
            }
        }
        if (this.offsets == null) {
            this.parse(text);
        }
        for (p = 0; p < this.offsets.size() && this.offsets.get(p) != pos; ++p) {
        }
        if (p == this.offsets.size()) {
            return -1;
        }
        int depth = 1;
        p += direction;
        while (p >= 0 && p < this.offsets.size()) {
            int offset = this.offsets.get(p);
            char c = text.charAt(offset);
            if (c == alpha) {
                ++depth;
            } else if (c == beta) {
                --depth;
            }
            if (depth == 0) {
                return offset;
            }
            p += direction;
        }
        return -1;
    }

    private void parse(String text) {
        this.offsets = new ArrayList<Integer>();
        int len = text.length();
        this.pos = 0;
        while (this.pos < len) {
            char c = text.charAt(this.pos);
            if (c == '/' && this.pos < len - 1) {
                char d;
                if ((d = text.charAt(++this.pos)) == '/') {
                    this.readComment(text);
                } else if (d == '*') {
                    this.readMLComment(text);
                }
            } else if (c == '\"' || c == '\'') {
                this.readString(text, c);
            } else if (c == '{' || c == '[' || c == '(' || c == '}' || c == ']' || c == ')') {
                this.offsets.add(this.pos);
            }
            ++this.pos;
        }
    }

    private void readString(String text, char q) {
        int len = text.length();
        ++this.pos;
        while (this.pos < len) {
            char c = text.charAt(this.pos);
            if (c == q) {
                return;
            }
            if (c == '\\') {
                ++this.pos;
            }
            ++this.pos;
        }
    }

    private void readComment(String text) {
        int len = text.length();
        ++this.pos;
        while (this.pos < len) {
            if (text.charAt(this.pos) == '\n') {
                return;
            }
            ++this.pos;
        }
    }

    private void readMLComment(String text) {
        int len = text.length();
        ++this.pos;
        while (this.pos < len) {
            char c = text.charAt(this.pos);
            if (c == '*' && this.pos < len - 1) {
                ++this.pos;
                char d = text.charAt(this.pos);
                if (d == '/') {
                    return;
                }
            }
            ++this.pos;
        }
    }
}

