/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.util.HashMap;
import net.i2p.sam.SessionRecord;

class SessionsDB {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, SessionRecord> map = new HashMap();

    public synchronized void put(String nick, SessionRecord session) throws ExistingIdException, ExistingDestException {
        if (this.map.containsKey(nick)) {
            throw new ExistingIdException();
        }
        for (SessionRecord r : this.map.values()) {
            if (!r.getDest().equals(session.getDest())) continue;
            throw new ExistingDestException();
        }
        session.createThreadGroup("SAM session " + nick);
        this.map.put(nick, session);
    }

    public synchronized void putDupDestOK(String nick, SessionRecord session) throws ExistingIdException {
        if (this.map.containsKey(nick)) {
            throw new ExistingIdException();
        }
        session.createThreadGroup("SAM session " + nick);
        this.map.put(nick, session);
    }

    public synchronized boolean del(String nick) {
        return this.map.remove(nick) != null;
    }

    public synchronized SessionRecord get(String nick) {
        return this.map.get(nick);
    }

    public synchronized boolean containsKey(String nick) {
        return this.map.containsKey(nick);
    }

    static class ExistingDestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ExistingDestException() {
        }
    }

    static class ExistingIdException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ExistingIdException() {
        }
    }
}

