/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.dsn;

import com.sun.mail.util.LineOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;

public class DeliveryStatus {
    private static boolean debug = false;
    protected InternetHeaders messageDSN;
    protected InternetHeaders[] recipientDSN;

    public DeliveryStatus() throws MessagingException {
        this.messageDSN = new InternetHeaders();
        this.recipientDSN = new InternetHeaders[0];
    }

    public DeliveryStatus(InputStream inputStream) throws MessagingException, IOException {
        Vector<InternetHeaders> vector;
        block6: {
            this.messageDSN = new InternetHeaders(inputStream);
            if (debug) {
                System.out.println("DSN: got messageDSN");
            }
            vector = new Vector<InternetHeaders>();
            try {
                while (inputStream.available() > 0) {
                    InternetHeaders internetHeaders = new InternetHeaders(inputStream);
                    if (debug) {
                        System.out.println("DSN: got recipientDSN");
                    }
                    vector.addElement(internetHeaders);
                }
            }
            catch (EOFException eOFException) {
                if (!debug) break block6;
                System.out.println("DSN: got EOFException");
            }
        }
        if (debug) {
            System.out.println("DSN: recipientDSN size " + vector.size());
        }
        this.recipientDSN = new InternetHeaders[vector.size()];
        vector.copyInto(this.recipientDSN);
    }

    public InternetHeaders getMessageDSN() {
        return this.messageDSN;
    }

    public void setMessageDSN(InternetHeaders internetHeaders) {
        this.messageDSN = internetHeaders;
    }

    public int getRecipientDSNCount() {
        return this.recipientDSN.length;
    }

    public InternetHeaders getRecipientDSN(int n) {
        return this.recipientDSN[n];
    }

    public void addRecipientDSN(InternetHeaders internetHeaders) {
        InternetHeaders[] internetHeadersArray = new InternetHeaders[this.recipientDSN.length + 1];
        System.arraycopy(this.recipientDSN, 0, internetHeadersArray, 0, this.recipientDSN.length);
        this.recipientDSN = internetHeadersArray;
        this.recipientDSN[this.recipientDSN.length - 1] = internetHeaders;
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        LineOutputStream lineOutputStream = null;
        lineOutputStream = outputStream instanceof LineOutputStream ? (LineOutputStream)outputStream : new LineOutputStream(outputStream);
        DeliveryStatus.writeInternetHeaders(this.messageDSN, lineOutputStream);
        lineOutputStream.writeln();
        int n = 0;
        while (n < this.recipientDSN.length) {
            DeliveryStatus.writeInternetHeaders(this.recipientDSN[n], lineOutputStream);
            lineOutputStream.writeln();
            ++n;
        }
    }

    private static void writeInternetHeaders(InternetHeaders internetHeaders, LineOutputStream lineOutputStream) throws IOException {
        Enumeration enumeration = internetHeaders.getAllHeaderLines();
        try {
            while (enumeration.hasMoreElements()) {
                lineOutputStream.writeln((String)enumeration.nextElement());
            }
        }
        catch (MessagingException messagingException) {
            Exception exception = messagingException.getNextException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Exception writing headers: " + (Object)((Object)messagingException));
        }
    }

    public String toString() {
        return "DeliveryStatus: Reporting-MTA=" + this.messageDSN.getHeader("Reporting-MTA", null) + ", #Recipients=" + this.recipientDSN.length;
    }

    static {
        try {
            String string = System.getProperty("mail.dsn.debug");
            debug = string != null && !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

