"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateMetrics = aggregateMetrics;
exports.createNullableGetterSetter = createNullableGetterSetter;
exports.extractFieldsFromMappings = extractFieldsFromMappings;
exports.setSecurityAnalyticsPluginConfig = exports.getSecurityAnalyticsPluginConfig = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../server/utils/constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function aggregateMetrics(metrics, currentMetricsCounter) {
  const partialMetrics = {
    ...currentMetricsCounter
  };
  Object.keys(metrics).forEach(w => {
    const workflow = w;
    const workFlowMetrics = metrics[workflow];
    if (workFlowMetrics) {
      const counterToUpdate = partialMetrics[workflow] || _lodash.default.cloneDeep(_constants.DEFAULT_METRICS_COUNTER[workflow]);
      Object.entries(workFlowMetrics).forEach(([metric, count]) => {
        if (!counterToUpdate[metric]) {
          counterToUpdate[metric] = 0;
        }
        counterToUpdate[metric] += count;
      });
      partialMetrics[workflow] = counterToUpdate;
    }
  });
  return partialMetrics;
}
let securityAnalyticsPluginConfig;
const setSecurityAnalyticsPluginConfig = config => {
  securityAnalyticsPluginConfig = config;
};
exports.setSecurityAnalyticsPluginConfig = setSecurityAnalyticsPluginConfig;
const getSecurityAnalyticsPluginConfig = () => securityAnalyticsPluginConfig;
exports.getSecurityAnalyticsPluginConfig = getSecurityAnalyticsPluginConfig;
function extractFieldsFromMappings(properties, fields, parentField = '') {
  Object.keys(properties).forEach(field => {
    if (properties[field].hasOwnProperty('properties')) {
      extractFieldsFromMappings(properties[field]['properties'], fields, parentField ? `${parentField}.${field}` : field);
    } else {
      fields.push(parentField ? `${parentField}.${field}` : field);
    }
  });
}
function createNullableGetterSetter() {
  let value;
  const get = () => {
    return value;
  };
  const set = newValue => {
    value = newValue;
  };
  return [get, set];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbG9kYXNoIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfY29uc3RhbnRzIiwiZSIsIl9fZXNNb2R1bGUiLCJkZWZhdWx0IiwiYWdncmVnYXRlTWV0cmljcyIsIm1ldHJpY3MiLCJjdXJyZW50TWV0cmljc0NvdW50ZXIiLCJwYXJ0aWFsTWV0cmljcyIsIk9iamVjdCIsImtleXMiLCJmb3JFYWNoIiwidyIsIndvcmtmbG93Iiwid29ya0Zsb3dNZXRyaWNzIiwiY291bnRlclRvVXBkYXRlIiwiXyIsImNsb25lRGVlcCIsIkRFRkFVTFRfTUVUUklDU19DT1VOVEVSIiwiZW50cmllcyIsIm1ldHJpYyIsImNvdW50Iiwic2VjdXJpdHlBbmFseXRpY3NQbHVnaW5Db25maWciLCJzZXRTZWN1cml0eUFuYWx5dGljc1BsdWdpbkNvbmZpZyIsImNvbmZpZyIsImV4cG9ydHMiLCJnZXRTZWN1cml0eUFuYWx5dGljc1BsdWdpbkNvbmZpZyIsImV4dHJhY3RGaWVsZHNGcm9tTWFwcGluZ3MiLCJwcm9wZXJ0aWVzIiwiZmllbGRzIiwicGFyZW50RmllbGQiLCJmaWVsZCIsImhhc093blByb3BlcnR5IiwicHVzaCIsImNyZWF0ZU51bGxhYmxlR2V0dGVyU2V0dGVyIiwidmFsdWUiLCJnZXQiLCJzZXQiLCJuZXdWYWx1ZSJdLCJzb3VyY2VzIjpbImhlbHBlcnMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgXyBmcm9tICdsb2Rhc2gnO1xuaW1wb3J0IHsgREVGQVVMVF9NRVRSSUNTX0NPVU5URVIgfSBmcm9tICcuLi9zZXJ2ZXIvdXRpbHMvY29uc3RhbnRzJztcbmltcG9ydCB7IE1ldHJpY3NDb3VudGVyLCBQYXJ0aWFsTWV0cmljc0NvdW50ZXIgfSBmcm9tICcuLi90eXBlcyc7XG5pbXBvcnQgeyBTZWN1cml0eUFuYWx5dGljc1BsdWdpbkNvbmZpZ1R5cGUgfSBmcm9tICcuLi9jb25maWcnO1xuaW1wb3J0IHsgR2V0LCBTZXQgfSBmcm9tICcuLi8uLi8uLi9zcmMvcGx1Z2lucy9vcGVuc2VhcmNoX2Rhc2hib2FyZHNfdXRpbHMvY29tbW9uJztcblxuZXhwb3J0IGZ1bmN0aW9uIGFnZ3JlZ2F0ZU1ldHJpY3MoXG4gIG1ldHJpY3M6IFBhcnRpYWxNZXRyaWNzQ291bnRlcixcbiAgY3VycmVudE1ldHJpY3NDb3VudGVyOiBQYXJ0aWFsTWV0cmljc0NvdW50ZXJcbik6IE1ldHJpY3NDb3VudGVyIHtcbiAgY29uc3QgcGFydGlhbE1ldHJpY3M6IFBhcnRpYWxNZXRyaWNzQ291bnRlciA9IHtcbiAgICAuLi5jdXJyZW50TWV0cmljc0NvdW50ZXIsXG4gIH07XG4gIE9iamVjdC5rZXlzKG1ldHJpY3MpLmZvckVhY2goKHcpID0+IHtcbiAgICBjb25zdCB3b3JrZmxvdyA9IHcgYXMga2V5b2YgTWV0cmljc0NvdW50ZXI7XG4gICAgY29uc3Qgd29ya0Zsb3dNZXRyaWNzID0gbWV0cmljc1t3b3JrZmxvd107XG5cbiAgICBpZiAod29ya0Zsb3dNZXRyaWNzKSB7XG4gICAgICBjb25zdCBjb3VudGVyVG9VcGRhdGU6IGFueSA9XG4gICAgICAgIHBhcnRpYWxNZXRyaWNzW3dvcmtmbG93XSB8fCBfLmNsb25lRGVlcChERUZBVUxUX01FVFJJQ1NfQ09VTlRFUlt3b3JrZmxvd10pO1xuICAgICAgT2JqZWN0LmVudHJpZXMod29ya0Zsb3dNZXRyaWNzKS5mb3JFYWNoKChbbWV0cmljLCBjb3VudF0pID0+IHtcbiAgICAgICAgaWYgKCFjb3VudGVyVG9VcGRhdGVbbWV0cmljXSkge1xuICAgICAgICAgIGNvdW50ZXJUb1VwZGF0ZVttZXRyaWNdID0gMDtcbiAgICAgICAgfVxuICAgICAgICBjb3VudGVyVG9VcGRhdGVbbWV0cmljXSArPSBjb3VudDtcbiAgICAgIH0pO1xuXG4gICAgICBwYXJ0aWFsTWV0cmljc1t3b3JrZmxvd10gPSBjb3VudGVyVG9VcGRhdGU7XG4gICAgfVxuICB9KTtcblxuICByZXR1cm4gcGFydGlhbE1ldHJpY3MgYXMgTWV0cmljc0NvdW50ZXI7XG59XG5cbmxldCBzZWN1cml0eUFuYWx5dGljc1BsdWdpbkNvbmZpZzogU2VjdXJpdHlBbmFseXRpY3NQbHVnaW5Db25maWdUeXBlO1xuZXhwb3J0IGNvbnN0IHNldFNlY3VyaXR5QW5hbHl0aWNzUGx1Z2luQ29uZmlnID0gKGNvbmZpZzogU2VjdXJpdHlBbmFseXRpY3NQbHVnaW5Db25maWdUeXBlKSA9PiB7XG4gIHNlY3VyaXR5QW5hbHl0aWNzUGx1Z2luQ29uZmlnID0gY29uZmlnO1xufTtcblxuZXhwb3J0IGNvbnN0IGdldFNlY3VyaXR5QW5hbHl0aWNzUGx1Z2luQ29uZmlnID0gKCk6IFNlY3VyaXR5QW5hbHl0aWNzUGx1Z2luQ29uZmlnVHlwZSB8IHVuZGVmaW5lZCA9PlxuICBzZWN1cml0eUFuYWx5dGljc1BsdWdpbkNvbmZpZztcblxuZXhwb3J0IGZ1bmN0aW9uIGV4dHJhY3RGaWVsZHNGcm9tTWFwcGluZ3MoXG4gIHByb3BlcnRpZXM6IGFueSxcbiAgZmllbGRzOiBzdHJpbmdbXSxcbiAgcGFyZW50RmllbGQ6IHN0cmluZyA9ICcnXG4pIHtcbiAgT2JqZWN0LmtleXMocHJvcGVydGllcykuZm9yRWFjaCgoZmllbGQpID0+IHtcbiAgICBpZiAocHJvcGVydGllc1tmaWVsZF0uaGFzT3duUHJvcGVydHkoJ3Byb3BlcnRpZXMnKSkge1xuICAgICAgZXh0cmFjdEZpZWxkc0Zyb21NYXBwaW5ncyhcbiAgICAgICAgcHJvcGVydGllc1tmaWVsZF1bJ3Byb3BlcnRpZXMnXSxcbiAgICAgICAgZmllbGRzLFxuICAgICAgICBwYXJlbnRGaWVsZCA/IGAke3BhcmVudEZpZWxkfS4ke2ZpZWxkfWAgOiBmaWVsZFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgZmllbGRzLnB1c2gocGFyZW50RmllbGQgPyBgJHtwYXJlbnRGaWVsZH0uJHtmaWVsZH1gIDogZmllbGQpO1xuICAgIH1cbiAgfSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjcmVhdGVOdWxsYWJsZUdldHRlclNldHRlcjxUPigpOiBbR2V0PFQgfCB1bmRlZmluZWQ+LCBTZXQ8VD5dIHtcbiAgbGV0IHZhbHVlOiBUO1xuXG4gIGNvbnN0IGdldCA9ICgpID0+IHtcbiAgICByZXR1cm4gdmFsdWU7XG4gIH07XG5cbiAgY29uc3Qgc2V0ID0gKG5ld1ZhbHVlOiBUKSA9PiB7XG4gICAgdmFsdWUgPSBuZXdWYWx1ZTtcbiAgfTtcblxuICByZXR1cm4gW2dldCwgc2V0XTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBS0EsSUFBQUEsT0FBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQUMsVUFBQSxHQUFBRCxPQUFBO0FBQW9FLFNBQUFELHVCQUFBRyxDQUFBLFdBQUFBLENBQUEsSUFBQUEsQ0FBQSxDQUFBQyxVQUFBLEdBQUFELENBQUEsS0FBQUUsT0FBQSxFQUFBRixDQUFBO0FBTnBFO0FBQ0E7QUFDQTtBQUNBOztBQVFPLFNBQVNHLGdCQUFnQkEsQ0FDOUJDLE9BQThCLEVBQzlCQyxxQkFBNEMsRUFDNUI7RUFDaEIsTUFBTUMsY0FBcUMsR0FBRztJQUM1QyxHQUFHRDtFQUNMLENBQUM7RUFDREUsTUFBTSxDQUFDQyxJQUFJLENBQUNKLE9BQU8sQ0FBQyxDQUFDSyxPQUFPLENBQUVDLENBQUMsSUFBSztJQUNsQyxNQUFNQyxRQUFRLEdBQUdELENBQXlCO0lBQzFDLE1BQU1FLGVBQWUsR0FBR1IsT0FBTyxDQUFDTyxRQUFRLENBQUM7SUFFekMsSUFBSUMsZUFBZSxFQUFFO01BQ25CLE1BQU1DLGVBQW9CLEdBQ3hCUCxjQUFjLENBQUNLLFFBQVEsQ0FBQyxJQUFJRyxlQUFDLENBQUNDLFNBQVMsQ0FBQ0Msa0NBQXVCLENBQUNMLFFBQVEsQ0FBQyxDQUFDO01BQzVFSixNQUFNLENBQUNVLE9BQU8sQ0FBQ0wsZUFBZSxDQUFDLENBQUNILE9BQU8sQ0FBQyxDQUFDLENBQUNTLE1BQU0sRUFBRUMsS0FBSyxDQUFDLEtBQUs7UUFDM0QsSUFBSSxDQUFDTixlQUFlLENBQUNLLE1BQU0sQ0FBQyxFQUFFO1VBQzVCTCxlQUFlLENBQUNLLE1BQU0sQ0FBQyxHQUFHLENBQUM7UUFDN0I7UUFDQUwsZUFBZSxDQUFDSyxNQUFNLENBQUMsSUFBSUMsS0FBSztNQUNsQyxDQUFDLENBQUM7TUFFRmIsY0FBYyxDQUFDSyxRQUFRLENBQUMsR0FBR0UsZUFBZTtJQUM1QztFQUNGLENBQUMsQ0FBQztFQUVGLE9BQU9QLGNBQWM7QUFDdkI7QUFFQSxJQUFJYyw2QkFBZ0U7QUFDN0QsTUFBTUMsZ0NBQWdDLEdBQUlDLE1BQXlDLElBQUs7RUFDN0ZGLDZCQUE2QixHQUFHRSxNQUFNO0FBQ3hDLENBQUM7QUFBQ0MsT0FBQSxDQUFBRixnQ0FBQSxHQUFBQSxnQ0FBQTtBQUVLLE1BQU1HLGdDQUFnQyxHQUFHQSxDQUFBLEtBQzlDSiw2QkFBNkI7QUFBQ0csT0FBQSxDQUFBQyxnQ0FBQSxHQUFBQSxnQ0FBQTtBQUV6QixTQUFTQyx5QkFBeUJBLENBQ3ZDQyxVQUFlLEVBQ2ZDLE1BQWdCLEVBQ2hCQyxXQUFtQixHQUFHLEVBQUUsRUFDeEI7RUFDQXJCLE1BQU0sQ0FBQ0MsSUFBSSxDQUFDa0IsVUFBVSxDQUFDLENBQUNqQixPQUFPLENBQUVvQixLQUFLLElBQUs7SUFDekMsSUFBSUgsVUFBVSxDQUFDRyxLQUFLLENBQUMsQ0FBQ0MsY0FBYyxDQUFDLFlBQVksQ0FBQyxFQUFFO01BQ2xETCx5QkFBeUIsQ0FDdkJDLFVBQVUsQ0FBQ0csS0FBSyxDQUFDLENBQUMsWUFBWSxDQUFDLEVBQy9CRixNQUFNLEVBQ05DLFdBQVcsR0FBSSxHQUFFQSxXQUFZLElBQUdDLEtBQU0sRUFBQyxHQUFHQSxLQUM1QyxDQUFDO0lBQ0gsQ0FBQyxNQUFNO01BQ0xGLE1BQU0sQ0FBQ0ksSUFBSSxDQUFDSCxXQUFXLEdBQUksR0FBRUEsV0FBWSxJQUFHQyxLQUFNLEVBQUMsR0FBR0EsS0FBSyxDQUFDO0lBQzlEO0VBQ0YsQ0FBQyxDQUFDO0FBQ0o7QUFFTyxTQUFTRywwQkFBMEJBLENBQUEsRUFBb0M7RUFDNUUsSUFBSUMsS0FBUTtFQUVaLE1BQU1DLEdBQUcsR0FBR0EsQ0FBQSxLQUFNO0lBQ2hCLE9BQU9ELEtBQUs7RUFDZCxDQUFDO0VBRUQsTUFBTUUsR0FBRyxHQUFJQyxRQUFXLElBQUs7SUFDM0JILEtBQUssR0FBR0csUUFBUTtFQUNsQixDQUFDO0VBRUQsT0FBTyxDQUFDRixHQUFHLEVBQUVDLEdBQUcsQ0FBQztBQUNuQiJ9