"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPE = exports.TOTAL_SHARDS = exports.TIME_UNIT_ABBREVIATION = exports.TIME_UNITS_TEXT = exports.TIME_UNIT = exports.TIMESTAMP = exports.SEARCH_TYPE = exports.QUERY_COUNT = exports.NODE_ID = exports.MetricType = exports.MINUTES_OPTIONS = exports.METRIC_TYPES_TEXT = exports.MEMORY_USAGE = exports.LATENCY = exports.INDICES = exports.ID = exports.GROUP_BY_OPTIONS = exports.GROUP_BY = exports.EXPORTER_TYPES_LIST = exports.EXPORTER_TYPE = exports.DEFAULT_WINDOW_SIZE = exports.DEFAULT_TOP_N_SIZE = exports.DEFAULT_TIME_UNIT = exports.DEFAULT_METRIC_ENABLED = exports.DEFAULT_GROUP_BY = exports.DEFAULT_EXPORTER_TYPE = exports.DEFAULT_DELETE_AFTER_DAYS = exports.CPU_TIME = exports.AVERAGE_MEMORY_USAGE = exports.AVERAGE_LATENCY = exports.AVERAGE_CPU_TIME = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const TIMESTAMP = exports.TIMESTAMP = 'Timestamp';
const TYPE = exports.TYPE = 'Type';
const ID = exports.ID = 'Id';
const QUERY_COUNT = exports.QUERY_COUNT = 'Query Count';
const LATENCY = exports.LATENCY = 'Latency';
const CPU_TIME = exports.CPU_TIME = 'CPU Time';
const MEMORY_USAGE = exports.MEMORY_USAGE = 'Memory Usage';
const INDICES = exports.INDICES = 'Indices';
const SEARCH_TYPE = exports.SEARCH_TYPE = 'Search Type';
const NODE_ID = exports.NODE_ID = 'Coordinator Node ID';
const TOTAL_SHARDS = exports.TOTAL_SHARDS = 'Total Shards';
const GROUP_BY = exports.GROUP_BY = 'Group by';
const AVERAGE_LATENCY = exports.AVERAGE_LATENCY = 'Average Latency';
const AVERAGE_CPU_TIME = exports.AVERAGE_CPU_TIME = 'Average CPU Time';
const AVERAGE_MEMORY_USAGE = exports.AVERAGE_MEMORY_USAGE = 'Average Memory Usage';
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const MetricType = exports.MetricType = {
  LATENCY: 'latency',
  CPU: 'cpu',
  MEMORY: 'memory'
};
const METRIC_TYPES_TEXT = exports.METRIC_TYPES_TEXT = [{
  value: MetricType.LATENCY,
  text: 'Latency'
}, {
  value: MetricType.CPU,
  text: 'CPU'
}, {
  value: MetricType.MEMORY,
  text: 'Memory'
}];
const TIME_UNITS_TEXT = exports.TIME_UNITS_TEXT = [{
  value: 'MINUTES',
  text: 'Minute(s)'
}, {
  value: 'HOURS',
  text: 'Hour(s)'
}];
const MINUTES_OPTIONS = exports.MINUTES_OPTIONS = [{
  value: '1',
  text: '1'
}, {
  value: '5',
  text: '5'
}, {
  value: '10',
  text: '10'
}, {
  value: '30',
  text: '30'
}];
const GROUP_BY_OPTIONS = exports.GROUP_BY_OPTIONS = [{
  value: 'none',
  text: 'None'
}, {
  value: 'similarity',
  text: 'Similarity'
}];
const TIME_UNIT = exports.TIME_UNIT = {
  MINUTES: 'MINUTES',
  HOURS: 'HOURS'
};
const TIME_UNIT_ABBREVIATION = exports.TIME_UNIT_ABBREVIATION = {
  MINUTES: 'm',
  HOURS: 'h'
};
const EXPORTER_TYPE = exports.EXPORTER_TYPE = {
  localIndex: 'local_index',
  none: 'none'
};
const EXPORTER_TYPES_LIST = exports.EXPORTER_TYPES_LIST = [{
  value: EXPORTER_TYPE.localIndex,
  text: 'Local Index'
}, {
  value: EXPORTER_TYPE.none,
  text: 'None'
}];
const DEFAULT_METRIC_ENABLED = exports.DEFAULT_METRIC_ENABLED = true;
const DEFAULT_TOP_N_SIZE = exports.DEFAULT_TOP_N_SIZE = '10';
const DEFAULT_WINDOW_SIZE = exports.DEFAULT_WINDOW_SIZE = '5';
const DEFAULT_TIME_UNIT = exports.DEFAULT_TIME_UNIT = TIME_UNIT.MINUTES;
const DEFAULT_GROUP_BY = exports.DEFAULT_GROUP_BY = 'none';
const DEFAULT_EXPORTER_TYPE = exports.DEFAULT_EXPORTER_TYPE = EXPORTER_TYPE.localIndex;
const DEFAULT_DELETE_AFTER_DAYS = exports.DEFAULT_DELETE_AFTER_DAYS = '7';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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