"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ALLOWED_FILE_EXTENSIONS", {
  enumerable: true,
  get: function () {
    return _shared.ALLOWED_FILE_EXTENSIONS;
  }
});
exports.MAPS_APP_ICON = exports.MAPBOX_GL_DRAW_MODES = exports.MAPBOX_GL_DRAW_CREATE_LISTENER = exports.LAYER_VISIBILITY = exports.LAYER_PANEL_SHOW_LAYER_ICON = exports.LAYER_PANEL_HIDE_LAYER_ICON = exports.LAYER_ICON_TYPE_MAP = exports.FILTER_DRAW_MODE = exports.FALLBACK_LANGUAGE = exports.DRAW_FILTER_SPATIAL_RELATIONS = exports.DRAW_FILTER_SHAPE_TITLE = exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = exports.DRAW_FILTER_RECTANGLE = exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = exports.DRAW_FILTER_POLYGON = exports.DRAW_FILTER_CANCEL = exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MIN_MARKER_SIZE = exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MIN_LABEL_SIZE = exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MAX_MARKER_SIZE = exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MAX_LABEL_SIZE = exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_TOOLTIPS = exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = exports.DOCUMENTS_DEFAULT_MARKER_SIZE = exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_LABEL_SIZE = exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = exports.DOCUMENTS_DEFAULT_LABEL_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = exports.DOCUMENTS = exports.DEFAULT_VECTOR_TILE_STYLES = exports.DASHBOARDS_MAPS_LAYER_TYPE = exports.DASHBOARDS_MAPS_LAYER_NAME = exports.DASHBOARDS_MAPS_LAYER_ICON = exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = exports.CUSTOM_MAP = exports.CLUSTER_MIN_BORDER_THICKNESS = exports.CLUSTER_MAX_BORDER_THICKNESS = exports.CLUSTER_DEFAULT_PRECISION = exports.CLUSTER_DEFAULT_PALETTE = exports.CLUSTER_DEFAULT_METRIC_AGG = exports.CLUSTER_DEFAULT_MARKER_BORDER_THICKNESS = exports.CLUSTER_DEFAULT_FILL_TYPE = exports.CLUSTER_DEFAULT_CLUSTER_AGG = exports.CLUSTER = exports.APP_PATH = exports.APP_API = void 0;
Object.defineProperty(exports, "MAPS_APP_ID", {
  enumerable: true,
  get: function () {
    return _shared.MAPS_APP_ID;
  }
});
exports.MAP_SAVED_OBJECT_TYPE = exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = exports.MAP_LAYER_DEFAULT_OPACITY_STEP = exports.MAP_LAYER_DEFAULT_NAME = exports.MAP_LAYER_DEFAULT_MIN_OPACITY = exports.MAP_LAYER_DEFAULT_MAX_OPACITY = exports.MAP_INITIAL_STATE = exports.MAP_DEFAULT_MIN_ZOOM = exports.MAP_DEFAULT_MAX_ZOOM = exports.MAP_DATA_LAYER_DEFAULT_OPACITY = exports.MAPS_VISUALIZATION_DESCRIPTION = void 0;
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE;
  }
});
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE_IN_MB", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE_IN_MB;
  }
});
exports.PER_PAGE_REQUEST_NUMBER = exports.OSD_LANGUAGES = exports.OPENSEARCH_MAP_LAYER = exports.NEW_MAP_LAYER_DEFAULT_PREFIX = exports.MIN_LONGITUDE = exports.MAX_LONGITUDE = exports.MAX_LAYER_NAME_LIMIT = exports.MAX_LAYER_LIMIT = void 0;
Object.defineProperty(exports, "PLUGIN_ID", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_ID;
  }
});
Object.defineProperty(exports, "PLUGIN_NAME", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_NAME;
  }
});
exports.TOOLTIP_STATE = void 0;
Object.defineProperty(exports, "fromMBtoBytes", {
  enumerable: true,
  get: function () {
    return _util.fromMBtoBytes;
  }
});
var _util = require("./util");
var _shared = require("./constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const DOCUMENTS_DEFAULT_MARKER_SIZE = exports.DOCUMENTS_DEFAULT_MARKER_SIZE = 5;
const DOCUMENTS_MIN_MARKER_SIZE = exports.DOCUMENTS_MIN_MARKER_SIZE = 0;
const DOCUMENTS_MAX_MARKER_SIZE = exports.DOCUMENTS_MAX_MARKER_SIZE = 100;
const DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = 1;
const DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = 0;
const DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = 100;
const DOCUMENTS_DEFAULT_REQUEST_NUMBER = exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = 1000;
const DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = false;
const DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = true;
const DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = true;
const DOCUMENTS_DEFAULT_TOOLTIPS = exports.DOCUMENTS_DEFAULT_TOOLTIPS = [];
const DOCUMENTS_DEFAULT_LABEL_ENABLES = exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = false;
let DOCUMENTS_LABEL_TEXT_TYPE = exports.DOCUMENTS_LABEL_TEXT_TYPE = /*#__PURE__*/function (DOCUMENTS_LABEL_TEXT_TYPE) {
  DOCUMENTS_LABEL_TEXT_TYPE["BY_FIELD"] = "by_field";
  DOCUMENTS_LABEL_TEXT_TYPE["FIXED"] = "fixed";
  return DOCUMENTS_LABEL_TEXT_TYPE;
}({});
const DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE.BY_FIELD;
const DOCUMENTS_DEFAULT_LABEL_SIZE = exports.DOCUMENTS_DEFAULT_LABEL_SIZE = 15;
const DOCUMENTS_MIN_LABEL_SIZE = exports.DOCUMENTS_MIN_LABEL_SIZE = 1;
const DOCUMENTS_MAX_LABEL_SIZE = exports.DOCUMENTS_MAX_LABEL_SIZE = 100;
const DOCUMENTS_DEFAULT_LABEL_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_COLOR = '#000000';
const DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = '#FFFFFF';
const DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = 20;
const DOCUMENTS_NONE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = 0;
const DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = 2;
const DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = 5;
const DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = 10;
const LAYER_PANEL_HIDE_LAYER_ICON = exports.LAYER_PANEL_HIDE_LAYER_ICON = 'eyeClosed';
const LAYER_PANEL_SHOW_LAYER_ICON = exports.LAYER_PANEL_SHOW_LAYER_ICON = 'eye';
const MAP_DATA_LAYER_DEFAULT_OPACITY = exports.MAP_DATA_LAYER_DEFAULT_OPACITY = 70;
const MAP_DEFAULT_MAX_ZOOM = exports.MAP_DEFAULT_MAX_ZOOM = 22;
const MAP_DEFAULT_MIN_ZOOM = exports.MAP_DEFAULT_MIN_ZOOM = 0;
const MAP_LAYER_DEFAULT_MAX_OPACITY = exports.MAP_LAYER_DEFAULT_MAX_OPACITY = 100;
const MAP_LAYER_DEFAULT_MIN_OPACITY = exports.MAP_LAYER_DEFAULT_MIN_OPACITY = 0;
const MAP_LAYER_DEFAULT_NAME = exports.MAP_LAYER_DEFAULT_NAME = 'Default map';
const MAP_LAYER_DEFAULT_OPACITY_STEP = exports.MAP_LAYER_DEFAULT_OPACITY_STEP = 1;
const MAP_REFERENCE_LAYER_DEFAULT_OPACITY = exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = 100;
// Make this configurable from map settings
const MAX_LAYER_LIMIT = exports.MAX_LAYER_LIMIT = 100;
const MAX_LAYER_NAME_LIMIT = exports.MAX_LAYER_NAME_LIMIT = 35;
const MAX_LONGITUDE = exports.MAX_LONGITUDE = 180;
const MIN_LONGITUDE = exports.MIN_LONGITUDE = -180;
const NEW_MAP_LAYER_DEFAULT_PREFIX = exports.NEW_MAP_LAYER_DEFAULT_PREFIX = 'New layer';
const MAP_SAVED_OBJECT_TYPE = exports.MAP_SAVED_OBJECT_TYPE = 'map';
// TODO: Replace with actual app icon
const MAPS_APP_ICON = exports.MAPS_APP_ICON = 'gisApp';
const MAPS_VISUALIZATION_DESCRIPTION = exports.MAPS_VISUALIZATION_DESCRIPTION = 'Create map visualization with multiple layers';
const CLUSTER_DEFAULT_FILL_TYPE = exports.CLUSTER_DEFAULT_FILL_TYPE = 'gradient';
const CLUSTER_DEFAULT_PALETTE = exports.CLUSTER_DEFAULT_PALETTE = 'blue';
const CLUSTER_MIN_BORDER_THICKNESS = exports.CLUSTER_MIN_BORDER_THICKNESS = 0;
const CLUSTER_MAX_BORDER_THICKNESS = exports.CLUSTER_MAX_BORDER_THICKNESS = 100;
const CLUSTER_DEFAULT_MARKER_BORDER_THICKNESS = exports.CLUSTER_DEFAULT_MARKER_BORDER_THICKNESS = 1;
//This is a valid value in geohex,geotile and geohash aggregation.
const CLUSTER_DEFAULT_PRECISION = exports.CLUSTER_DEFAULT_PRECISION = 2;
const CLUSTER_DEFAULT_METRIC_AGG = exports.CLUSTER_DEFAULT_METRIC_AGG = 'count';
const CLUSTER_DEFAULT_CLUSTER_AGG = exports.CLUSTER_DEFAULT_CLUSTER_AGG = 'geohash_grid';

// Starting position [lng, lat] and zoom
const MAP_INITIAL_STATE = exports.MAP_INITIAL_STATE = {
  lng: 0,
  lat: 0,
  zoom: 1
};
const APP_PATH = exports.APP_PATH = {
  LANDING_PAGE_PATH: '/',
  CREATE_MAP: '/create',
  EDIT_MAP: '/:id',
  STATS: '/stats'
};
const APP_API = exports.APP_API = '/api/maps-dashboards';
let DASHBOARDS_MAPS_LAYER_NAME = exports.DASHBOARDS_MAPS_LAYER_NAME = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_NAME) {
  DASHBOARDS_MAPS_LAYER_NAME["OPENSEARCH_MAP"] = "OpenSearch map";
  DASHBOARDS_MAPS_LAYER_NAME["DOCUMENTS"] = "Documents";
  DASHBOARDS_MAPS_LAYER_NAME["CUSTOM_MAP"] = "Custom map";
  DASHBOARDS_MAPS_LAYER_NAME["CLUSTER"] = "Cluster";
  return DASHBOARDS_MAPS_LAYER_NAME;
}({});
let DASHBOARDS_MAPS_LAYER_TYPE = exports.DASHBOARDS_MAPS_LAYER_TYPE = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_TYPE) {
  DASHBOARDS_MAPS_LAYER_TYPE["OPENSEARCH_MAP"] = "opensearch_vector_tile_map";
  DASHBOARDS_MAPS_LAYER_TYPE["DOCUMENTS"] = "documents";
  DASHBOARDS_MAPS_LAYER_TYPE["CUSTOM_MAP"] = "custom_map";
  DASHBOARDS_MAPS_LAYER_TYPE["CLUSTER"] = "cluster";
  return DASHBOARDS_MAPS_LAYER_TYPE;
}({});
let DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = /*#__PURE__*/function (DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE) {
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["WMS"] = "wms";
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["TMS"] = "tms";
  return DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE;
}({});
let DASHBOARDS_MAPS_LAYER_ICON = exports.DASHBOARDS_MAPS_LAYER_ICON = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_ICON) {
  DASHBOARDS_MAPS_LAYER_ICON["OPENSEARCH_MAP"] = "globe";
  DASHBOARDS_MAPS_LAYER_ICON["DOCUMENTS"] = "document";
  DASHBOARDS_MAPS_LAYER_ICON["CUSTOM_MAP"] = "globe";
  DASHBOARDS_MAPS_LAYER_ICON["CLUSTER"] = "heatmap";
  return DASHBOARDS_MAPS_LAYER_ICON;
}({});
let DASHBOARDS_MAPS_LAYER_DESCRIPTION = exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_DESCRIPTION) {
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["OPENSEARCH_MAP"] = "Use default OpenSearch basemaps.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["DOCUMENTS"] = "View points, lines, and polygons on the map.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["CUSTOM_MAP"] = "Configure maps to use a custom map source.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["CLUSTER"] = "Geospatial data grouped to show density.";
  return DASHBOARDS_MAPS_LAYER_DESCRIPTION;
}({});
const DOCUMENTS = exports.DOCUMENTS = {
  name: DASHBOARDS_MAPS_LAYER_NAME.DOCUMENTS,
  type: DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS,
  icon: DASHBOARDS_MAPS_LAYER_ICON.DOCUMENTS,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.DOCUMENTS
};
const CLUSTER = exports.CLUSTER = {
  name: DASHBOARDS_MAPS_LAYER_NAME.CLUSTER,
  type: DASHBOARDS_MAPS_LAYER_TYPE.CLUSTER,
  icon: DASHBOARDS_MAPS_LAYER_ICON.CLUSTER,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.CLUSTER
};
const OPENSEARCH_MAP_LAYER = exports.OPENSEARCH_MAP_LAYER = {
  name: DASHBOARDS_MAPS_LAYER_NAME.OPENSEARCH_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.OPENSEARCH_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.OPENSEARCH_MAP
};
const CUSTOM_MAP = exports.CUSTOM_MAP = {
  name: DASHBOARDS_MAPS_LAYER_NAME.CUSTOM_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.CUSTOM_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.CUSTOM_MAP
};
const LAYER_VISIBILITY = exports.LAYER_VISIBILITY = {
  NONE: 'none',
  VISIBLE: 'visible'
};
const LAYER_ICON_TYPE_MAP = exports.LAYER_ICON_TYPE_MAP = {
  [DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP]: 'globe',
  [DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS]: 'document',
  [DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP]: 'globe',
  [DASHBOARDS_MAPS_LAYER_TYPE.CLUSTER]: 'heatmap'
};

// refer https://github.com/opensearch-project/i18n-plugin/blob/main/DEVELOPER_GUIDE.md#new-locale for OSD supported languages
const OSD_LANGUAGES = exports.OSD_LANGUAGES = ['en', 'es', 'fr', 'de', 'ja', 'ko', 'zh']; // all these codes are also supported in vector tiles map
const FALLBACK_LANGUAGE = exports.FALLBACK_LANGUAGE = 'en';
let TOOLTIP_STATE = exports.TOOLTIP_STATE = /*#__PURE__*/function (TOOLTIP_STATE) {
  TOOLTIP_STATE["DISPLAY_FEATURES"] = "DISPLAY_FEATURES";
  TOOLTIP_STATE["FILTER_DRAW_SHAPE"] = "FILTER_DRAW_SHAPE";
  return TOOLTIP_STATE;
}({});
let FILTER_DRAW_MODE = exports.FILTER_DRAW_MODE = /*#__PURE__*/function (FILTER_DRAW_MODE) {
  FILTER_DRAW_MODE["NONE"] = "none";
  FILTER_DRAW_MODE["POLYGON"] = "polygon";
  FILTER_DRAW_MODE["RECTANGLE"] = "rectangle";
  return FILTER_DRAW_MODE;
}({}); // Filter is active and set to draw rectangle
const MAPBOX_GL_DRAW_CREATE_LISTENER = exports.MAPBOX_GL_DRAW_CREATE_LISTENER = 'draw.create';
let MAPBOX_GL_DRAW_MODES = exports.MAPBOX_GL_DRAW_MODES = /*#__PURE__*/function (MAPBOX_GL_DRAW_MODES) {
  MAPBOX_GL_DRAW_MODES["DRAW_POLYGON"] = "draw_polygon";
  MAPBOX_GL_DRAW_MODES["DRAW_RECTANGLE"] = "draw_rectangle";
  MAPBOX_GL_DRAW_MODES["SIMPLE_SELECT"] = "simple_select";
  return MAPBOX_GL_DRAW_MODES;
}({});
const DRAW_FILTER_SHAPE_TITLE = exports.DRAW_FILTER_SHAPE_TITLE = 'DRAW SHAPE';
const DRAW_FILTER_POLYGON_DEFAULT_LABEL = exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = 'polygon';
const DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = 'rectangle';
const DRAW_FILTER_POLYGON = exports.DRAW_FILTER_POLYGON = 'Draw Polygon';
const DRAW_FILTER_CANCEL = exports.DRAW_FILTER_CANCEL = 'Cancel';
const DRAW_FILTER_RECTANGLE = exports.DRAW_FILTER_RECTANGLE = 'Draw Rectangle';
const DRAW_FILTER_SPATIAL_RELATIONS = exports.DRAW_FILTER_SPATIAL_RELATIONS = ['intersects', 'disjoint', 'within'];
const PER_PAGE_REQUEST_NUMBER = exports.PER_PAGE_REQUEST_NUMBER = 50;
const DEFAULT_VECTOR_TILE_STYLES = exports.DEFAULT_VECTOR_TILE_STYLES = {
  BASIC: 'basic',
  DARK: 'dark'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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