/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginNode;

@Plugin(name="PipelineRouting", category="Core", elementType="appender", printObject=true, deferChildren=true)
public class PipelineRoutingAppender
extends AbstractAppender {
    private final Node appenderNode;
    private final Configuration configuration;
    private final ConcurrentMap<String, AppenderControl> createdAppenders = new ConcurrentHashMap<String, AppenderControl>();
    private final Map<String, AppenderControl> createdAppendersUnmodifiableView = Collections.unmodifiableMap(this.createdAppenders);

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    protected PipelineRoutingAppender(String name, Node appenderNode, Configuration configuration) {
        super(name, null, null, false, new Property[0]);
        this.appenderNode = appenderNode;
        this.configuration = configuration;
    }

    public Map<String, AppenderControl> getAppenders() {
        return this.createdAppendersUnmodifiableView;
    }

    public void append(LogEvent event) {
        AppenderControl appenderControl = this.getControl(event);
        if (appenderControl != null) {
            appenderControl.callAppender(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppenderControl getControl(LogEvent event) {
        String key = (String)event.getContextData().getValue("pipeline.id");
        if (key == null) {
            LOGGER.debug("Unable to find the pipeline.id in event's context data in routing appender, skip it");
            return null;
        }
        AppenderControl appenderControl = (AppenderControl)this.createdAppenders.get(key);
        if (appenderControl == null) {
            PipelineRoutingAppender pipelineRoutingAppender = this;
            synchronized (pipelineRoutingAppender) {
                appenderControl = (AppenderControl)this.createdAppenders.get(key);
                if (appenderControl == null) {
                    AppenderControl created;
                    Appender app = this.createAppender(event);
                    if (app == null) {
                        return null;
                    }
                    appenderControl = created = new AppenderControl(app, null, null);
                    this.createdAppenders.put(key, created);
                }
            }
        }
        return appenderControl;
    }

    private Appender createAppender(LogEvent event) {
        for (Node node : this.appenderNode.getChildren()) {
            if (!node.getType().getElementName().equals("appender")) continue;
            Node appNode = new Node(node);
            this.configuration.createConfiguration(appNode, event);
            if (appNode.getObject() instanceof Appender) {
                Appender app = (Appender)appNode.getObject();
                app.start();
                return app;
            }
            this.error("Unable to create Appender of type " + node.getName());
            return null;
        }
        this.error("No Appender was configured for  " + this.getName());
        return null;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<PipelineRoutingAppender> {
        @PluginNode
        private Node appenderNode;

        public PipelineRoutingAppender build() {
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name defined for this RoutingAppender");
                return null;
            }
            return new PipelineRoutingAppender(name, this.appenderNode, this.getConfiguration());
        }
    }
}

