/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.health.ApiHealthReport;
import org.logstash.health.MultiIndicator;
import org.logstash.health.PipelineIndicator;
import org.logstash.health.Status;

public class HealthObserver {
    private static final Logger LOGGER = LogManager.getLogger();
    static final String FORCE_API_STATUS_PROPERTY = "logstash.forceApiStatus";
    private final MultiIndicator rootIndicator = new MultiIndicator();
    private final MultiIndicator pipelinesIndicator = new MultiIndicator();

    public HealthObserver() {
        this.rootIndicator.attachIndicator("pipelines", this.pipelinesIndicator);
    }

    public final Status getStatus() {
        String forceApiStatus = System.getProperty(FORCE_API_STATUS_PROPERTY);
        if (forceApiStatus != null) {
            if (forceApiStatus.equals("green")) {
                return Status.GREEN;
            }
            LOGGER.warn("Unsupported `logstash.forceApiStatus`: {} (health report status will be propagated)", (Object)forceApiStatus);
        }
        return this.getReport().getStatus();
    }

    public MultiIndicator getIndicator() {
        return this.rootIndicator;
    }

    public ApiHealthReport getReport() {
        return new ApiHealthReport((MultiIndicator.Report)this.rootIndicator.report());
    }

    public void attachPipelineIndicator(String pipelineId, PipelineIndicator.PipelineDetailsProvider detailsProvider) {
        try {
            this.pipelinesIndicator.attachIndicator(pipelineId, PipelineIndicator.forPipeline(pipelineId, detailsProvider));
            LOGGER.debug(String.format("attached pipeline indicator [%s]", pipelineId));
        }
        catch (Exception e) {
            LOGGER.warn(String.format("failed to attach pipeline indicator [%s]", pipelineId), (Throwable)e);
        }
    }

    public void detachPipelineIndicator(String pipelineId) {
        try {
            this.pipelinesIndicator.detachIndicator(pipelineId, null);
            LOGGER.debug(String.format("detached pipeline indicator [%s]", pipelineId));
        }
        catch (Exception e) {
            LOGGER.warn(String.format("failed to detach pipeline indicator [%s]", pipelineId), (Throwable)e);
        }
    }
}

