/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;

public final class DeclaredNamespaces {
    private HashMap namespaces;

    public DeclaredNamespaces() {
    }

    public DeclaredNamespaces(DeclaredNamespaces namespaces) {
        if (namespaces == null) {
            throw new NullPointerException();
        }
        if (namespaces.namespaces != null) {
            this.namespaces = (HashMap)namespaces.namespaces.clone();
        }
    }

    public DeclaredNamespaces add(HashMap newNamespaces) {
        if (newNamespaces == null) {
            throw new NullPointerException();
        }
        DeclaredNamespaces retval = new DeclaredNamespaces();
        retval.namespaces = this.namespaces == null ? new HashMap() : (HashMap)this.namespaces.clone();
        for (Map.Entry entry : newNamespaces.entrySet()) {
            String value = (String)entry.getValue();
            String o = (String)entry.getKey();
            if (value == null || o == null) {
                throw new NullPointerException();
            }
            retval.namespaces.put(o, value);
        }
        return retval;
    }

    public DeclaredNamespaces add(AttributeList attributes) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        DeclaredNamespaces retval = null;
        AttributeList.AttributeEntry[] entries = attributes.toArray();
        for (int i = 0; i < entries.length; ++i) {
            AttributeList.AttributeEntry entry = entries[i];
            String prefix = entry.getName();
            if ("xmlns".equals(prefix)) {
                if (entry.getNamespace() != null && !"".equals(entry.getNamespace())) continue;
                if (retval == null) {
                    retval = new DeclaredNamespaces();
                    retval.namespaces = this.namespaces != null ? (HashMap)this.namespaces.clone() : new HashMap();
                }
                retval.namespaces.put(entry.getValue(), "");
                continue;
            }
            if (!"http://www.w3.org/2000/xmlns/".equals(entry.getNamespace())) continue;
            if (retval == null) {
                retval = new DeclaredNamespaces();
                retval.namespaces = this.namespaces != null ? (HashMap)this.namespaces.clone() : new HashMap();
            }
            retval.namespaces.put(entry.getValue(), prefix);
        }
        if (retval == null) {
            return this;
        }
        return retval;
    }

    public DeclaredNamespaces add(String uri, String prefix) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (prefix == null) {
            throw new NullPointerException();
        }
        DeclaredNamespaces retval = new DeclaredNamespaces();
        retval.namespaces = this.namespaces == null ? new HashMap() : (HashMap)this.namespaces.clone();
        retval.namespaces.put(uri, prefix);
        return retval;
    }

    public String getPrefix(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (this.namespaces == null) {
            return null;
        }
        return (String)this.namespaces.get(uri);
    }

    public boolean isNamespaceDefined(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (this.namespaces == null) {
            return false;
        }
        return this.namespaces.containsKey(uri);
    }

    public Map getNamespaces() {
        return Collections.unmodifiableMap(this.namespaces);
    }

    public boolean isPrefixDefined(String prefix) {
        return this.namespaces.containsValue(prefix);
    }
}

