/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.security.SecureRandom;
import java.util.Random;

public class SecretGenerator {
    public static final int SECRET_LENGTH_256_BITS = 32;
    public static final int SECRET_LENGTH_384_BITS = 48;
    public static final int SECRET_LENGTH_512_BITS = 64;
    public static final char[] UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] DIGITS = "0123456789".toCharArray();
    public static final char[] ALPHANUM = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final SecretGenerator instance = new SecretGenerator();
    private ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new SecureRandom();
        }
    };

    private SecretGenerator() {
    }

    public static SecretGenerator getInstance() {
        return instance;
    }

    public String generateSecureID() {
        StringBuilder builder = new StringBuilder(instance.randomBytesHex(16));
        builder.insert(8, '-');
        builder.insert(13, '-');
        builder.insert(18, '-');
        builder.insert(23, '-');
        return builder.toString();
    }

    public String randomString() {
        return this.randomString(32, ALPHANUM);
    }

    public String randomString(int length) {
        return this.randomString(length, ALPHANUM);
    }

    public String randomString(int length, char[] symbols) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if (symbols == null || symbols.length < 2) {
            throw new IllegalArgumentException();
        }
        Random r = this.random.get();
        char[] buf = new char[length];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = symbols[r.nextInt(symbols.length)];
        }
        return new String(buf);
    }

    public byte[] randomBytes() {
        return this.randomBytes(32);
    }

    public byte[] randomBytes(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[length];
        this.random.get().nextBytes(buf);
        return buf;
    }

    public String randomBytesHex(int length) {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.randomBytes(length)) {
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }

    public static int equivalentEntropySize(int byteLengthEntropy, int dstAlphabetLeng) {
        return SecretGenerator.equivalentEntropySize(byteLengthEntropy, 256, dstAlphabetLeng);
    }

    public static int equivalentEntropySize(int length, int srcAlphabetLength, int dstAlphabetLeng) {
        return (int)Math.ceil((double)length * (Math.log(srcAlphabetLength) / Math.log(dstAlphabetLeng)));
    }
}

