/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email.freemarker;

import java.io.IOException;
import java.text.Bidi;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.email.freemarker.beans.EventBean;
import org.keycloak.email.freemarker.beans.ProfileBean;
import org.keycloak.events.Event;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.freemarker.model.UrlBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.LinkExpirationFormatterMethod;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.freemarker.FreeMarkerProvider;

public class FreeMarkerEmailTemplateProvider
implements EmailTemplateProvider {
    protected KeycloakSession session;
    protected AuthenticationSessionModel authenticationSession;
    protected FreeMarkerProvider freeMarker;
    protected RealmModel realm;
    protected UserModel user;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    public FreeMarkerEmailTemplateProvider(KeycloakSession session) {
        this.session = session;
        this.freeMarker = (FreeMarkerProvider)session.getProvider(FreeMarkerProvider.class);
    }

    public EmailTemplateProvider setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public EmailTemplateProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public EmailTemplateProvider setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public EmailTemplateProvider setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
        return this;
    }

    protected String getRealmName() {
        if (this.realm.getDisplayName() != null) {
            return this.realm.getDisplayName();
        }
        return ObjectUtil.capitalize((String)this.realm.getName());
    }

    public void sendEvent(Event event) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        attributes.put("event", new EventBean(event));
        this.send(this.toCamelCase(event.getType()) + "Subject", "event-" + event.getType().toString().toLowerCase() + ".ftl", attributes);
    }

    public void sendPasswordReset(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        this.send("passwordResetSubject", "password-reset.ftl", attributes);
    }

    public void sendSmtpTestEmail(Map<String, String> config, UserModel user) throws EmailException {
        this.setRealm(this.session.getContext().getRealm());
        this.setUser(user);
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        EmailTemplate email = this.processTemplate("emailTestSubject", Collections.emptyList(), "email-test.ftl", attributes);
        this.send(config, email.getSubject(), email.getTextBody(), email.getHtmlBody());
    }

    public void sendConfirmIdentityBrokerLink(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
        String idpAlias = brokerContext.getIdpConfig().getAlias();
        String idpDisplayName = brokerContext.getIdpConfig().getDisplayName();
        if (ObjectUtil.isBlank((CharSequence)idpDisplayName)) {
            idpDisplayName = ObjectUtil.capitalize((String)idpAlias);
        }
        attributes.put("identityProviderContext", brokerContext);
        attributes.put("identityProviderAlias", idpAlias);
        attributes.put("identityProviderDisplayName", idpDisplayName);
        List<Object> subjectAttrs = Collections.singletonList(idpDisplayName);
        this.send("identityProviderLinkSubject", subjectAttrs, "identity-provider-link.ftl", attributes);
    }

    public void sendExecuteActions(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        this.send("executeActionsSubject", "executeActions.ftl", attributes);
    }

    public void sendVerifyEmail(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        this.send("emailVerificationSubject", "email-verification.ftl", attributes);
    }

    public void sendOrgInviteEmail(OrganizationModel organization, String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        attributes.put("organization", organization);
        if (this.user.getFirstName() != null && this.user.getLastName() != null) {
            attributes.put("firstName", this.user.getFirstName());
            attributes.put("lastName", this.user.getLastName());
        }
        this.send("orgInviteSubject", List.of(organization.getName()), "org-invite.ftl", attributes);
    }

    public void sendEmailUpdateConfirmation(String link, long expirationInMinutes, String newEmail) throws EmailException {
        if (newEmail == null) {
            throw new IllegalArgumentException("The new email is mandatory");
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        attributes.put("newEmail", newEmail);
        this.send("emailUpdateConfirmationSubject", Collections.emptyList(), "email-update-confirmation.ftl", attributes, newEmail);
    }

    protected void addLinkInfoIntoAttributes(String link, long expirationInMinutes, Map<String, Object> attributes) throws EmailException {
        attributes.put("link", link);
        attributes.put("linkExpiration", expirationInMinutes);
        try {
            Locale locale = this.session.getContext().resolveLocale(this.user, Boolean.parseBoolean(String.valueOf(attributes.get("IGNORE_ACCEPT_LANGUAGE_HEADER"))));
            attributes.put("linkExpirationFormatter", new LinkExpirationFormatterMethod(this.getTheme().getMessages(locale), locale));
        }
        catch (IOException e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }

    public void send(String subjectFormatKey, String bodyTemplate, Map<String, Object> bodyAttributes) throws EmailException {
        this.send(subjectFormatKey, Collections.emptyList(), bodyTemplate, bodyAttributes);
    }

    protected EmailTemplate processTemplate(String subjectKey, List<Object> subjectAttributes, String template, Map<String, Object> attributes) throws EmailException {
        try {
            String htmlBody;
            String textBody;
            Locale locale = this.session.getContext().resolveLocale(this.user, Boolean.parseBoolean(String.valueOf(attributes.get("IGNORE_ACCEPT_LANGUAGE_HEADER"))));
            attributes.put("locale", locale);
            Theme theme = this.getTheme();
            Properties messages = theme.getEnhancedMessages(this.realm, locale);
            String currentLanguageTag = locale.getLanguage();
            String currentLanguage = messages.getProperty("locale_" + currentLanguageTag, currentLanguageTag);
            boolean isLtr = new Bidi(currentLanguage, -2).isLeftToRight();
            attributes.put("ltr", isLtr);
            attributes.put("msg", new MessageFormatterMethod(locale, messages));
            attributes.put("properties", theme.getProperties());
            attributes.put("realmName", this.getRealmName());
            attributes.put("user", new ProfileBean(this.user, this.session));
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            attributes.put("url", new UrlBean(this.realm, theme, uriInfo.getBaseUri(), null));
            String subject = new MessageFormat(messages.getProperty(subjectKey, subjectKey), locale).format(subjectAttributes.toArray());
            String textTemplate = String.format("text/%s", template);
            try {
                textBody = this.freeMarker.processTemplate(attributes, textTemplate, theme);
            }
            catch (FreeMarkerException e) {
                throw new EmailException("Failed to template plain text email.", (Throwable)e);
            }
            String htmlTemplate = String.format("html/%s", template);
            try {
                htmlBody = this.freeMarker.processTemplate(attributes, htmlTemplate, theme);
            }
            catch (FreeMarkerException e) {
                throw new EmailException("Failed to template html email.", (Throwable)e);
            }
            return new EmailTemplate(subject, textBody, htmlBody);
        }
        catch (Exception e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }

    protected Theme getTheme() throws IOException {
        return this.session.theme().getTheme(Theme.Type.EMAIL);
    }

    public void send(String subjectFormatKey, List<Object> subjectAttributes, String bodyTemplate, Map<String, Object> bodyAttributes) throws EmailException {
        this.send(subjectFormatKey, subjectAttributes, bodyTemplate, bodyAttributes, null);
    }

    protected void send(String subjectFormatKey, List<Object> subjectAttributes, String bodyTemplate, Map<String, Object> bodyAttributes, String address) throws EmailException {
        try {
            EmailTemplate email = this.processTemplate(subjectFormatKey, subjectAttributes, bodyTemplate, bodyAttributes);
            this.send(email.getSubject(), email.getTextBody(), email.getHtmlBody(), address);
        }
        catch (EmailException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }

    protected void send(String subject, String textBody, String htmlBody, String address) throws EmailException {
        this.send(this.realm.getSmtpConfig(), subject, textBody, htmlBody, address);
    }

    protected void send(Map<String, String> config, String subject, String textBody, String htmlBody) throws EmailException {
        this.send(config, subject, textBody, htmlBody, null);
    }

    protected void send(Map<String, String> config, String subject, String textBody, String htmlBody, String address) throws EmailException {
        EmailSenderProvider emailSender = (EmailSenderProvider)this.session.getProvider(EmailSenderProvider.class);
        if (address == null) {
            emailSender.send(config, this.user, subject, textBody, htmlBody);
        } else {
            emailSender.send(config, address, subject, textBody, htmlBody);
        }
    }

    public void close() {
    }

    protected String toCamelCase(EventType event) {
        StringBuilder sb = new StringBuilder("event");
        for (String s : event.name().toLowerCase().split("_")) {
            sb.append(ObjectUtil.capitalize((String)s));
        }
        return sb.toString();
    }

    protected static class EmailTemplate {
        private String subject;
        private String textBody;
        private String htmlBody;

        public EmailTemplate(String subject, String textBody, String htmlBody) {
            this.subject = subject;
            this.textBody = textBody;
            this.htmlBody = htmlBody;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getTextBody() {
            return this.textBody;
        }

        public String getHtmlBody() {
            return this.htmlBody;
        }
    }
}

