/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="PropertiesSeparatorManager")
public final class PropertiesSeparatorManager
implements PersistentStateComponent<PropertiesSeparatorManagerState> {
    private PropertiesSeparatorManagerState myUserDefinedSeparators = new PropertiesSeparatorManagerState();
    private final SoftFactoryMap<ResourceBundleImpl, String> myGuessedSeparators = new SoftFactoryMap<ResourceBundleImpl, String>(){

        protected String create(@NotNull ResourceBundleImpl resourceBundle) {
            if (resourceBundle == null) {
                1.$$$reportNull$$$0(0);
            }
            return PropertiesSeparatorManager.guessSeparator(resourceBundle);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/structureView/PropertiesSeparatorManager$1", "create"));
        }
    };

    public static PropertiesSeparatorManager getInstance(Project project) {
        return (PropertiesSeparatorManager)project.getService(PropertiesSeparatorManager.class);
    }

    @NotNull
    public String getSeparator(ResourceBundle resourceBundle) {
        if (!(resourceBundle instanceof ResourceBundleImpl)) {
            return ".";
        }
        ResourceBundleImpl resourceBundleImpl = (ResourceBundleImpl)resourceBundle;
        String separator = this.myUserDefinedSeparators.getSeparators().get(resourceBundleImpl.getUrl());
        String string = separator == null ? Objects.requireNonNull((String)this.myGuessedSeparators.get((Object)resourceBundleImpl)) : separator;
        if (string == null) {
            PropertiesSeparatorManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String guessSeparator(ResourceBundleImpl resourceBundle) {
        final Int2LongOpenHashMap charCounts = new Int2LongOpenHashMap();
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (propertiesFile == null) continue;
            List properties = propertiesFile.getProperties();
            for (IProperty property : properties) {
                String key = property.getUnescapedKey();
                if (key == null) continue;
                for (int i = 0; i < key.length(); ++i) {
                    char c = key.charAt(i);
                    if (Character.isLetterOrDigit(c)) continue;
                    charCounts.put((int)c, charCounts.get((int)c) + 1L);
                }
            }
        }
        final char[] mostProbableChar = new char[]{'.'};
        charCounts.keySet().forEach(new IntConsumer(){
            long count = -1L;

            @Override
            public void accept(int ch) {
                long charCount = charCounts.get(ch);
                if (charCount > this.count) {
                    this.count = charCount;
                    mostProbableChar[0] = (char)ch;
                }
            }
        });
        if (mostProbableChar[0] == '\u0000') {
            mostProbableChar[0] = 46;
        }
        return Character.toString(mostProbableChar[0]);
    }

    public void setSeparator(ResourceBundle resourceBundle, String separator) {
        if (resourceBundle instanceof ResourceBundleImpl) {
            this.myUserDefinedSeparators.getSeparators().put(((ResourceBundleImpl)resourceBundle).getUrl(), separator);
        }
    }

    public void loadState(@NotNull PropertiesSeparatorManagerState state) {
        if (state == null) {
            PropertiesSeparatorManager.$$$reportNull$$$0(1);
        }
        this.myUserDefinedSeparators = state.decode();
    }

    @Nullable
    public PropertiesSeparatorManagerState getState() {
        return this.myUserDefinedSeparators.isEmpty() ? null : this.myUserDefinedSeparators.encode();
    }

    @Nullable
    private static String decodeSeparator(String separator) {
        if (separator.length() % 6 != 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int pos = 0; pos < separator.length(); pos += 6) {
            String encodedCharacter = separator.substring(pos, pos + 6);
            if (!encodedCharacter.startsWith("\\u")) {
                return null;
            }
            char code = (char)Integer.parseInt(encodedCharacter.substring(2), 16);
            result.append(code);
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/structureView/PropertiesSeparatorManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/structureView/PropertiesSeparatorManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class PropertiesSeparatorManagerState {
        @Property(surroundWithTag=false)
        @XMap(keyAttributeName="url", valueAttributeName="separator", entryTagName="file")
        public Map<String, String> mySeparators = new HashMap<String, String>();

        public Map<String, String> getSeparators() {
            return this.mySeparators;
        }

        public boolean isEmpty() {
            return this.mySeparators.isEmpty();
        }

        public PropertiesSeparatorManagerState encode() {
            PropertiesSeparatorManagerState encodedState = new PropertiesSeparatorManagerState();
            for (Map.Entry<String, String> entry : this.mySeparators.entrySet()) {
                String separator = entry.getValue();
                StringBuilder encoded = new StringBuilder(separator.length());
                for (int i = 0; i < separator.length(); ++i) {
                    char c = separator.charAt(i);
                    encoded.append("\\u");
                    encoded.append(String.format("%04x", c));
                }
                encodedState.getSeparators().put(entry.getKey(), encoded.toString());
            }
            return encodedState;
        }

        public PropertiesSeparatorManagerState decode() {
            PropertiesSeparatorManagerState decoded = new PropertiesSeparatorManagerState();
            for (Map.Entry<String, String> entry : this.mySeparators.entrySet()) {
                String separator = entry.getValue();
                if ((separator = PropertiesSeparatorManager.decodeSeparator(separator)) == null) continue;
                String url = entry.getKey();
                decoded.getSeparators().put(url, separator);
            }
            return decoded;
        }
    }
}

