/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineFunctionHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineNamedFunctionDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.InlineUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\f\u0010\u000f\u001a\u00020\u0006*\u00020\u0002H\u0002J\u001c\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineNamedFunctionHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineFunctionHandler;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "<init>", "()V", "canInlineKotlinFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "inlineKotlinFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isRecursive", "includesCallOf", "Lorg/jetbrains/kotlin/psi/KtExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinInlineNamedFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInlineNamedFunctionHandler.kt\norg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineNamedFunctionHandler\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,66:1\n73#2:67\n384#3:68\n395#3,10:69\n417#3:79\n*S KotlinDebug\n*F\n+ 1 KotlinInlineNamedFunctionHandler.kt\norg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineNamedFunctionHandler\n*L\n43#1:67\n61#1:68\n61#1:69,10\n61#1:79\n*E\n"})
public final class KotlinInlineNamedFunctionHandler
extends AbstractKotlinInlineFunctionHandler<KtNamedFunction> {
    @Override
    public boolean canInlineKotlinFunction(@NotNull KtFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return function instanceof KtNamedFunction && !ExpressionExtKt.isAnonymousFunction((KtNamedFunction)function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inlineKotlinFunction(@NotNull Project project, @Nullable Editor editor, @NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Editor editor2 = editor;
        PsiReference nameReference = editor2 != null ? InlineUtilsKt.findSimpleNameReference(editor2) : null;
        boolean recursive = this.isRecursive(function);
        if (recursive && nameReference == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.inline.recursive.function.is.supported.only.on.references", (Object[])new Object[0]));
            Intrinsics.checkNotNull((Object)message2);
            this.showErrorHint(project, editor, message2);
            return;
        }
        KotlinInlineNamedFunctionDialog dialog2 = new KotlinInlineNamedFunctionDialog(function, nameReference, editor, recursive);
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            dialog2.show();
        } else {
            try {
                dialog2.doAction();
            }
            finally {
                dialog2.close(0, true);
            }
        }
    }

    private final boolean isRecursive(KtNamedFunction $this$isRecursive) {
        boolean bl;
        BindingContext context = ResolutionUtils.analyzeWithContent((KtDeclaration)$this$isRecursive);
        KtExpression ktExpression = $this$isRecursive.getBodyExpression();
        if (ktExpression != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)$this$isRecursive);
            if (simpleFunctionDescriptor == null) {
                return false;
            }
            bl = this.includesCallOf(ktExpression, (FunctionDescriptor)simpleFunctionDescriptor, context);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean includesCallOf(KtExpression $this$includesCallOf, FunctionDescriptor descriptor2, BindingContext context) {
        void $this$findDescendantOfType$iv$iv$iv;
        void $this$findDescendantOfType$iv$iv;
        void $this$anyDescendantOfType$iv;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$includesCallOf), (BindingContext)context);
        CallableDescriptor refDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        if (Intrinsics.areEqual((Object)descriptor2, (Object)refDescriptor)) return true;
        PsiElement psiElement = (PsiElement)$this$includesCallOf;
        Function1 predicate$iv = arg_0 -> KotlinInlineNamedFunctionHandler.includesCallOf$lambda$0($this$includesCallOf, descriptor2, context, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void var8_8 = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        void var11_11 = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean includesCallOf$lambda$0(KtExpression $this_includesCallOf, FunctionDescriptor $descriptor, BindingContext $context, KtExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it == $this_includesCallOf) return false;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)$context);
        if (!Intrinsics.areEqual((Object)$descriptor, (Object)(resolvedCall != null ? resolvedCall.getResultingDescriptor() : null))) return false;
        return true;
    }
}

