/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.CleanupFix;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNameFromFunctionExpressionFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/CleanupFix$ModCommand;", "element", "wereAutoLabelUsages", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Z)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.fir.frontend-independent"})
public final class RemoveNameFromFunctionExpressionFix
extends PsiUpdateModCommandAction<KtNamedFunction>
implements CleanupFix.ModCommand {
    private final boolean wereAutoLabelUsages;

    public RemoveNameFromFunctionExpressionFix(@NotNull KtNamedFunction element, boolean wereAutoLabelUsages) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.wereAutoLabelUsages = wereAutoLabelUsages;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"remove.identifier.from.anonymous.function", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull KtNamedFunction element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Name name2 = element.getNameAsName();
        if (name2 == null) {
            return;
        }
        Name name3 = name2;
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement != null) {
            psiElement.delete();
        }
        if (this.wereAutoLabelUsages) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            Object[] objectArray = new Object[]{name3, element};
            KtExpression newFunction = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0@ $1", (Object[])objectArray, (boolean)false, (int)4, null);
            element.replace((PsiElement)newFunction);
        }
    }
}

