/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.surroundWith;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ-\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder;", "Lcom/intellij/lang/surroundWith/Surrounder;", "<init>", "()V", "isApplicable", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "surroundElements", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "getTemplateDescription", "", "SurroundWithCastWorker", "kotlin.jvm-debugger.evaluation.k1"})
public final class KotlinRuntimeTypeCastSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (elements.length != 1 || !(elements[0] instanceof KtExpression)) {
            return false;
        }
        PsiElement psiElement = elements[0];
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        KtExpression expression = (KtExpression)psiElement;
        if (expression instanceof KtCallExpression && ((KtCallExpression)expression).getParent() instanceof KtQualifiedExpression) {
            return false;
        }
        if (!expression.isPhysical()) {
            return false;
        }
        PsiFile file = expression.getContainingFile();
        if (!(file instanceof KtCodeFragment)) {
            return false;
        }
        KotlinType kotlinType = ResolutionUtils.analyze((KtElement)expression, BodyResolveMode.PARTIAL).getType(expression);
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        return TypeUtils.canHaveSubtypes((KotlinTypeChecker)KotlinTypeChecker.DEFAULT, (KotlinType)type2);
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
            Object object = ArraysKt.singleOrNull((Object[])elements);
            KtExpression ktExpression = object instanceof KtExpression ? (KtExpression)object : null;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression = ktExpression;
            DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx((Project)project).getContext();
            Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getContext(...)");
            DebuggerContextImpl debuggerContext = debuggerContextImpl;
            DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
            if (debuggerSession == null) break block2;
            ProgressWindow progressWindow = new ProgressWindow(true, expression.getProject());
            SurroundWithCastWorker worker2 = new SurroundWithCastWorker(editor, expression, debuggerContext, (ProgressIndicator)progressWindow);
            progressWindow.setTitle(JavaDebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            DebuggerManagerThreadImpl debuggerManagerThreadImpl = debuggerContext.getManagerThread();
            if (debuggerManagerThreadImpl != null) {
                debuggerManagerThreadImpl.startProgress((DebuggerCommandImpl)worker2, progressWindow);
            }
        }
        return null;
    }

    @NotNull
    public String getTemplateDescription() {
        return KotlinDebuggerEvaluationBundle.message("surround.with.runtime.type.cast.template", new Object[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder$SurroundWithCastWorker;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluator;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "typeCalculationFinished", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.jvm-debugger.evaluation.k1"})
    private final class SurroundWithCastWorker
    extends KotlinRuntimeTypeEvaluator {
        @NotNull
        private final Editor myEditor;

        public SurroundWithCastWorker(@NotNull Editor myEditor, @NotNull KtExpression expression, @NotNull DebuggerContextImpl context, ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            super(myEditor, expression, context, indicator);
            this.myEditor = myEditor;
        }

        @Override
        protected void typeCalculationFinished(@Nullable KotlinType type2) {
            if (type2 == null) {
                return;
            }
            this.hold();
            Project project = this.myEditor.getProject();
            DebuggerInvocationUtil.invokeLater((Project)project, () -> SurroundWithCastWorker.typeCalculationFinished$lambda$1(project, this, type2), (ModalityState)this.myProgressIndicator.getModalityState());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void typeCalculationFinished$lambda$1$lambda$0(SurroundWithCastWorker this$0, KotlinType $type) {
            try {
                Project project = this$0.myElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
                ClassifierDescriptor classifierDescriptor = $type.getConstructor().getDeclarationDescriptor();
                Intrinsics.checkNotNull((Object)classifierDescriptor);
                FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
                Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
                FqNameUnsafe fqName2 = fqNameUnsafe;
                KtExpression ktExpression = factory2.createExpression("(expr as " + fqName2.asString() + ")");
                Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtParenthesizedExpression parentCast = (KtParenthesizedExpression)ktExpression;
                KtExpression ktExpression2 = parentCast.getExpression();
                Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS");
                KtBinaryExpressionWithTypeRHS cast = (KtBinaryExpressionWithTypeRHS)ktExpression2;
                cast.getLeft().replace(this$0.myElement);
                PsiElement psiElement = this$0.myElement.replace((PsiElement)parentCast);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                KtExpression expr = (KtExpression)psiElement;
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)expr, null, 2, null);
                TextRange range2 = expr.getTextRange();
                this$0.myEditor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
                this$0.myEditor.getCaretModel().moveToOffset(range2.getEndOffset());
                this$0.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
            finally {
                this$0.release();
            }
        }

        private static final void typeCalculationFinished$lambda$1(Project $project, SurroundWithCastWorker this$0, KotlinType $type) {
            WriteCommandAction.writeCommandAction((Project)$project).withName(JavaDebuggerBundle.message((String)"command.name.surround.with.runtime.cast", (Object[])new Object[0])).run(() -> SurroundWithCastWorker.typeCalculationFinished$lambda$1$lambda$0(this$0, $type));
        }
    }
}

