/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinDebuggerConstants;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrameInfo;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.LambdaName;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinInlineFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.KotlinStepOverFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.KotlinStepOverParamDefaultImplsMethodFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.LocationToken;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\n\u0010\u0012\u001a\u00020\u000b*\u00020\u0013\u001a \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0019\u001a\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\u001d\u001a\u00020\u000b*\u00020\u0016H\u0002\u00a8\u0006\u001e"}, d2={"getSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "getStepOverAction", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepAction;", "location", "Lcom/sun/jdi/Location;", "suspendContext", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "isOnFunctionDeclaration", "", "positionManager", "Lcom/intellij/debugger/PositionManager;", "getContainingNamedFunction", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "createKotlinInlineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinInlineFilter;", "isSyntheticMethodForDefaultParameters", "Lcom/sun/jdi/Method;", "isInlineFunctionFromLibrary", "token", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/LocationToken;", "getLineRange", "Lkotlin/ranges/IntRange;", "Lcom/intellij/psi/PsiElement;", "getStepOutAction", "createStepOutMethodWithDefaultArgsActionIfNeeded", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepAction$StepOut;", "isInsideOneLineInlineLambda", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinSteppingCommandProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSteppingCommandProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinSteppingCommandProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,322:1\n1#2:323\n536#3:324\n521#3,6:325\n1563#4:331\n1634#4,3:332\n66#5,2:335\n67#5:337\n*S KotlinDebug\n*F\n+ 1 KotlinSteppingCommandProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinSteppingCommandProviderKt\n*L\n138#1:324\n138#1:325,6\n300#1:331\n300#1:332,3\n205#1:335,2\n214#1:337\n*E\n"})
public final class KotlinSteppingCommandProviderKt {
    private static final SourcePosition getSourcePosition(SuspendContextImpl $this$getSourcePosition) {
        return $this$getSourcePosition.getDebugProcess().getDebuggerContext().getSourcePosition();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinStepAction getStepOverAction(@NotNull Location location, @NotNull SuspendContextImpl suspendContext, @NotNull StackFrameProxyImpl frameProxy) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        LocationToken locationToken;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        StackFrame stackFrame = SafeUtilKt.safeStackFrame((StackFrameProxy)frameProxy);
        if (stackFrame == null) {
            return KotlinStepAction.JvmStepOver.INSTANCE;
        }
        StackFrame srcStackFrame = stackFrame;
        Method method = SafeUtilKt.safeMethod(location);
        if (method == null) {
            return KotlinStepAction.JvmStepOver.INSTANCE;
        }
        Method srcMethod = method;
        LocationToken it = locationToken = LocationToken.Companion.from(srcStackFrame);
        boolean bl2 = false;
        LocationToken locationToken2 = it.getLineNumber() > 0 ? locationToken : null;
        if (locationToken2 == null) {
            return KotlinStepAction.JvmStepOver.INSTANCE;
        }
        LocationToken srcLocationToken = locationToken2;
        if (srcLocationToken.getInlineVariables().isEmpty() && KotlinSteppingCommandProviderKt.isSyntheticMethodForDefaultParameters(srcMethod)) {
            int psiLineNumber = SafeUtilKt.safeLineNumber(location) - 1;
            Iterator bl2 = ((Iterable)SafeUtilKt.safeAllLineLocations(srcMethod)).iterator();
            if (!bl2.hasNext()) {
                throw new NoSuchElementException();
            }
            Location it22 = (Location)bl2.next();
            boolean bl3 = false;
            int it22 = SafeUtilKt.safeLineNumber(it22);
            while (bl2.hasNext()) {
                Location it32 = (Location)bl2.next();
                $i$a$-minOf-KotlinSteppingCommandProviderKt$getStepOverAction$startLine$1 = false;
                int it32 = SafeUtilKt.safeLineNumber(it32);
                if (it22 <= it32) continue;
                it22 = it32;
            }
            int startLine = it22 - 1;
            Range lineNumbers = new Range((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(psiLineNumber));
            return new KotlinStepAction.StepInto(KotlinStepOverParamDefaultImplsMethodFilter.Companion.create(location, (Range<Integer>)lineNumbers));
        }
        CompoundPositionManager compoundPositionManager = suspendContext.getDebugProcess().getPositionManager();
        Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"getPositionManager(...)");
        CompoundPositionManager positionManager = compoundPositionManager;
        KtDeclarationWithBody srcNamedDeclaration = KotlinSteppingCommandProviderKt.getContainingNamedFunction(location, (PositionManager)positionManager);
        Map<LocalVariable, ClosedRange<Location>> bl2 = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(srcMethod);
        boolean $i$f$filter = false;
        void it32 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = iterator2.next();
            boolean bl4 = false;
            if (!(!((ClosedRange)it2.getValue()).contains((Comparable)location))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Collection inlinedFunctionArgumentRangesToSkip = destination$iv$iv.values();
        List srcStackFrames = InlineStackTraceCalculatorKt.computeKotlinStackFrameInfos$default(srcStackFrame, false, 1, null);
        KotlinStepOverFilter filter2 = new KotlinStepOverFilter(location, srcNamedDeclaration, positionManager, srcLocationToken, inlinedFunctionArgumentRangesToSkip, srcMethod, srcStackFrames){
            final /* synthetic */ KtDeclarationWithBody $srcNamedDeclaration;
            final /* synthetic */ CompoundPositionManager $positionManager;
            final /* synthetic */ LocationToken $srcLocationToken;
            final /* synthetic */ Collection<ClosedRange<Location>> $inlinedFunctionArgumentRangesToSkip;
            final /* synthetic */ Method $srcMethod;
            final /* synthetic */ List<KotlinStackFrameInfo> $srcStackFrames;
            {
                this.$srcNamedDeclaration = $srcNamedDeclaration;
                this.$positionManager = $positionManager;
                this.$srcLocationToken = $srcLocationToken;
                this.$inlinedFunctionArgumentRangesToSkip = $inlinedFunctionArgumentRangesToSkip;
                this.$srcMethod = $srcMethod;
                this.$srcStackFrames = $srcStackFrames;
                super($location);
            }

            public boolean isAcceptable(Location dstLocation, LocationToken dstLocationToken, StackFrame dstStackFrame) {
                Intrinsics.checkNotNullParameter((Object)dstLocation, (String)"dstLocation");
                Intrinsics.checkNotNullParameter((Object)dstLocationToken, (String)"dstLocationToken");
                Intrinsics.checkNotNullParameter((Object)dstStackFrame, (String)"dstStackFrame");
                int n = dstLocationToken.getLineNumber();
                LocationToken locationToken = this.$srcLocationToken;
                int it = n;
                boolean bl = false;
                boolean differentLine = it >= 0 && it != locationToken.getLineNumber();
                boolean stepThroughLambdas = Registry.Companion.is("debugger.kotlin.step.through.inline.lambdas");
                boolean posInTheSameFunction = Intrinsics.areEqual((Object)this.$srcNamedDeclaration, (Object)KotlinSteppingCommandProviderKt.access$getContainingNamedFunction(dstLocation, (PositionManager)this.$positionManager));
                return differentLine && (!getStepOverAction.filter.1.isAcceptable$fellIntoInlineBody(this.$inlinedFunctionArgumentRangesToSkip, dstLocationToken, dstLocation, this.$srcLocationToken) || stepThroughLambdas && posInTheSameFunction) && (!stepThroughLambdas || posInTheSameFunction || !getStepOverAction.filter.1.isAcceptable$isInInlineFunctionBody(dstLocation, this.$srcMethod, dstStackFrame, this.$srcStackFrames)) && !KotlinSteppingCommandProviderKt.access$isInlineFunctionFromLibrary((PositionManager)this.$positionManager, dstLocation, dstLocationToken) && !KotlinSteppingCommandProviderKt.access$isOnFunctionDeclaration(dstLocation, (PositionManager)this.$positionManager);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final boolean isAcceptable$fellIntoInlineBody(Collection<? extends ClosedRange<Location>> inlinedFunctionArgumentRangesToSkip, LocationToken $dstLocationToken, Location $dstLocation, LocationToken srcLocationToken) {
                boolean bl;
                boolean bl2;
                Iterable $this$any$iv = inlinedFunctionArgumentRangesToSkip;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        ClosedRange closedRange = (ClosedRange)element$iv;
                        boolean bl3 = false;
                        if (!closedRange.contains((Comparable)$dstLocation)) continue;
                        return true;
                    }
                    bl2 = false;
                }
                if (bl2) return true;
                $this$any$iv = $dstLocationToken.getInlineVariables();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator2 = $this$any$iv.iterator();
                do {
                    T element$iv;
                    if (!iterator2.hasNext()) return false;
                    element$iv = iterator2.next();
                    LocalVariable localVariable = (LocalVariable)element$iv;
                    boolean bl4 = false;
                    if (!srcLocationToken.getInlineVariables().contains(localVariable)) {
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }

            private static final boolean isAcceptable$isInInlineFunctionBody(Location $dstLocation, Method srcMethod, StackFrame $dstStackFrame, List<KotlinStackFrameInfo> srcStackFrames) {
                int n;
                if (!Intrinsics.areEqual((Object)SafeUtilKt.safeMethod($dstLocation), (Object)srcMethod)) {
                    return false;
                }
                List dstStackFrames = InlineStackTraceCalculatorKt.computeKotlinStackFrameInfos$default($dstStackFrame, false, 1, null);
                Iterable $this$count$iv = CollectionsKt.zip((Iterable)srcStackFrames, (Iterable)dstStackFrames);
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        KotlinStackFrameInfo a = (KotlinStackFrameInfo)pair.component1();
                        KotlinStackFrameInfo b = (KotlinStackFrameInfo)pair.component2();
                        if (!Intrinsics.areEqual((Object)a.getScopeVariable(), (Object)b.getScopeVariable()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int commonPrefixLen = n;
                List activeLambdas = new ArrayList<E>();
                int i2 = srcStackFrames.size() - 1;
                if (commonPrefixLen <= i2) {
                    while (true) {
                        KotlinStackFrameInfo frame;
                        LambdaName lambda2;
                        if ((lambda2 = (frame = srcStackFrames.get(i2)).getLambdaDetails()) != null) {
                            ((Collection)activeLambdas).add(lambda2.getInlineFunctionName());
                        } else {
                            String name2 = frame.getDisplayName();
                            if (name2 != null && Intrinsics.areEqual((Object)name2, (Object)CollectionsKt.lastOrNull((List)activeLambdas))) {
                                CollectionsKt.removeLast((List)activeLambdas);
                            }
                        }
                        if (i2 == commonPrefixLen) break;
                        --i2;
                    }
                }
                return !((Collection)activeLambdas).isEmpty();
            }
        };
        return new KotlinStepAction.KotlinStepOver(filter2, 0, 2, null);
    }

    private static final boolean isOnFunctionDeclaration(Location $this$isOnFunctionDeclaration, PositionManager positionManager) {
        SourcePosition sourcePosition = positionManager.getSourcePosition($this$isOnFunctionDeclaration);
        if (sourcePosition == null) {
            return false;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        return (Boolean)ActionsKt.runReadAction(() -> KotlinSteppingCommandProviderKt.isOnFunctionDeclaration$lambda$3(sourcePosition2));
    }

    private static final KtDeclarationWithBody getContainingNamedFunction(Location $this$getContainingNamedFunction, PositionManager positionManager) {
        SourcePosition sourcePosition = positionManager.getSourcePosition($this$getContainingNamedFunction);
        return (KtDeclarationWithBody)ActionsKt.runReadAction(() -> KotlinSteppingCommandProviderKt.getContainingNamedFunction$lambda$4(sourcePosition));
    }

    @Nullable
    public static final KotlinInlineFilter createKotlinInlineFilter(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Location location = suspendContext.getLocation();
        if (location == null) {
            return null;
        }
        Location location2 = location;
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return null;
        }
        Method method2 = method;
        return new KotlinInlineFilter(location2, method2);
    }

    public static final boolean isSyntheticMethodForDefaultParameters(@NotNull Method $this$isSyntheticMethodForDefaultParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$isSyntheticMethodForDefaultParameters, (String)"<this>");
        if (!$this$isSyntheticMethodForDefaultParameters.isSynthetic()) {
            return false;
        }
        String name2 = $this$isSyntheticMethodForDefaultParameters.name();
        Intrinsics.checkNotNull((Object)name2);
        if (StringsKt.endsWith$default((String)name2, (String)"$default", (boolean)false, (int)2, null)) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)name2, (Object)"<init>")) {
            return false;
        }
        List<String> arguments2 = $this$isSyntheticMethodForDefaultParameters.argumentTypeNames();
        int size = arguments2.size();
        if (size < 3) {
            return false;
        }
        return Intrinsics.areEqual((Object)arguments2.get(size - 2), (Object)"int") && Intrinsics.areEqual((Object)arguments2.get(size - 1), (Object)KotlinDebuggerConstants.INSTANCE.getDEFAULT_CONSTRUCTOR_MARKER_FQ_NAME().asString());
    }

    private static final boolean isInlineFunctionFromLibrary(PositionManager positionManager, Location location, LocationToken token) {
        if (token.getInlineVariables().isEmpty()) {
            return false;
        }
        return DebuggerUtil.isLocationFiltered(location, positionManager);
    }

    @Nullable
    public static final IntRange getLineRange(@NotNull PsiElement $this$getLineRange) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineRange, (String)"<this>");
        int startLineNumber = PsiLinesUtilsKt.getLineNumber($this$getLineRange, true);
        int endLineNumber = PsiLinesUtilsKt.getLineNumber($this$getLineRange, false);
        if (startLineNumber > endLineNumber) {
            return null;
        }
        return new IntRange(startLineNumber, endLineNumber);
    }

    @NotNull
    public static final KotlinStepAction getStepOutAction(@NotNull Location location, @NotNull StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        StackFrame stackFrame = SafeUtilKt.safeStackFrame((StackFrameProxy)frameProxy);
        if (stackFrame == null) {
            return new KotlinStepAction.StepOut(null, 1, null);
        }
        StackFrame stackFrame2 = stackFrame;
        LocationToken locationToken = LocationToken.Companion.from(stackFrame2);
        Object it = locationToken;
        boolean bl = false;
        LocationToken locationToken2 = ((LocationToken)it).getLineNumber() > 0 ? locationToken : null;
        if (locationToken2 == null) {
            return new KotlinStepAction.StepOut(null, 1, null);
        }
        LocationToken token = locationToken2;
        if (token.getInlineVariables().isEmpty()) {
            KotlinStepAction.StepOut stepOut = KotlinSteppingCommandProviderKt.createStepOutMethodWithDefaultArgsActionIfNeeded(frameProxy);
            if (stepOut != null) {
                it = stepOut;
                boolean bl2 = false;
                return (KotlinStepAction)it;
            }
            return new KotlinStepAction.StepOut(null, 1, null);
        }
        KotlinStepOverFilter filter2 = new KotlinStepOverFilter(location, token){
            final /* synthetic */ LocationToken $token;
            {
                this.$token = $token;
                super($location);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isAcceptable(Location location, LocationToken locationToken, StackFrame stackFrame) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)locationToken, (String)"locationToken");
                Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
                if (locationToken.getLineNumber() < 0) return false;
                Iterable $this$any$iv = this.$token.getInlineVariables();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    T element$iv = iterator2.next();
                    LocalVariable it = (LocalVariable)element$iv;
                    boolean bl2 = false;
                    if (!locationToken.getInlineVariables().contains(it)) {
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }
        };
        int stepSize = KotlinSteppingCommandProviderKt.isInsideOneLineInlineLambda(token) ? -1 : -2;
        return new KotlinStepAction.KotlinStepOver(filter2, stepSize);
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinStepAction.StepOut createStepOutMethodWithDefaultArgsActionIfNeeded(StackFrameProxyImpl frameProxy) {
        void $this$mapTo$iv$iv;
        Object object = SafeUtilKt.safeThreadProxy(frameProxy);
        if (object == null || (object = object.frames()) == null) {
            return null;
        }
        Object frames = object;
        if (frames.size() <= 1) {
            return null;
        }
        Object object2 = (StackFrameProxyImpl)CollectionsKt.getOrNull((List)frames, (int)1);
        if (object2 == null || (object2 = SafeUtilKt.safeStackFrame((StackFrameProxy)object2)) == null || (object2 = object2.location()) == null) {
            return null;
        }
        Object previousLocation = object2;
        Method method = SafeUtilKt.safeMethod((Location)previousLocation);
        if (method == null) {
            return null;
        }
        Method parentMethod = method;
        if (!KotlinSteppingCommandProviderKt.isSyntheticMethodForDefaultParameters(parentMethod)) {
            return null;
        }
        Iterable $this$map$iv = SafeUtilKt.safeAllLineLocations(parentMethod);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Location location = (Location)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SafeUtilKt.safeLineNumber((Location)it) - 1);
        }
        List parentLines = (List)destination$iv$iv;
        Range parentRange = !((Collection)parentLines).isEmpty() ? new Range(CollectionsKt.minOrThrow((Iterable)parentLines), CollectionsKt.maxOrThrow((Iterable)parentLines)) : null;
        return new KotlinStepAction.StepOut(new MethodFilter((Range<Integer>)parentRange, parentMethod){
            final /* synthetic */ Range<Integer> $parentRange;
            final /* synthetic */ Method $parentMethod;
            {
                this.$parentRange = $parentRange;
                this.$parentMethod = $parentMethod;
            }

            public Range<Integer> getCallingExpressionLines() {
                return this.$parentRange;
            }

            public int onReached(SuspendContextImpl context, RequestHint hint2) {
                return 3;
            }

            public boolean locationMatches(DebugProcessImpl process2, Location location) {
                Location location2 = location;
                return Intrinsics.areEqual((Object)(location2 != null ? SafeUtilKt.safeMethod(location2) : null), (Object)this.$parentMethod);
            }
        });
    }

    private static final boolean isInsideOneLineInlineLambda(LocationToken $this$isInsideOneLineInlineLambda) {
        for (LocalVariable variable : $this$isInsideOneLineInlineLambda.getInlineVariables()) {
            ClosedRange<Location> borders;
            if (DebuggerUtils.INSTANCE.getBorders(variable) == null) continue;
            String string = variable.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"$i$a$", (boolean)false, (int)2, null) || ((Location)borders.getStart()).lineNumber() != ((Location)borders.getEndInclusive()).lineNumber()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isOnFunctionDeclaration$lambda$3(SourcePosition $sourcePosition) {
        PsiFile psiFile = $sourcePosition.getFile();
        if (!(psiFile instanceof KtFile)) return false;
        KtFile ktFile2 = (KtFile)psiFile;
        if (ktFile2 == null) {
            return false;
        }
        KtFile file = ktFile2;
        PsiElement elementAtLine = DebuggerUtil.findElementAtLine(file, $sourcePosition.getLine());
        if (elementAtLine instanceof KtNamedFunction) return true;
        PsiElement psiElement = elementAtLine;
        if (psiElement == null) return false;
        PsiElement $this$parentOfType_u24default$iv = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtParameterList ktParameterList = (KtParameterList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtParameterList.class, (boolean)true);
        if (ktParameterList == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtNamedFunction getContainingNamedFunction$lambda$4(SourcePosition $sourcePosition) {
        KtNamedFunction ktNamedFunction;
        PsiElement psiElement;
        if ($sourcePosition != null && (psiElement = $sourcePosition.getElementAt()) != null) {
            void $this$parentOfType$iv;
            PsiElement psiElement2 = psiElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtNamedFunction.class, (boolean)false);
        } else {
            ktNamedFunction = null;
        }
        return ktNamedFunction;
    }

    public static final /* synthetic */ SourcePosition access$getSourcePosition(SuspendContextImpl $receiver) {
        return KotlinSteppingCommandProviderKt.getSourcePosition($receiver);
    }

    public static final /* synthetic */ KtDeclarationWithBody access$getContainingNamedFunction(Location $receiver, PositionManager positionManager) {
        return KotlinSteppingCommandProviderKt.getContainingNamedFunction($receiver, positionManager);
    }

    public static final /* synthetic */ boolean access$isInlineFunctionFromLibrary(PositionManager positionManager, Location location, LocationToken token) {
        return KotlinSteppingCommandProviderKt.isInlineFunctionFromLibrary(positionManager, location, token);
    }

    public static final /* synthetic */ boolean access$isOnFunctionDeclaration(Location $receiver, PositionManager positionManager) {
        return KotlinSteppingCommandProviderKt.isOnFunctionDeclaration($receiver, positionManager);
    }
}

