/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.JsInnerClassesSupportKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport;", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "getOuterThisField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "innerClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInnerClassConstructorWithOuterThisParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsInnerClassesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsInnerClassesSupport.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n401#2:110\n402#2,2:115\n401#2,3:118\n75#3,4:111\n315#3,4:121\n363#3,4:125\n1#4:117\n*S KotlinDebug\n*F\n+ 1 JsInnerClassesSupport.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport\n*L\n39#1:110\n39#1:115,2\n64#1:118,3\n46#1:111,4\n83#1:121,4\n93#1:125,4\n*E\n"})
public final class JsInnerClassesSupport
implements InnerClassesSupport {
    @NotNull
    private final IrFactory irFactory;

    public JsInnerClassesSupport(@NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        this.irFactory = irFactory;
    }

    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            CompilationExceptionKt.compilationException((String)"Class is not inner", (IrDeclaration)((IrDeclaration)innerClass));
            throw new KotlinNothingValueException();
        }
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(innerClass){

            public Object get() {
                return JsInnerClassesSupportKt.access$getOuterThisFieldSymbol((IrClass)this.receiver);
            }

            public void set(Object value) {
                JsInnerClassesSupportKt.access$setOuterThisFieldSymbol((IrClass)this.receiver, (IrField)value);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            IrField irField;
            IrField irField2;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = innerClass.getParent();
            IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (irClass == null) {
                CompilationExceptionKt.compilationException((String)"No containing class for inner class", (IrDeclaration)((IrDeclaration)innerClass));
                throw new KotlinNothingValueException();
            }
            IrClass outerClass = irClass;
            IrFactory $this$buildField$iv = this.irFactory;
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
            boolean bl2 = false;
            IrFieldBuilder $this$getOuterThisField_u24lambda_u242_u24lambda_u240 = $this$buildField_u24lambda_u244$iv;
            boolean bl3 = false;
            $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS());
            Name name = Name.identifier((String)Namer.INSTANCE.getSYNTHETIC_RECEIVER_NAME());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setName(name);
            $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setType((IrType)IrUtilsKt.getDefaultType((IrClass)outerClass));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
            $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setVisibility(descriptorVisibility);
            $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setFinal(true);
            $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setExternal(false);
            $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setStatic(false);
            IrField it = irField2 = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv);
            boolean bl4 = false;
            it.setParent((IrDeclarationParent)innerClass);
            IrField it$iv = irField = irField2;
            boolean bl5 = false;
            $this$getOrSetIfNull$iv.set((Object)it$iv);
            object = irField;
        }
        return (IrField)object;
    }

    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Intrinsics.checkNotNullParameter((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = false;
            String $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)$i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22);
        }
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(innerClassConstructor){

            public Object get() {
                return JsInnerClassesSupportKt.access$getInnerClassConstructor((IrConstructor)this.receiver);
            }

            public void set(Object value) {
                JsInnerClassesSupportKt.access$setInnerClassConstructor((IrConstructor)this.receiver, (IrConstructor)value);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            IrConstructor irConstructor;
            boolean bl2 = false;
            IrConstructor it$iv = irConstructor = this.createInnerClassConstructorWithOuterThisParameter(innerClassConstructor);
            boolean bl3 = false;
            $this$getOrSetIfNull$iv.set((Object)it$iv);
            object = irConstructor;
        }
        Object object2 = object;
        IrConstructor it = (IrConstructor)object2;
        boolean bl4 = false;
        if (innerClassConstructor.isPrimary()) {
            JsInnerClassesSupportKt.access$setOriginalInnerClassPrimaryConstructor(innerClass, innerClassConstructor);
        }
        return (IrConstructor)object2;
    }

    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)string);
        }
        return JsInnerClassesSupportKt.access$getOriginalInnerClassPrimaryConstructor(innerClass);
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        void $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249;
        IrDeclarationParent irDeclarationParent = oldConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass irClass = (IrClass)irDeclarationParent;
        IrDeclarationParent irDeclarationParent2 = irClass.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrSimpleType outerThisType = IrUtilsKt.getDefaultType((IrClass)((IrClass)irDeclarationParent2));
        IrFactory $this$buildConstructor$iv = this.irFactory;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2427$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u247 = $this$buildConstructor_u24lambda_u2427$iv;
        boolean bl2 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u247.updateFrom((IrFunction)oldConstructor);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u247.setReturnType(oldConstructor.getReturnType());
        IrFactory it = $this$buildConstructor$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2427$iv);
        boolean bl3 = false;
        it.setParent(oldConstructor.getParent());
        it.setAnnotations(oldConstructor.getAnnotations());
        IrFactory newConstructor = $this$buildConstructor$iv;
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)newConstructor), (IrTypeParametersContainer)((IrTypeParametersContainer)oldConstructor), null, null, (int)6, null);
        IrValueParameter[] irValueParameterArray = new IrValueParameter[1];
        IrDeclaration declaration$iv = (IrDeclaration)newConstructor;
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2433$iv = new IrValueParameterBuilder();
        boolean bl4 = false;
        IrValueParameterBuilder irValueParameterBuilder = $this$buildValueParameter_u24lambda_u2433$iv;
        int n = 0;
        Object[] objectArray = irValueParameterArray;
        boolean bl5 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setOrigin((IrDeclarationOrigin)JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
        Name name = Name.identifier((String)Namer.INSTANCE.getOUTER_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setName(name);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setType((IrType)outerThisType);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setKind(IrParameterKind.Regular);
        Unit unit = Unit.INSTANCE;
        objectArray[n] = DeclarationBuildersKt.buildValueParameter((IrFactory)declaration$iv.getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u2433$iv, (IrDeclarationParent)((IrDeclarationParent)declaration$iv));
        List newValueParameters = CollectionsKt.mutableListOf((Object[])irValueParameterArray);
        for (IrValueParameter p : IrUtilsKt.getNonDispatchParameters((IrFunction)((IrFunction)oldConstructor))) {
            ((Collection)newValueParameters).add(IrUtilsKt.copyTo$default((IrValueParameter)p, (IrFunction)((IrFunction)newConstructor), null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, null, (int)8190, null));
        }
        newConstructor.setParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus((List)newConstructor.getParameters(), (List)newValueParameters));
        return newConstructor;
    }
}

