/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.thirdparty;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.gdpr.thirdparty.ThirdPartyConsentOptions;
import com.intellij.marketplace.statistics.MarketplaceStatisticsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\b\u0010\t\u001a\u00020\u0002H\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/gdpr/thirdparty/ThirdPartyConsentConfigurable;", "Lcom/intellij/openapi/options/ConfigurableBase;", "Lcom/intellij/ide/gdpr/ConsentSettingsUi;", "", "Lcom/intellij/ide/gdpr/Consent;", "<init>", "()V", "consents", "getSettings", "createUi", "intellij.marketplace.statistics"})
public final class ThirdPartyConsentConfigurable
extends ConfigurableBase<ConsentSettingsUi, List<? extends Consent>> {
    @NotNull
    private final List<Consent> consents;

    public ThirdPartyConsentConfigurable() {
        super("third-party-consents", MarketplaceStatisticsBundle.INSTANCE.message("third.party.consent.configurable", new Object[0]), "preferences.usage.statistics");
        Object object = ThirdPartyConsentOptions.getInstance().getConsents().getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
        this.consents = (List)object;
    }

    @NotNull
    protected List<Consent> getSettings() {
        return this.consents;
    }

    @NotNull
    protected ConsentSettingsUi createUi() {
        ConsentSettingsUi ui2 = new ConsentSettingsUi(){

            public void apply(List<Consent> consents) {
                Intrinsics.checkNotNullParameter(consents, (String)"consents");
                super.apply(consents);
                ThirdPartyConsentOptions.getInstance().setConsents((Collection<Consent>)consents);
            }

            public void reset(List<Consent> consents) {
                Intrinsics.checkNotNullParameter(consents, (String)"consents");
                super.reset(consents);
                for (JLabel label : UIUtil.findComponentsOfType((JComponent)((JComponent)((Object)this)), JLabel.class)) {
                    Object[] objectArray = new Object[]{ApplicationInfoImpl.getShadowInstance().getShortCompanyName()};
                    if (!Intrinsics.areEqual((Object)label.getText(), (Object)IdeBundle.message((String)"gdpr.hint.text.apply.to.all.installed.products", (Object[])objectArray))) continue;
                    objectArray = new Object[]{"JetBrains"};
                    label.setText(IdeBundle.message((String)"gdpr.hint.text.apply.to.all.installed.products", (Object[])objectArray));
                }
            }
        };
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ui2.reset(this.consents);
        }
        return ui2;
    }
}

