/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeometryUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.VerticalRotatedLabelsLayout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/VerticalRotatedLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "myRotationAngle", "", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelNormalSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nVerticalRotatedLabelsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalRotatedLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/VerticalRotatedLabelsLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n1789#3,3:128\n1549#3:131\n1620#3,3:132\n1549#3:135\n1620#3,3:136\n1549#3:139\n1620#3,3:140\n*S KotlinDebug\n*F\n+ 1 VerticalRotatedLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/VerticalRotatedLabelsLayout\n*L\n41#1:128,3\n100#1:131\n100#1:132,3\n107#1:135\n107#1:136,3\n117#1:139\n117#1:140,3\n*E\n"})
public final class VerticalRotatedLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    private final double myRotationAngle;

    /*
     * WARNING - void declaration
     */
    public VerticalRotatedLabelsLayout(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme) {
        void it;
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, breaks, theme);
        Double d = theme.labelAngle();
        double d2 = ((Number)d).doubleValue();
        VerticalRotatedLabelsLayout verticalRotatedLabelsLayout = this;
        boolean bl = false;
        boolean bl2 = !Double.isNaN((double)it);
        Double d3 = bl2 ? d : null;
        verticalRotatedLabelsLayout.myRotationAngle = d3 != null ? d3 : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength) {
        DoubleRectangle it;
        Iterable $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        double vJust;
        double d;
        Iterator iterator2;
        DoubleRectangle bounds;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        if (!(!this.getOrientation().isHorizontal())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        List<Double> ticks = this.getBreaks().projectOnAxis(axisDomain, axisLength, false);
        List<DoubleRectangle> labelBoundsList2 = this.labelBoundsList(ticks, this.getBreaks().getLabels(), (Function1<? super Double, DoubleVector>)((Function1)doLayout.labelBoundsList.1.INSTANCE));
        boolean overlap = false;
        Iterable iterable = labelBoundsList2;
        DoubleRectangle initial$iv = null;
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void b2;
            DoubleRectangle doubleRectangle = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl = false;
            overlap = overlap || acc != null && acc.yRange().connected(b2.yRange().expanded(4.0));
            accumulator$iv = GeometryUtil.INSTANCE.union((DoubleRectangle)b2, acc);
        }
        DoubleRectangle doubleRectangle = accumulator$iv;
        if (doubleRectangle == null) {
            doubleRectangle = bounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        }
        if (!(iterator2 = ((Iterable)labelBoundsList2).iterator()).hasNext()) {
            throw new NoSuchElementException();
        }
        DoubleRectangle it2 = (DoubleRectangle)iterator2.next();
        boolean bl = false;
        double element$iv = it2.getWidth();
        while (iterator2.hasNext()) {
            DoubleRectangle it3 = (DoubleRectangle)iterator2.next();
            $i$a$-maxOf-VerticalRotatedLabelsLayout$doLayout$maxLabelWidth$1 = false;
            double d2 = it3.getWidth();
            element$iv = Math.max(element$iv, d2);
        }
        double maxLabelWidth = element$iv;
        double radAngle = MathKt.toRadians(this.myRotationAngle);
        double sinA = Math.sin(radAngle);
        double cosA = Math.cos(radAngle);
        boolean isVertical = Math.abs(cosA) < 1.0E-6;
        boolean isUpsideDown = cosA < 0.0;
        boolean isHorizontal = Math.abs(sinA) < 1.0E-6 && !isUpsideDown;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()]) {
            case 1: {
                d = -1.0;
                break;
            }
            case 2: {
                d = 1.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported orientation " + (Object)((Object)this.getOrientation()));
            }
        }
        double orientationSign = d;
        double d3 = Double.isNaN(this.getTheme().labelVJust()) ? (isVertical || isHorizontal ? 0.5 : (this.getOrientation() == Orientation.LEFT && sinA > 0.0 ? 0.0 : (this.getOrientation() == Orientation.LEFT && sinA < 0.0 ? 1.0 : (this.getOrientation() == Orientation.RIGHT && sinA > 0.0 ? 1.0 : (this.getOrientation() == Orientation.RIGHT && sinA < 0.0 ? 0.0 : 0.0))))) : (vJust = this.getTheme().labelVJust());
        double hJust = Double.isNaN(this.getTheme().labelHJust()) ? (this.getOrientation() == Orientation.RIGHT ? 1.0 : 0.0) : this.getTheme().labelHJust();
        Function1 xBBoxOffset2 = (Function1)new Function1<DoubleRectangle, Double>(maxLabelWidth, orientationSign, hJust){
            final /* synthetic */ double $maxLabelWidth;
            final /* synthetic */ double $orientationSign;
            final /* synthetic */ double $hJust;
            {
                this.$maxLabelWidth = $maxLabelWidth;
                this.$orientationSign = $orientationSign;
                this.$hJust = $hJust;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                return (this.$maxLabelWidth - rect2.getWidth()) * ((this.$orientationSign + 1.0) / (double)2 - this.$hJust);
            }
        };
        Function1 yBBoxOffset2 = (Function1)new Function1<DoubleRectangle, Double>(vJust){
            final /* synthetic */ double $vJust;
            {
                this.$vJust = $vJust;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                return rect2.getHeight() * -this.$vJust;
            }
        };
        Function1 xOffset2 = (Function1)new Function1<DoubleRectangle, Double>((Function1<? super DoubleRectangle, Double>)xBBoxOffset2, orientationSign){
            final /* synthetic */ Function1<DoubleRectangle, Double> $xBBoxOffset;
            final /* synthetic */ double $orientationSign;
            {
                this.$xBBoxOffset = $xBBoxOffset;
                this.$orientationSign = $orientationSign;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                Object object = this.$xBBoxOffset.invoke((Object)rect2);
                double d = this.$orientationSign;
                double it = ((Number)object).doubleValue();
                boolean bl = false;
                return it + d * rect2.getWidth() / (double)2;
            }
        };
        Function1 yOffset2 = (Function1)new Function1<DoubleRectangle, Double>(vJust){
            final /* synthetic */ double $vJust;
            {
                this.$vJust = $vJust;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                return rect2.getHeight() * (0.5 - this.$vJust);
            }
        };
        Iterable $this$map$iv = labelBoundsList2;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it4;
            DoubleRectangle doubleRectangle2 = (DoubleRectangle)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(new DoubleVector(((Number)xOffset2.invoke((Object)it4)).doubleValue(), ((Number)yOffset2.invoke((Object)it4)).doubleValue()));
        }
        List labelAdditionalOffsets = (List)destination$iv$iv;
        Text.HorizontalAnchor horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
        Text.VerticalAnchor verticalAnchor = Text.VerticalAnchor.CENTER;
        Iterable $this$map$iv2 = labelBoundsList2;
        boolean $i$f$map2 = false;
        Iterable iterable3 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DoubleRectangle doubleRectangle3 = (DoubleRectangle)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl3 = false;
            DoubleVector origin = new DoubleVector(it.getOrigin().getX() + ((Number)xBBoxOffset2.invoke((Object)it)).doubleValue(), ((Number)yBBoxOffset2.invoke((Object)it)).doubleValue() + it.getOrigin().getY());
            object.add(new DoubleRectangle(origin, it.getDimension()));
        }
        List adjustedLabelBoundsList = (List)destination$iv$iv2;
        $this$map$iv2 = adjustedLabelBoundsList;
        object = this.createAxisLabelsLayoutInfoBuilder(bounds, overlap).labelHorizontalAnchor(horizontalAnchor).labelVerticalAnchor(verticalAnchor).labelRotationAngle(-this.myRotationAngle).labelAdditionalOffsets(labelAdditionalOffsets);
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (DoubleRectangle)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add(this.alignToLabelMargin((DoubleRectangle)p0));
        }
        return ((AxisLabelsLayoutInfo.Builder)object).labelBoundsList((List)destination$iv$iv2).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        DoubleRectangle it = BreakLabelsLayoutUtil.INSTANCE.rotatedLabelBounds(labelNormalSize, this.myRotationAngle);
        boolean bl = false;
        return new DoubleRectangle(0.0, 0.0, it.getWidth(), it.getHeight());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

