/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.commons.values.FontFamily;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.NullPlotContext;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.NullGeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GeomContextBuilder;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ImmutableGeomContext;
import org.jetbrains.letsPlot.core.plot.builder.presentation.PlotLabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u00020\u00012\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00012\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170\u00160\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170\u00160\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomContextBuilder;", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ImmutableGeomContext$Builder;", "()V", "ctx", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomContextBuilder$MyGeomContext;", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomContextBuilder$MyGeomContext;)V", "aesBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "aestheticMappers", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "annotation", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/Annotation;", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "coordinateSystem", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "defaultFormatters", "", "Lkotlin/Function1;", "", "flipped", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "geomTargetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "color", "build", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ImmutableGeomContext;", "v", "MyGeomContext", "plot-builder"})
public final class GeomContextBuilder
implements ImmutableGeomContext.Builder {
    private boolean flipped;
    @Nullable
    private Aesthetics aesthetics;
    @Nullable
    private Map<Aes<?>, ? extends ScaleMapper<?>> aestheticMappers;
    @Nullable
    private DoubleRectangle aesBounds;
    @NotNull
    private GeomTargetCollector geomTargetCollector = new NullGeomTargetCollector();
    @Nullable
    private FontFamilyRegistry fontFamilyRegistry;
    @Nullable
    private Annotation annotation;
    @NotNull
    private Map<Object, ? extends Function1<Object, String>> defaultFormatters = MapsKt.emptyMap();
    @NotNull
    private Color backgroundColor = Color.Companion.getWHITE();
    @NotNull
    private PlotContext plotContext = NullPlotContext.INSTANCE;
    @Nullable
    private CoordinateSystem coordinateSystem;

    public GeomContextBuilder() {
    }

    private GeomContextBuilder(MyGeomContext ctx2) {
        this.flipped = ctx2.getFlipped();
        this.aesthetics = ctx2.getAesthetics();
        this.aestheticMappers = ctx2.getAestheticMappers();
        this.aesBounds = ctx2.get_aesBounds();
        this.geomTargetCollector = ctx2.getTargetCollector();
        this.annotation = ctx2.getAnnotation();
        this.defaultFormatters = ctx2.getDefaultFormatters();
        this.backgroundColor = ctx2.getBackgroundColor();
        this.plotContext = ctx2.getPlotContext();
        this.coordinateSystem = ctx2.get_coordinateSystem();
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder flipped(boolean flipped) {
        this.flipped = flipped;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aesthetics(@NotNull Aesthetics aesthetics2) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        this.aesthetics = aesthetics2;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aestheticMappers(@NotNull Map<Aes<?>, ? extends ScaleMapper<?>> aestheticMappers) {
        Intrinsics.checkNotNullParameter(aestheticMappers, (String)"aestheticMappers");
        this.aestheticMappers = aestheticMappers;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aesBounds(@NotNull DoubleRectangle aesBounds) {
        Intrinsics.checkNotNullParameter((Object)aesBounds, (String)"aesBounds");
        this.aesBounds = aesBounds;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder geomTargetCollector(@NotNull GeomTargetCollector geomTargetCollector) {
        Intrinsics.checkNotNullParameter((Object)geomTargetCollector, (String)"geomTargetCollector");
        this.geomTargetCollector = geomTargetCollector;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder fontFamilyRegistry(@NotNull FontFamilyRegistry v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.fontFamilyRegistry = v;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder annotation(@Nullable Annotation annotation) {
        this.annotation = annotation;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder defaultFormatters(@NotNull Map<Object, ? extends Function1<Object, String>> defaultFormatters) {
        Intrinsics.checkNotNullParameter(defaultFormatters, (String)"defaultFormatters");
        this.defaultFormatters = defaultFormatters;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder backgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.backgroundColor = color;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder plotContext(@NotNull PlotContext plotContext) {
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        this.plotContext = plotContext;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder coordinateSystem(@NotNull CoordinateSystem coordinateSystem) {
        Intrinsics.checkNotNullParameter((Object)coordinateSystem, (String)"coordinateSystem");
        this.coordinateSystem = coordinateSystem;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext build() {
        return new MyGeomContext(this);
    }

    public /* synthetic */ GeomContextBuilder(MyGeomContext ctx2, DefaultConstructorMarker $constructor_marker) {
        this(ctx2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\"2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020%H\u0016J\b\u0010:\u001a\u00020\u0006H\u0016J\n\u0010;\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010<\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\"0!2\u0006\u0010=\u001a\u00020\"H\u0016J \u0010<\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\"0!2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0016\u0010?\u001a\u0002072\f\u0010>\u001a\b\u0012\u0004\u0012\u0002070\u000fH\u0016J\u0014\u0010@\u001a\u00020%2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\b\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010.\u001a\u00020/H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR'\u0010\r\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR)\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\"0!0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u0006E"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomContextBuilder$MyGeomContext;", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ImmutableGeomContext;", "b", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomContextBuilder;", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomContextBuilder;)V", "_aesBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "get_aesBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "_coordinateSystem", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "get_coordinateSystem", "()Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "aestheticMappers", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "getAestheticMappers", "()Ljava/util/Map;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "getAesthetics", "()Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "annotation", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/Annotation;", "getAnnotation", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/Annotation;", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getBackgroundColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "defaultFormatters", "", "Lkotlin/Function1;", "", "getDefaultFormatters", "flipped", "", "getFlipped", "()Z", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "getPlotContext", "()Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "getTargetCollector", "()Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "estimateTextSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "text", "family", "size", "", "isBold", "isItalic", "getAesBounds", "getCoordinateSystem", "getDefaultFormatter", "varName", "aes", "getResolution", "isMappedAes", "with", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ImmutableGeomContext$Builder;", "withTargetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nGeomContextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeomContextBuilder.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/GeomContextBuilder$MyGeomContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
    private static final class MyGeomContext
    implements ImmutableGeomContext {
        @Nullable
        private final Aesthetics aesthetics;
        @Nullable
        private final Map<Aes<?>, ScaleMapper<?>> aestheticMappers;
        @Nullable
        private final DoubleRectangle _aesBounds;
        @NotNull
        private final Map<Object, Function1<Object, String>> defaultFormatters;
        @Nullable
        private final CoordinateSystem _coordinateSystem;
        private final boolean flipped;
        @NotNull
        private final GeomTargetCollector targetCollector;
        @Nullable
        private final Annotation annotation;
        @NotNull
        private final Color backgroundColor;
        @NotNull
        private final PlotContext plotContext;
        @Nullable
        private final FontFamilyRegistry fontFamilyRegistry;

        public MyGeomContext(@NotNull GeomContextBuilder b2) {
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            this.aesthetics = b2.aesthetics;
            this.aestheticMappers = b2.aestheticMappers;
            this._aesBounds = b2.aesBounds;
            this.defaultFormatters = b2.defaultFormatters;
            this._coordinateSystem = b2.coordinateSystem;
            this.flipped = b2.flipped;
            this.targetCollector = b2.geomTargetCollector;
            this.annotation = b2.annotation;
            this.backgroundColor = b2.backgroundColor;
            this.plotContext = b2.plotContext;
            this.fontFamilyRegistry = b2.fontFamilyRegistry;
        }

        @Nullable
        public final Aesthetics getAesthetics() {
            return this.aesthetics;
        }

        @Nullable
        public final Map<Aes<?>, ScaleMapper<?>> getAestheticMappers() {
            return this.aestheticMappers;
        }

        @Nullable
        public final DoubleRectangle get_aesBounds() {
            return this._aesBounds;
        }

        @NotNull
        public final Map<Object, Function1<Object, String>> getDefaultFormatters() {
            return this.defaultFormatters;
        }

        @Nullable
        public final CoordinateSystem get_coordinateSystem() {
            return this._coordinateSystem;
        }

        @Override
        public boolean getFlipped() {
            return this.flipped;
        }

        @Override
        @NotNull
        public GeomTargetCollector getTargetCollector() {
            return this.targetCollector;
        }

        @Override
        @Nullable
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        @NotNull
        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        @NotNull
        public PlotContext getPlotContext() {
            return this.plotContext;
        }

        @Override
        public double getResolution(@NotNull Aes<Double> aes2) {
            Intrinsics.checkNotNullParameter(aes2, (String)"aes");
            double resolution = 0.0;
            if (this.aesthetics != null) {
                resolution = this.aesthetics.resolution(aes2, 0.0);
            }
            if (resolution <= 1.0E-50) {
                resolution = 1.0;
            }
            return resolution;
        }

        @Override
        public boolean isMappedAes(@NotNull Aes<?> aes2) {
            Intrinsics.checkNotNullParameter(aes2, (String)"aes");
            Map<Aes<?>, ScaleMapper<?>> map2 = this.aestheticMappers;
            return map2 != null ? map2.containsKey(aes2) : false;
        }

        @Override
        @NotNull
        public DoubleVector estimateTextSize(@NotNull String text2, @NotNull String family, double size2, boolean isBold, boolean isItalic) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            FontFamilyRegistry registry = this.fontFamilyRegistry;
            if (!(registry != null)) {
                boolean bl = false;
                String string = "Font-family registry is not specified.";
                throw new IllegalStateException(string.toString());
            }
            FontFamily family2 = registry.get(family);
            return new PlotLabelSpec(new Font(family2, (int)size2, isBold, isItalic), false, 2, null).dimensions(text2);
        }

        @Override
        @NotNull
        public Function1<Object, String> getDefaultFormatter(@NotNull Aes<?> aes2) {
            Intrinsics.checkNotNullParameter(aes2, (String)"aes");
            Function1 function1 = this.defaultFormatters.get(aes2);
            if (function1 == null) {
                function1 = getDefaultFormatter.1.INSTANCE;
            }
            return function1;
        }

        @Override
        @NotNull
        public Function1<Object, String> getDefaultFormatter(@NotNull String varName) {
            Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
            Function1 function1 = this.defaultFormatters.get(varName);
            if (function1 == null) {
                function1 = getDefaultFormatter.2.INSTANCE;
            }
            return function1;
        }

        @Override
        @Nullable
        public CoordinateSystem getCoordinateSystem() {
            return this._coordinateSystem;
        }

        @Override
        @NotNull
        public DoubleRectangle getAesBounds() {
            if (!(this._aesBounds != null)) {
                boolean bl = false;
                String string = "GeomContext: aesthetics bounds are not defined.";
                throw new IllegalStateException(string.toString());
            }
            return this._aesBounds;
        }

        @Override
        @NotNull
        public GeomContext withTargetCollector(@NotNull GeomTargetCollector targetCollector) {
            Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
            return this.with().geomTargetCollector(targetCollector).build();
        }

        @Override
        @NotNull
        public ImmutableGeomContext.Builder with() {
            return new GeomContextBuilder(this, null);
        }
    }
}

