/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.FiveNumberSummary;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J;\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\rH\u0016J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0014\u0010\u0019\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BoxplotStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "whiskerIQRRatio", "", "computeWidth", "", "(DZ)V", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getDefaultMapping", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "aes", "hasDefaultMapping", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBoxplotStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BoxplotStat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1#2:171\n1549#3:172\n1620#3,3:173\n*S KotlinDebug\n*F\n+ 1 BoxplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BoxplotStat\n*L\n76#1:172\n76#1:173,3\n*E\n"})
public final class BoxplotStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double whiskerIQRRatio;
    private final boolean computeWidth;
    public static final double DEF_WHISKER_IQR_RATIO = 1.5;
    public static final boolean DEF_COMPUTE_WIDTH = false;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public BoxplotStat(double whiskerIQRRatio, boolean computeWidth) {
        super(DEF_MAPPING);
        this.whiskerIQRRatio = whiskerIQRRatio;
        this.computeWidth = computeWidth;
    }

    @Override
    public boolean hasDefaultMapping(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return super.hasDefaultMapping(aes2) || Intrinsics.areEqual(aes2, Aes.Companion.getWIDTH()) && this.computeWidth;
    }

    @Override
    @NotNull
    public DataFrame.Variable getDefaultMapping(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return Intrinsics.areEqual(aes2, Aes.Companion.getWIDTH()) ? Stats.INSTANCE.getWIDTH() : super.getDefaultMapping(aes2);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data2, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        int maxCountPerBin;
        Collection<Double> collection;
        List list2;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getY()};
        if (!this.hasRequiredValues(data2, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> ys = data2.getNumeric(TransformVar.INSTANCE.getY());
        if (data2.has(TransformVar.INSTANCE.getX())) {
            list2 = data2.getNumeric(TransformVar.INSTANCE.getX());
        } else {
            int n = ys.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                collection = arrayList;
                boolean bl = false;
                ((ArrayList)collection).add(0.0);
            }
            list2 = arrayList;
        }
        List xs = list2;
        Map statData = BoxplotStat.Companion.buildStat(xs, ys, this.whiskerIQRRatio);
        List statCount = (List)statData.remove(Stats.INSTANCE.getCOUNT());
        Object object = statCount;
        int n = object != null && (object = CollectionsKt.maxOrNull((Iterable)((Iterable)object))) != null ? (int)((Double)object).doubleValue() : (maxCountPerBin = 0);
        if (maxCountPerBin == 0) {
            return this.withEmptyStatValues();
        }
        if (this.computeWidth) {
            void $this$mapTo$iv$iv;
            double norm = Math.sqrt(maxCountPerBin);
            List list3 = statCount;
            Intrinsics.checkNotNull((Object)list3);
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void count;
                double d = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Math.sqrt((double)count) / norm);
            }
            List statWidth = (List)destination$iv$iv;
            statData.put(Stats.INSTANCE.getWIDTH(), statWidth);
        }
        DataFrame.Builder builder = new DataFrame.Builder();
        for (Map.Entry entry : statData.entrySet()) {
            DataFrame.Variable variable = (DataFrame.Variable)entry.getKey();
            List series = (List)entry.getValue();
            builder.putNumeric(variable, series);
        }
        return builder.build();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getYMIN(), (Object)Stats.INSTANCE.getY_MIN()), TuplesKt.to(Aes.Companion.getYMAX(), (Object)Stats.INSTANCE.getY_MAX()), TuplesKt.to(Aes.Companion.getLOWER(), (Object)Stats.INSTANCE.getLOWER()), TuplesKt.to(Aes.Companion.getMIDDLE(), (Object)Stats.INSTANCE.getMIDDLE()), TuplesKt.to(Aes.Companion.getUPPER(), (Object)Stats.INSTANCE.getUPPER())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r0\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\r2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\r2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BoxplotStat$Companion;", "", "()V", "DEF_COMPUTE_WIDTH", "", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "DEF_WHISKER_IQR_RATIO", "", "buildStat", "", "", "xs", "ys", "whiskerIQRRatio", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nBoxplotStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BoxplotStat$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1#2:171\n372#3,7:172\n766#4:179\n857#4,2:180\n*S KotlinDebug\n*F\n+ 1 BoxplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BoxplotStat$Companion\n*L\n114#1:172,7\n140#1:179\n140#1:180,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<DataFrame.Variable, List<Double>> buildStat(List<Double> xs, List<Double> ys, double whiskerIQRRatio) {
            List<List<Double>> list2 = SeriesUtil.INSTANCE.filterFinite(xs, ys);
            boolean bl2 = false;
            List<Double> xs2 = list2.get(0);
            List<Double> ys2 = list2.get(1);
            List xyPairs = CollectionsKt.zip((Iterable)xs2, (Iterable)ys2);
            if (xyPairs.isEmpty()) {
                return new LinkedHashMap();
            }
            Map binnedData = new HashMap();
            for (Pair bl2 : xyPairs) {
                Object object;
                void $this$getOrPut$iv;
                double x2 = ((Number)bl2.component1()).doubleValue();
                double y2 = ((Number)bl2.component2()).doubleValue();
                Map map2 = binnedData;
                Double key$iv = x2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(y2);
            }
            ArrayList<Double> statX = new ArrayList<Double>();
            ArrayList<Double> statMiddle = new ArrayList<Double>();
            ArrayList<Double> statLower = new ArrayList<Double>();
            ArrayList<Double> statUpper = new ArrayList<Double>();
            ArrayList<Double> statMin = new ArrayList<Double>();
            ArrayList<Double> statMax = new ArrayList<Double>();
            ArrayList<Double> statCount = new ArrayList<Double>();
            for (Map.Entry entry : binnedData.entrySet()) {
                double x3 = ((Number)entry.getKey()).doubleValue();
                List bin = (List)entry.getValue();
                double count = bin.size();
                FiveNumberSummary summary = new FiveNumberSummary(bin);
                double middle = summary.getMedian();
                double lowerHinge = summary.getFirstQuartile();
                double upperHinge = summary.getThirdQuartile();
                double IQR = upperHinge - lowerHinge;
                double lowerFence = lowerHinge - IQR * whiskerIQRRatio;
                double upperFence = upperHinge + IQR * whiskerIQRRatio;
                double lowerWhisker = lowerFence;
                double upperWhisker = upperFence;
                if (SeriesUtil.INSTANCE.allFinite(lowerFence, upperFence)) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = bin;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        double y3 = ((Number)element$iv$iv).doubleValue();
                        boolean bl4 = false;
                        boolean bl5 = lowerFence <= y3 ? y3 <= upperFence : false;
                        if (!bl5) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List boxed = (List)destination$iv$iv;
                    DoubleSpan range = SeriesUtil.INSTANCE.range(boxed);
                    if (range != null) {
                        lowerWhisker = range.getLowerEnd();
                        upperWhisker = range.getUpperEnd();
                    }
                }
                statX.add(x3);
                statMiddle.add(middle);
                statLower.add(lowerHinge);
                statUpper.add(upperHinge);
                statMin.add(lowerWhisker);
                statMax.add(upperWhisker);
                statCount.add(count);
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), statX), TuplesKt.to((Object)Stats.INSTANCE.getMIDDLE(), statMiddle), TuplesKt.to((Object)Stats.INSTANCE.getLOWER(), statLower), TuplesKt.to((Object)Stats.INSTANCE.getUPPER(), statUpper), TuplesKt.to((Object)Stats.INSTANCE.getY_MIN(), statMin), TuplesKt.to((Object)Stats.INSTANCE.getY_MAX(), statMax), TuplesKt.to((Object)Stats.INSTANCE.getCOUNT(), statCount)};
            return MapsKt.mutableMapOf((Pair[])pairArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

