/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.render.text.Hyperlink;
import org.jetbrains.letsPlot.core.plot.base.render.text.Latex;
import org.jetbrains.letsPlot.core.plot.base.render.text.Markdown;
import org.jetbrains.letsPlot.core.plot.base.render.text.RenderState;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002JN\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u0014J5\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\u00180\u0006H\u0000\u00a2\u0006\u0002\b\u001aJ:\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00062\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00062\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0006H\u0002J2\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u00062\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J8\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00062\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J,\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText;", "", "()V", "HYPERLINK_ELEMENT_CLASS", "", "buildLines", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "terms", "estimateWidth", "", "text", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "wrapLength", "", "maxLinesCount", "markdown", "", "widthEstimator", "Lkotlin/Function2;", "fillTextTermGaps", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "specialTerms", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "fillTextTermGaps$plot_base", "parse", "parseBreaks", "render", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextElement;", "lines", "toSvg", "wrap", "wrapLine", "line", "RichTextNode", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRichText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RichText.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/RichText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1549#2:252\n1620#2,2:253\n1622#2:256\n1360#2:257\n1446#2,5:258\n1855#2:263\n1864#2,3:264\n1856#2:267\n1855#2,2:268\n1549#2:270\n1620#2,3:271\n1549#2:274\n1620#2,3:275\n1045#2:278\n1549#2:279\n1620#2,3:280\n1855#2:283\n1549#2:284\n1620#2,3:285\n1856#2:288\n1549#2:289\n1620#2,2:290\n1855#2,2:292\n1622#2:294\n1549#2:295\n1620#2,3:296\n1360#2:299\n1446#2,5:300\n1045#2:305\n1549#2:306\n1620#2,3:307\n819#2:310\n847#2,2:311\n1#3:255\n*S KotlinDebug\n*F\n+ 1 RichText.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/RichText\n*L\n37#1:252\n37#1:253,2\n37#1:256\n73#1:257\n73#1:258,5\n89#1:263\n93#1:264,3\n89#1:267\n117#1:268,2\n156#1:270\n156#1:271,3\n157#1:274\n157#1:275,3\n159#1:278\n160#1:279\n160#1:280,3\n169#1:283\n182#1:284\n182#1:285,3\n169#1:288\n192#1:289\n192#1:290,2\n194#1:292,2\n192#1:294\n209#1:295\n209#1:296,3\n51#1:299\n51#1:300,5\n146#1:305\n148#1:306\n148#1:307,3\n153#1:310\n153#1:311,2\n*E\n"})
public final class RichText {
    @NotNull
    public static final RichText INSTANCE = new RichText();
    @NotNull
    public static final String HYPERLINK_ELEMENT_CLASS = "hyperlink-element";

    private RichText() {
    }

    @NotNull
    public final List<SvgTextElement> toSvg(@NotNull String text2, int wrapLength, int maxLinesCount, boolean markdown) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<List<RichTextNode>> lines = this.parse(text2, wrapLength, maxLinesCount, markdown);
        List<SvgTextElement> svgLines = this.render(lines);
        return svgLines;
    }

    public static /* synthetic */ List toSvg$default(RichText richText, String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return richText.toSvg(string, n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final double estimateWidth(@NotNull String text2, @NotNull Font font, int wrapLength, int maxLinesCount, boolean markdown, @NotNull Function2<? super String, ? super Font, Double> widthEstimator) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter(widthEstimator, (String)"widthEstimator");
        List<List<RichTextNode>> lines = this.parse(text2, wrapLength, maxLinesCount, markdown);
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line2;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = (Iterable)line2;
            double d = 0.0;
            for (Object t : iterable2) {
                void term;
                RichTextNode richTextNode = (RichTextNode)t;
                double d2 = d;
                boolean bl2 = false;
                RichTextNode.Span span = term instanceof RichTextNode.Span ? (RichTextNode.Span)term : null;
                double d3 = span != null ? span.estimateWidth(font, widthEstimator) : 0.0;
                d = d2 + d3;
            }
            collection.add(d);
        }
        List widths = (List)destination$iv$iv;
        Double d = CollectionsKt.maxOrNull((Iterable)widths);
        return d != null ? d : 0.0;
    }

    public static /* synthetic */ double estimateWidth$default(RichText richText, String string, Font font, int n, int n2, boolean bl, Function2 function2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        return richText.estimateWidth(string, font, n, n2, bl, (Function2<? super String, ? super Font, Double>)function2);
    }

    private final List<List<RichTextNode>> parse(String text2, int wrapLength, int maxLinesCount, boolean markdown) {
        List<RichTextNode> list2;
        List<RichTextNode> it = CollectionsKt.listOf((Object)new RichTextNode.Text(text2));
        boolean bl = false;
        List<RichTextNode> it2 = list2 = it;
        boolean bl2 = false;
        List<RichTextNode> list3 = !markdown ? list2 : null;
        if (list3 == null) {
            list3 = RichText.parse$parse((List<? extends RichTextNode>)it, (Function1<? super String, ? extends List<? extends RichTextNode>>)((Function1)new Function1<String, List<? extends RichTextNode>>((Object)Markdown.INSTANCE){

                @NotNull
                public final List<RichTextNode> invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Markdown)this.receiver).parse(p0);
                }
            }));
        }
        it = list3;
        boolean bl3 = false;
        it = RichText.parse$parse(it, (Function1<? super String, ? extends List<? extends RichTextNode>>)((Function1)new Function1<String, List<? extends RichTextNode>>((Object)Latex.INSTANCE){

            @NotNull
            public final List<RichTextNode> invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Latex)this.receiver).parse(p0);
            }
        }));
        boolean bl4 = false;
        it = RichText.parse$parse(it, (Function1<? super String, ? extends List<? extends RichTextNode>>)((Function1)new Function1<String, List<? extends RichTextNode>>((Object)Hyperlink.INSTANCE){

            @NotNull
            public final List<RichTextNode> invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Hyperlink)this.receiver).parse(p0);
            }
        }));
        boolean bl5 = false;
        List<RichTextNode> terms2 = INSTANCE.parseBreaks(it);
        List<List<RichTextNode>> lines = this.buildLines(terms2);
        List<List<RichTextNode>> wrappedLines = this.wrap(lines, wrapLength, maxLinesCount);
        return wrappedLines;
    }

    static /* synthetic */ List parse$default(RichText richText, String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return richText.parse(string, n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<RichTextNode>> wrap(List<? extends List<? extends RichTextNode>> lines, int wrapLength, int maxLinesCount) {
        List list2;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List line2 = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.wrapLine(line2, wrapLength);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List wrappedLines = (List)destination$iv$iv;
        if (maxLinesCount < 0) {
            list2 = wrappedLines;
        } else if (wrappedLines.size() < maxLinesCount) {
            list2 = wrappedLines;
        } else {
            Object[] objectArray = new List[1];
            Object[] objectArray2 = new RichTextNode.Text[]{new RichTextNode.Text("...")};
            objectArray[0] = CollectionsKt.mutableListOf((Object[])objectArray2);
            list2 = CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)wrappedLines, (int)(wrappedLines.size() - maxLinesCount)), (Iterable)CollectionsKt.mutableListOf((Object[])objectArray));
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RichTextNode> parseBreaks(List<? extends RichTextNode> terms2) {
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = terms2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RichTextNode term = (RichTextNode)element$iv;
            boolean bl = false;
            if (term instanceof RichTextNode.Text) {
                String[] stringArray = new String[]{"\n"};
                List lines = StringsKt.split$default((CharSequence)((RichTextNode.Text)term).getText(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Iterable $this$forEachIndexed$iv = lines;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void line2;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    if (((CharSequence)line2).length() > 0) {
                        result2.add(new RichTextNode.Text((String)line2));
                    }
                    if (i == CollectionsKt.getLastIndex((List)lines)) continue;
                    result2.add(RichTextNode.LineBreak.INSTANCE);
                }
                continue;
            }
            result2.add(term);
        }
        return result2;
    }

    private final List<List<RichTextNode>> buildLines(List<? extends RichTextNode> terms2) {
        if (terms2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean startNewLine = false;
        startNewLine = true;
        List lines = new ArrayList();
        Iterable $this$forEach$iv = terms2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RichTextNode term = (RichTextNode)element$iv;
            boolean bl = false;
            if (startNewLine) {
                lines.add((List)new ArrayList());
                startNewLine = false;
            }
            if (term instanceof RichTextNode.LineBreak) {
                startNewLine = true;
                continue;
            }
            ((List)CollectionsKt.last((List)lines)).add(term);
        }
        if (startNewLine) {
            lines.add((List)new ArrayList());
        }
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RichTextNode.Span> fillTextTermGaps$plot_base(@NotNull String text2, @NotNull List<? extends Pair<? extends RichTextNode.Span, IntRange>> specialTerms) {
        Iterable $this$sortedBy$iv;
        Pair pair2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(specialTerms, (String)"specialTerms");
        Iterable iterable = specialTerms;
        Object object = StringsKt.getIndices((CharSequence)text2);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IntRange termLocation = (IntRange)pair2.component2();
            collection.add(termLocation);
        }
        $this$map$iv = RichText.fillTextTermGaps$subtractRange((IntRange)object, (List)destination$iv$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pos;
            pair2 = (IntRange)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to((Object)new RichTextNode.Text(StringsKt.substring((String)text2, (IntRange)pos)), (Object)pos));
        }
        List textTerms = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus((Collection)specialTerms, (Iterable)textTerms);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Pair pair2 = (Pair)a2;
                boolean bl = false;
                IntRange termLocation = (IntRange)pair2.component2();
                pair2 = (Pair)b2;
                Comparable comparable = Integer.valueOf(termLocation.getFirst());
                bl = false;
                termLocation = (IntRange)pair2.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(termLocation.getFirst()));
            }
        });
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair2 = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            RichTextNode.Span term = (RichTextNode.Span)pair2.component1();
            object.add(term);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<RichTextNode>> wrapLine(List<? extends RichTextNode> line2, int wrapLength) {
        if (wrapLength <= 0) {
            return CollectionsKt.listOf(line2);
        }
        Object[] objectArray = new List[]{new ArrayList()};
        List wrappedLines = CollectionsKt.mutableListOf((Object[])objectArray);
        Iterable $this$forEach$iv = line2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$map$iv;
            int n;
            RichTextNode term = (RichTextNode)element$iv;
            boolean bl = false;
            Object object = (Object[])CollectionsKt.last((List)wrappedLines);
            int n2 = wrapLength;
            int n3 = 0;
            for (Object t : object) {
                void it;
                RichTextNode richTextNode = (RichTextNode)t;
                n = n3;
                boolean bl2 = false;
                RichTextNode.Span span = it instanceof RichTextNode.Span ? (RichTextNode.Span)it : null;
                int n4 = span != null ? span.getVisualCharCount() : 0;
                n3 = n + n4;
            }
            n = n3;
            int availableSpace = n2 - n;
            if (term instanceof RichTextNode.Span && ((RichTextNode.Span)term).getVisualCharCount() <= availableSpace) {
                ((List)CollectionsKt.last((List)wrappedLines)).add(term);
                continue;
            }
            if (term instanceof RichTextNode.Span && ((RichTextNode.Span)term).getVisualCharCount() <= wrapLength) {
                object = new RichTextNode[]{term};
                wrappedLines.add(CollectionsKt.mutableListOf((Object[])object));
                continue;
            }
            if (!(term instanceof RichTextNode.Text)) {
                object = new RichTextNode[]{term};
                wrappedLines.add(CollectionsKt.mutableListOf((Object[])object));
                continue;
            }
            Object object2 = CollectionsKt.last((List)wrappedLines);
            List it = (List)object2;
            boolean bl2 = false;
            object = (List)(availableSpace > 0 ? object2 : null);
            if (object != null) {
                object.add(new RichTextNode.Text(StringsKt.take((String)((RichTextNode.Text)term).getText(), (int)availableSpace)));
            }
            object = wrappedLines;
            object2 = StringsKt.chunked((CharSequence)StringsKt.drop((String)((RichTextNode.Text)term).getText(), (int)availableSpace), (int)wrapLength);
            boolean $i$f$map = false;
            void var14_20 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : var14_20) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Object[] objectArray2 = new RichTextNode[]{new RichTextNode.Text((String)it2)};
                collection.add(CollectionsKt.mutableListOf((Object[])objectArray2));
            }
            object2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
        }
        return wrappedLines;
    }

    static /* synthetic */ List wrapLine$default(RichText richText, List list2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return richText.wrapLine(list2, n);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SvgTextElement> render(List<? extends List<? extends RichTextNode>> lines) {
        List line2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object[] objectArray = new RenderState[]{new RenderState(false, false, null, 7, null)};
        List stack2 = CollectionsKt.mutableListOf((Object[])objectArray);
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2 = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            List svg = new ArrayList();
            Iterable $this$forEach$iv = line2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RichTextNode term = (RichTextNode)element$iv;
                boolean bl2 = false;
                RichTextNode richTextNode = term;
                if (richTextNode instanceof RichTextNode.StrongStart) {
                    stack2.add(RenderState.copy$default((RenderState)CollectionsKt.last((List)stack2), false, true, null, 5, null));
                    continue;
                }
                if (richTextNode instanceof RichTextNode.EmphasisStart) {
                    stack2.add(RenderState.copy$default((RenderState)CollectionsKt.last((List)stack2), true, false, null, 6, null));
                    continue;
                }
                if (richTextNode instanceof RichTextNode.ColorStart) {
                    stack2.add(RenderState.copy$default((RenderState)CollectionsKt.last((List)stack2), false, false, ((RichTextNode.ColorStart)term).getColor(), 3, null));
                    continue;
                }
                if ((richTextNode instanceof RichTextNode.StrongEnd ? true : richTextNode instanceof RichTextNode.EmphasisEnd) ? true : richTextNode instanceof RichTextNode.ColorEnd) {
                    CollectionsKt.removeLast((List)stack2);
                    continue;
                }
                if (!(richTextNode instanceof RichTextNode.Span)) continue;
                CollectionsKt.addAll((Collection)svg, (Iterable)((RichTextNode.Span)term).render((RenderState)CollectionsKt.last((List)stack2)));
            }
            collection.add(svg);
        }
        List svgLines = (List)destination$iv$iv;
        $this$map$iv = svgLines;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SvgTextElement svgTextElement;
            line2 = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            SvgTextElement $this$render_u24lambda_u2425_u24lambda_u2424 = svgTextElement = new SvgTextElement();
            boolean bl3 = false;
            $this$render_u24lambda_u2425_u24lambda_u2424.children().addAll((Collection)it);
            collection.add(svgTextElement);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<RichTextNode> parse$parse(List<? extends RichTextNode> nodes, Function1<? super String, ? extends List<? extends RichTextNode>> parser) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = nodes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RichTextNode node = (RichTextNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = node instanceof RichTextNode.Text ? (List)parser.invoke((Object)((RichTextNode.Text)node).getText()) : CollectionsKt.listOf((Object)node);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IntRange> fillTextTermGaps$subtractRange(IntRange range, List<IntRange> toSubtract) {
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (toSubtract.isEmpty()) {
            return CollectionsKt.listOf((Object)range);
        }
        Iterable $this$sortedBy$iv = toSubtract;
        boolean $i$f$sortedBy = false;
        List sortedToSubtract = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                IntRange p0 = (IntRange)a2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(p0.getFirst());
                p0 = (IntRange)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getFirst()));
            }
        });
        IntRange firstRange = new IntRange(range.getFirst(), ((IntRange)CollectionsKt.first((List)sortedToSubtract)).getFirst() - 1);
        Iterable $this$map$iv = CollectionsKt.windowed$default((Iterable)sortedToSubtract, (int)2, (int)0, (boolean)false, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IntRange prevRange = (IntRange)list2.get(0);
            IntRange nextRange = (IntRange)list2.get(1);
            collection.add(new IntRange(prevRange.getLast() + 1, nextRange.getFirst() - 1));
        }
        List intermediateRanges = (List)destination$iv$iv;
        IntRange lastRange = new IntRange(((IntRange)CollectionsKt.last((List)sortedToSubtract)).getLast() + 1, range.getLast());
        Iterable $this$filterNot$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)firstRange), (Iterable)intermediateRanges), (Iterable)CollectionsKt.listOf((Object)lastRange));
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IntRange p0 = (IntRange)element$iv$iv;
            boolean bl = false;
            if (p0.isEmpty()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\bf\u0018\u00002\u00020\u0001:\t\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "", "ColorEnd", "ColorStart", "EmphasisEnd", "EmphasisStart", "LineBreak", "Span", "StrongEnd", "StrongStart", "Text", "plot-base"})
    public static interface RichTextNode {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$ColorEnd;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "()V", "plot-base"})
        public static final class ColorEnd
        implements RichTextNode {
            @NotNull
            public static final ColorEnd INSTANCE = new ColorEnd();

            private ColorEnd() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$ColorStart;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "getColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "toString", "", "plot-base"})
        public static final class ColorStart
        implements RichTextNode {
            @NotNull
            private final Color color;

            public ColorStart(@NotNull Color color) {
                Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                this.color = color;
            }

            @NotNull
            public final Color getColor() {
                return this.color;
            }

            @NotNull
            public String toString() {
                return "ColorStart(color=" + this.color + ')';
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$EmphasisEnd;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "()V", "plot-base"})
        public static final class EmphasisEnd
        implements RichTextNode {
            @NotNull
            public static final EmphasisEnd INSTANCE = new EmphasisEnd();

            private EmphasisEnd() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$EmphasisStart;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "()V", "plot-base"})
        public static final class EmphasisStart
        implements RichTextNode {
            @NotNull
            public static final EmphasisStart INSTANCE = new EmphasisStart();

            private EmphasisStart() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$LineBreak;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "()V", "plot-base"})
        public static final class LineBreak
        implements RichTextNode {
            @NotNull
            public static final LineBreak INSTANCE = new LineBreak();

            private LineBreak() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u000bH&J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "visualCharCount", "", "getVisualCharCount", "()I", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "render", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "plot-base"})
        public static interface Span
        extends RichTextNode {
            public int getVisualCharCount();

            public double estimateWidth(@NotNull Font var1, @NotNull Function2<? super String, ? super Font, Double> var2);

            @NotNull
            public List<SvgElement> render(@NotNull RenderState var1);

            @NotNull
            public List<SvgElement> render();

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static List<SvgElement> render(@NotNull Span $this) {
                    return $this.render(new RenderState(false, false, null, 7, null));
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$StrongEnd;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "()V", "plot-base"})
        public static final class StrongEnd
        implements RichTextNode {
            @NotNull
            public static final StrongEnd INSTANCE = new StrongEnd();

            private StrongEnd() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$StrongStart;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "()V", "plot-base"})
        public static final class StrongStart
        implements RichTextNode {
            @NotNull
            public static final StrongStart INSTANCE = new StrongStart();

            private StrongStart() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Text;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "visualCharCount", "", "getVisualCharCount", "()I", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "render", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "toString", "plot-base"})
        public static final class Text
        implements Span {
            @NotNull
            private final String text;
            private final int visualCharCount;

            public Text(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.text = text2;
                this.visualCharCount = this.text.length();
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @Override
            public int getVisualCharCount() {
                return this.visualCharCount;
            }

            @Override
            public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
                Intrinsics.checkNotNullParameter((Object)font, (String)"font");
                Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
                return ((Number)widthCalculator.invoke((Object)this.text, (Object)font)).doubleValue();
            }

            @Override
            @NotNull
            public List<SvgElement> render(@NotNull RenderState context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                SvgTSpanElement tSpan = new SvgTSpanElement(this.text);
                context.apply(tSpan);
                return CollectionsKt.listOf((Object)tSpan);
            }

            @NotNull
            public String toString() {
                return "Text(text='" + this.text + "')";
            }

            @Override
            @NotNull
            public List<SvgElement> render() {
                return Span.DefaultImpls.render(this);
            }
        }
    }
}

