/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintsCollection;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0090\u0001\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00162\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00162\u001a\b\u0002\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\n0\u00162\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u000e\u0010\u001e\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "", "isVertical", "", "(Z)V", "isVertical$plot_base", "()Z", "buildHints", "", "hintAesList", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "fillColorMapper", "Lorg/jetbrains/letsPlot/commons/values/Color;", "colorMarkerMapper", "defaultTooltipKind", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint$Kind;", "flip", "clientRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "doubleSegment", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "point", "getEffectiveAes", "aes", "plot-base"})
@SourceDebugExtension(value={"SMAP\nFlippableGeomHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlippableGeomHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1789#2,3:120\n*S KotlinDebug\n*F\n+ 1 FlippableGeomHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper\n*L\n98#1:120,3\n*E\n"})
public final class FlippableGeomHelper {
    private final boolean isVertical;

    public FlippableGeomHelper(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public final boolean isVertical$plot_base() {
        return this.isVertical;
    }

    @NotNull
    public final Aes<Double> getEffectiveAes(@NotNull Aes<Double> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        if (!this.isVertical) {
            Aes<Double> aes3 = aes2;
            if (Intrinsics.areEqual(aes3, Aes.Companion.getX())) {
                return Aes.Companion.getY();
            }
            if (Intrinsics.areEqual(aes3, Aes.Companion.getY())) {
                return Aes.Companion.getX();
            }
            if (Intrinsics.areEqual(aes3, Aes.Companion.getYMIN())) {
                return Aes.Companion.getXMIN();
            }
            if (Intrinsics.areEqual(aes3, Aes.Companion.getYMAX())) {
                return Aes.Companion.getXMAX();
            }
            if (Intrinsics.areEqual(aes3, Aes.Companion.getXMIN())) {
                return Aes.Companion.getYMIN();
            }
            if (Intrinsics.areEqual(aes3, Aes.Companion.getXMAX())) {
                return Aes.Companion.getYMAX();
            }
            if (Intrinsics.areEqual(aes3, Aes.Companion.getWIDTH())) {
                return Aes.Companion.getHEIGHT();
            }
            if (Intrinsics.areEqual(aes3, Aes.Companion.getHEIGHT())) {
                return Aes.Companion.getWIDTH();
            }
            throw new IllegalStateException(("Aes " + aes2.getName() + " not allowed for function getEffectiveAes").toString());
        }
        return aes2;
    }

    @NotNull
    public final DoubleVector flip(@NotNull DoubleVector point) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        boolean bl = this.isVertical;
        if (bl) {
            doubleVector = point;
        } else if (!bl) {
            doubleVector = point.flip();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return doubleVector;
    }

    @NotNull
    public final DoubleRectangle flip(@NotNull DoubleRectangle clientRect) {
        DoubleRectangle doubleRectangle;
        Intrinsics.checkNotNullParameter((Object)clientRect, (String)"clientRect");
        boolean bl = this.isVertical;
        if (bl) {
            doubleRectangle = clientRect;
        } else if (!bl) {
            doubleRectangle = clientRect.flip();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return doubleRectangle;
    }

    @NotNull
    public final DoubleSegment flip(@NotNull DoubleSegment doubleSegment) {
        DoubleSegment doubleSegment2;
        Intrinsics.checkNotNullParameter((Object)doubleSegment, (String)"doubleSegment");
        boolean bl = this.isVertical;
        if (bl) {
            doubleSegment2 = doubleSegment;
        } else if (!bl) {
            doubleSegment2 = new DoubleSegment(doubleSegment.getStart().flip(), doubleSegment.getEnd().flip());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return doubleSegment2;
    }

    /*
     * WARNING - void declaration
     */
    public final void buildHints(@NotNull List<Aes<Double>> hintAesList, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> clientRectFactory, @NotNull Function1<? super DataPointAesthetics, Color> fillColorMapper, @NotNull Function1<? super DataPointAesthetics, ? extends List<Color>> colorMarkerMapper, @Nullable TipLayoutHint.Kind defaultTooltipKind) {
        boolean bl;
        Intrinsics.checkNotNullParameter(hintAesList, (String)"hintAesList");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Intrinsics.checkNotNullParameter(clientRectFactory, (String)"clientRectFactory");
        Intrinsics.checkNotNullParameter(fillColorMapper, (String)"fillColorMapper");
        Intrinsics.checkNotNullParameter(colorMarkerMapper, (String)"colorMarkerMapper");
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        boolean bl2 = this.isVertical;
        if (bl2) {
            bl = !ctx2.getFlipped();
        } else if (!bl2) {
            bl = ctx2.getFlipped();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVerticallyOriented = bl;
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            void $this$fold$iv;
            double d;
            DoubleRectangle clientRect;
            if ((DoubleRectangle)clientRectFactory.invoke((Object)p) == null) continue;
            DoubleRectangle $this$buildHints_u24lambda_u240 = clientRect;
            boolean bl3 = false;
            boolean bl4 = isVerticallyOriented;
            if (bl4) {
                d = $this$buildHints_u24lambda_u240.getWidth() / 2.0;
            } else if (!bl4) {
                d = $this$buildHints_u24lambda_u240.getHeight() / 2.0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            double objectRadius = d;
            HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(objectRadius);
            Double d2 = p.get(this.getEffectiveAes(Aes.Companion.getX()));
            Intrinsics.checkNotNull((Object)d2);
            HintsCollection.HintConfigFactory hintFactory = hintConfigFactory.defaultCoord(((Number)d2).doubleValue()).defaultKind(isVerticallyOriented ? TipLayoutHint.Kind.HORIZONTAL_TOOLTIP : TipLayoutHint.Kind.ROTATED_TOOLTIP);
            Iterable iterable = hintAesList;
            HintsCollection initial$iv = new HintsCollection(p, helper2);
            boolean $i$f$fold = false;
            HintsCollection accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void aes2;
                Aes aes3 = (Aes)element$iv;
                HintsCollection acc = accumulator$iv;
                boolean bl5 = false;
                accumulator$iv = acc.addHint(hintFactory.create((Aes<Double>)aes2));
            }
            Map<Aes<?>, TipLayoutHint> hints = accumulator$iv.getHints();
            GeomTargetCollector geomTargetCollector = ctx2.getTargetCollector();
            int n = p.index();
            GeomTargetCollector.TooltipParams tooltipParams = new GeomTargetCollector.TooltipParams(hints, null, (Color)fillColorMapper.invoke((Object)p), (List)colorMarkerMapper.invoke((Object)p), 2, null);
            TipLayoutHint.Kind kind = defaultTooltipKind;
            if (kind == null) {
                kind = isVerticallyOriented ? TipLayoutHint.Kind.HORIZONTAL_TOOLTIP : TipLayoutHint.Kind.VERTICAL_TOOLTIP;
            }
            geomTargetCollector.addRectangle(n, clientRect, tooltipParams, kind);
        }
    }

    public static /* synthetic */ void buildHints$default(FlippableGeomHelper flippableGeomHelper, List list2, Aesthetics aesthetics2, PositionAdjustment positionAdjustment, CoordinateSystem coordinateSystem, GeomContext geomContext, Function1 function1, Function1 function12, Function1 function13, TipLayoutHint.Kind kind, int n, Object object) {
        if ((n & 0x40) != 0) {
            function12 = buildHints.1.INSTANCE;
        }
        if ((n & 0x80) != 0) {
            function13 = HintColorUtil.INSTANCE.createColorMarkerMapper(null, geomContext);
        }
        if ((n & 0x100) != 0) {
            kind = null;
        }
        flippableGeomHelper.buildHints(list2, aesthetics2, positionAdjustment, coordinateSystem, geomContext, (Function1<? super DataPointAesthetics, DoubleRectangle>)function1, (Function1<? super DataPointAesthetics, Color>)function12, function13, kind);
    }
}

