/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.EventAppearance;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.QuantityReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ReaderFactory;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.EventTypeDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ProducerDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;
import org.openjdk.jmc.flightrecorder.parser.IEventSink;
import org.openjdk.jmc.flightrecorder.parser.IEventSinkFactory;
import org.openjdk.jmc.flightrecorder.parser.ValueField;
import org.openjdk.jmc.flightrecorder.parser.synthetic.OracleJdkTypeIDsPre11;

class EventParserManager {
    static final int METADATA_EVENT_TYPE_INDEX = 0;
    static final int CHECK_POINT_EVENT_TYPE_INDEX = 1;
    static final int LOST_EVENT_TYPE_INDEX = 2;
    static final int CONTENT_TYPE_POOL_NONE = 0;
    static final int CONTENT_TYPE_MEMORY = 1;
    static final int CONTENT_TYPE_EPOCHMILLIS = 2;
    static final int CONTENT_TYPE_MILLIS = 3;
    static final int CONTENT_TYPE_NANOS = 4;
    static final int CONTENT_TYPE_TICKS = 5;
    static final int CONTENT_TYPE_ADDRESS = 6;
    static final int CONTENT_TYPE_THREADID = 7;
    static final int CONTENT_TYPE_JAVATHREADID = 8;
    static final int CONTENT_TYPE_STACKTRACEID = 9;
    static final int CONTENT_TYPE_PERCENTAGE = 11;
    private final FastAccessNumberMap<EventTypeEntry> eventTypes = new FastAccessNumberMap(100, 5);
    private final ReaderFactory readerFactory;
    private final LoaderContext context;

    public EventParserManager(ReaderFactory readerFactory, LoaderContext context2, ProducerDescriptor ... producers) throws InvalidJfrFileException {
        this.readerFactory = readerFactory;
        this.context = context2;
        for (ProducerDescriptor pd : producers) {
            for (EventTypeDescriptor etd : pd.getEventTypeDescriptors()) {
                String path = etd.getPath();
                String id = pd.getURIString() + path;
                EventTypeBuilder eventSpec = new EventTypeBuilder(id, etd);
                String[] category = EventAppearance.getHumanSegmentArray(path);
                category = Arrays.copyOf(category, category.length - 1);
                IEventSink sink = context2.getSinkFactory().create(id, etd.getLabel(), category, etd.getDescription(), eventSpec.getValueFields());
                String typeId = OracleJdkTypeIDsPre11.translate(id);
                this.eventTypes.put(etd.getIdentifier(), new EventTypeEntry(typeId, sink, etd.hasStartTime(), eventSpec.getValueReaders()));
            }
        }
        this.eventTypes.put(2L, this.createBufferLostEntry(context2.getSinkFactory()));
    }

    void loadEvent(ByteBufferWrapper data, Offset offset, int eventTypeId) throws InvalidJfrFileException {
        EventTypeEntry ep = this.eventTypes.get(eventTypeId);
        if (ep == null) {
            throw new IllegalArgumentException("Event type " + eventTypeId + " is not described in the file");
        }
        long size = offset.getEnd() - offset.get();
        long endTime = this.readerFactory.readTicksTimestamp(data, offset);
        int valueIndex = 0;
        if (ep.hasStartTime) {
            ((EventTypeEntry)ep).values[valueIndex++] = UnitLookup.EPOCH_NS.quantity(this.readerFactory.readTicksTimestamp(data, offset));
        }
        ((EventTypeEntry)ep).values[valueIndex++] = UnitLookup.EPOCH_NS.quantity(endTime);
        for (int n = 0; n < ep.parsers.length; ++n) {
            ((EventTypeEntry)ep).values[valueIndex++] = ep.parsers[n].readValue(data, offset, endTime);
        }
        ep.sink.addEvent(ep.values);
        this.context.updateEventStats(ep.typeId, size);
    }

    private EventTypeEntry createBufferLostEntry(IEventSinkFactory esf) throws InvalidJfrFileException {
        EventTypeBuilder eventReader = new EventTypeBuilder();
        eventReader.addThreadField();
        eventReader.addMemoryDroppedField();
        IEventSink sink = esf.create("org.openjdk.jmc.flightrecorder.bufferlosttypeid", Messages.getString("EventParserManager_TYPE_BUFFER_LOST"), EventAppearance.getHumanSegmentArray("recordings"), Messages.getString("EventParserManager_TYPE_BUFFER_LOST_DESC"), eventReader.getValueFields());
        return new EventTypeEntry("org.openjdk.jmc.flightrecorder.bufferlosttypeid", sink, false, eventReader.getValueReaders());
    }

    private static class EventTypeEntry {
        private final String typeId;
        private final Object[] values;
        private final IValueReader[] parsers;
        private final IEventSink sink;
        private final boolean hasStartTime;

        public EventTypeEntry(String typeId, IEventSink sink, boolean hasStartTime, IValueReader[] valueParsers) {
            this.typeId = typeId;
            this.parsers = valueParsers;
            this.sink = sink;
            this.hasStartTime = hasStartTime;
            this.values = new Object[(hasStartTime ? 2 : 1) + this.parsers.length];
        }
    }

    private class EventTypeBuilder {
        private final List<IValueReader> readers = new ArrayList<IValueReader>();
        private final List<ValueField> valueFields = new ArrayList<ValueField>();

        EventTypeBuilder() {
            this.valueFields.add(new ValueField(JfrAttributes.END_TIME));
        }

        EventTypeBuilder(String typeId, EventTypeDescriptor etd) throws InvalidJfrFileException {
            if (etd.hasStartTime()) {
                this.valueFields.add(new ValueField(JfrAttributes.START_TIME));
            }
            this.valueFields.add(new ValueField(JfrAttributes.END_TIME));
            if (etd.hasThread()) {
                this.addThreadField();
            }
            if (etd.canHaveStacktrace()) {
                this.addStacktraceField();
            }
            for (ValueDescriptor vd : etd.getDataStructure()) {
                this.add(typeId, vd);
            }
        }

        void add(String typeId, ValueDescriptor vd) throws InvalidJfrFileException {
            if (vd.getDataType() == DataType.STRUCT) {
                for (ValueDescriptor child : vd.getChildren()) {
                    this.add(typeId, child, vd.getIdentifier() + ":" + child.getIdentifier(), vd.getName() + " : " + child.getName());
                }
            } else {
                this.add(typeId, vd, vd.getIdentifier(), vd.getName());
            }
        }

        private void add(String typeId, ValueDescriptor vd, String identifier, String name) throws InvalidJfrFileException {
            String valueType = EventParserManager.this.context.getValueInterpretation(typeId, identifier);
            IValueReader r = EventParserManager.this.readerFactory.createReader(vd, valueType);
            this.readers.add(r);
            this.valueFields.add(new ValueField(identifier, name, vd.getDescription(), r.getValueType()));
        }

        private void addThreadField() throws InvalidJfrFileException {
            this.readers.add(EventParserManager.this.readerFactory.createConstantReader(DataType.U4, 7));
            this.valueFields.add(new ValueField(JfrAttributes.EVENT_THREAD));
        }

        private void addStacktraceField() throws InvalidJfrFileException {
            this.readers.add(EventParserManager.this.readerFactory.createConstantReader(DataType.U8, 9));
            this.valueFields.add(new ValueField(JfrAttributes.EVENT_STACKTRACE));
        }

        private void addMemoryDroppedField() throws InvalidJfrFileException {
            this.readers.add(new QuantityReader(DataType.U4, UnitLookup.BYTE));
            this.valueFields.add(new ValueField(JfrAttributes.FLR_DATA_LOST));
        }

        IValueReader[] getValueReaders() {
            return this.readers.toArray(new IValueReader[this.readers.size()]);
        }

        List<ValueField> getValueFields() {
            return Collections.unmodifiableList(this.valueFields);
        }
    }
}

