/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jbonlymac;

import com.intellij.profiler.ultimate.jbonlymac.CompiledMethodsStorageKt;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRange;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRangeWithData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0000\u0018\u0000 '*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0001'B%\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00162\u0006\u0010\"\u001a\u00020\fJ4\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00160\u00132\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004H\u0002J\u0017\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010&R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0011R\u001e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011\u00a8\u0006("}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;", "T", "", "memoryRanges", "", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangeWithData;", "maximumBucketsCount", "", "<init>", "(Ljava/util/List;I)V", "sortedRanges", "minAddress", "", "maxAddress", "totalLength", "buckets", "getBuckets", "()I", "bucketRanges", "", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRange;", "rangesStorage", "", "isEmpty", "", "()Z", "totalElementsCount", "getTotalElementsCount", "value", "totalRequests", "getTotalRequests", "outOfRangeRequests", "getOutOfRangeRequests", "getRangesAddressBelongsTo", "address", "fillStorage", "generateBucketRanges", "bucketByAddress", "(J)Ljava/lang/Integer;", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nCompiledMethodsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledMethodsStorage.kt\ncom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n2423#2,14:146\n1999#2,14:160\n1573#2:174\n1604#2,4:175\n1563#2:179\n1634#2,3:180\n1869#2:183\n1869#2:184\n1870#2:192\n1870#2:193\n382#3,7:185\n1#4:194\n*S KotlinDebug\n*F\n+ 1 CompiledMethodsStorage.kt\ncom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage\n*L\n88#1:146,14\n89#1:160,14\n92#1:174\n92#1:175,4\n97#1:179\n97#1:180,3\n118#1:183\n120#1:184\n120#1:192\n118#1:193\n121#1:185,7\n*E\n"})
public final class MemoryRangesStorage<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends MemoryRangeWithData<? extends T>> sortedRanges;
    private final long minAddress;
    private final long maxAddress;
    private final long totalLength;
    private final int buckets;
    @NotNull
    private final Map<Integer, MemoryRange> bucketRanges;
    @NotNull
    private final Map<Integer, Set<MemoryRangeWithData<T>>> rangesStorage;
    private final boolean isEmpty;
    private final int totalElementsCount;
    private int totalRequests;
    private int outOfRangeRequests;
    @NotNull
    private static final MemoryRangesStorage EMPTY = new MemoryRangesStorage(CollectionsKt.emptyList(), 0, 2, null);

    /*
     * WARNING - void declaration
     */
    public MemoryRangesStorage(@NotNull List<? extends MemoryRangeWithData<? extends T>> memoryRanges, int maximumBucketsCount) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        int n;
        Object v2;
        void $this$maxByOrNull$iv;
        long v$iv;
        Object e$iv;
        Object v0;
        Iterable $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter(memoryRanges, (String)"memoryRanges");
        this.sortedRanges = CollectionsKt.sorted((Iterable)memoryRanges);
        Iterable iterable = this.sortedRanges;
        MemoryRangesStorage memoryRangesStorage = this;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                MemoryRangeWithData it = (MemoryRangeWithData)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.getStart();
                do {
                    e$iv = iterator$iv.next();
                    MemoryRangeWithData it2 = (MemoryRangeWithData)e$iv;
                    $i$a$-minByOrNull-MemoryRangesStorage$minAddress$1 = false;
                    v$iv = it2.getStart();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        MemoryRangeWithData memoryRangeWithData = v0;
        memoryRangesStorage.minAddress = memoryRangeWithData != null ? memoryRangeWithData.getStart() : 0L;
        $this$minByOrNull$iv = this.sortedRanges;
        memoryRangesStorage = this;
        boolean $i$f$maxByOrNull22 = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                MemoryRangeWithData it = (MemoryRangeWithData)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getEnd();
                do {
                    e$iv = iterator$iv.next();
                    MemoryRangeWithData it3 = (MemoryRangeWithData)e$iv;
                    n = 0;
                    v$iv = it3.getEnd();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        MemoryRangeWithData memoryRangeWithData2 = v2;
        memoryRangesStorage.maxAddress = (memoryRangeWithData2 != null ? memoryRangeWithData2.getEnd() : 1L) - 1L;
        this.totalLength = this.maxAddress == 0L && this.minAddress == 0L ? 0L : this.maxAddress + 1L - this.minAddress;
        this.buckets = RangesKt.coerceAtMost((int)maximumBucketsCount, (int)((int)this.totalLength));
        Iterable iterable2 = this.generateBucketRanges();
        memoryRangesStorage = this;
        boolean $i$f$mapIndexed = false;
        void $i$f$maxByOrNull22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void v;
            void k;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MemoryRange memoryRange = (MemoryRange)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)((int)k), (Object)v));
        }
        memoryRangesStorage.bucketRanges = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.rangesStorage = this.fillStorage(memoryRanges);
        this.isEmpty = this.totalLength == 0L;
        $this$mapIndexed$iv = this.rangesStorage.values();
        memoryRangesStorage = this;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Set item$iv$iv2 = (Set)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.size());
        }
        memoryRangesStorage.totalElementsCount = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    public /* synthetic */ MemoryRangesStorage(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        this(list, n);
    }

    public final int getBuckets() {
        return this.buckets;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final int getTotalElementsCount() {
        return this.totalElementsCount;
    }

    public final int getTotalRequests() {
        return this.totalRequests;
    }

    public final int getOutOfRangeRequests() {
        return this.outOfRangeRequests;
    }

    @NotNull
    public final Set<MemoryRangeWithData<T>> getRangesAddressBelongsTo(long address) {
        Set set;
        long l = this.minAddress;
        if (!(address <= this.maxAddress - 1L ? l <= address : false)) {
            if (!this.isEmpty) {
                int n = this.outOfRangeRequests;
                this.outOfRangeRequests = n + 1;
            }
            set = SetsKt.emptySet();
        } else {
            int n = this.totalRequests;
            this.totalRequests = n + 1;
            set = this.rangesStorage.get(this.bucketByAddress(address));
            if (set == null) {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, Set<MemoryRangeWithData<T>>> fillStorage(List<? extends MemoryRangeWithData<? extends T>> memoryRanges) {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = memoryRanges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MemoryRangeWithData range = (MemoryRangeWithData)element$iv;
            boolean bl = false;
            Integer n = this.bucketByAddress(range.getStart());
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = this.bucketByAddress(range.getEnd() - 1L);
            Intrinsics.checkNotNull((Object)n3);
            IntRange bucketIndexes = new IntRange(n2, n3.intValue());
            Iterable $this$forEach$iv2 = (Iterable)bucketIndexes;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                Object object;
                void $this$getOrPut$iv;
                int element$iv2;
                int index = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                Map map2 = map;
                Integer key$iv = index;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    HashSet answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((HashSet)object).add(range);
            }
        }
        return map;
    }

    private final List<MemoryRange> generateBucketRanges() {
        if (this.buckets <= 1 || this.sortedRanges.isEmpty()) {
            return CollectionsKt.listOf((Object)new MemoryRange(this.minAddress, this.totalLength));
        }
        long step = this.totalLength / (long)this.buckets;
        if (!(step >= 1L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new MemoryRange[]{new MemoryRange(this.minAddress, step)};
        List result = CollectionsKt.mutableListOf((Object[])objectArray);
        int n = this.buckets;
        for (int i = 2; i < n; ++i) {
            ((Collection)result).add(new MemoryRange(((MemoryRange)CollectionsKt.last((List)result)).getEnd(), step));
        }
        ((Collection)result).add(new MemoryRange(((MemoryRange)CollectionsKt.last((List)result)).getEnd(), this.maxAddress + 1L - ((MemoryRange)CollectionsKt.last((List)result)).getEnd()));
        return result;
    }

    private final Integer bucketByAddress(long address) {
        Object v0;
        block1: {
            Iterable iterable = this.bucketRanges.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!CompiledMethodsStorageKt.inMemoryRange(address, (MemoryRange)it.getValue())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (Integer)entry.getKey() : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;", "", "getEMPTY", "()Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MemoryRangesStorage getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

