/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.api.AllocationSizeMetric;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.ui.ArbitraryFirstSortOrderTableView;
import com.intellij.profiler.ui.JBRunnerClosableTabs;
import com.intellij.profiler.ui.LazyPanel;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.TableRowsProportionRule;
import com.intellij.profiler.ui.callusage.CallUsageTableCellRenderer;
import com.intellij.profiler.ui.callusage.Percentage;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.analyzers.StringDuplicatesAnalyzer;
import com.intellij.profiler.ultimate.hprof.api.MuiArray;
import com.intellij.profiler.ultimate.hprof.api.MuiElement;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiRecord;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiStub;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.MuiTypes;
import com.intellij.profiler.ultimate.hprof.api.MuiUtils;
import com.intellij.profiler.ultimate.hprof.api.visitors.CollectMuiVisitor;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitor;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitorWithComparator;
import com.intellij.profiler.ultimate.hprof.comparators.MuiComparators;
import com.intellij.profiler.ultimate.hprof.ui.ClassHistogramPanel;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewComponentTab;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewTopLevelComponent;
import com.intellij.profiler.ultimate.hprof.ui.MergedPathPanel;
import com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanel;
import com.intellij.profiler.ultimate.hprof.ui.OnePercentProgressIndicator;
import com.intellij.profiler.ultimate.hprof.ui.RenderUtilsKt;
import com.intellij.profiler.ultimate.hprof.ui.SummarySnapshotPanel;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanel;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanelElement;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanelModel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToLongFunction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0004\u0015\u0018\u001b\u001e\u0018\u0000 E*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u00052\u00020\u0006:\u0001EB+\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00028\u0000\u00a2\u0006\u0002\u0010,J%\u0010-\u001a\u00020*2\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/2\u0006\u0010+\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00100J3\u00101\u001a\b\u0012\u0004\u0012\u00020#022\u0006\u0010+\u001a\u00028\u00002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u0002062\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/H\u0002J\u001d\u0010;\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010<2\u0006\u0010+\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010=J\u0015\u0010>\u001a\u00020?2\u0006\u0010+\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020\u0013H\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020CH\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR&\u0010 \u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\b\u0001\u0012\u0004\u0018\u00010#0\"0!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006F"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewComponentTab;", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "project", "Lcom/intellij/openapi/project/Project;", "topLevelComponent", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;)V", "getSnapshot", "()Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "hprofClassToStringConvertor", "Lcom/intellij/util/containers/Convertor;", "", "classColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$classColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$classColumn$1;", "instanceColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$instanceColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$instanceColumn$1;", "shallowSizeColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$shallowSizeColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$shallowSizeColumn$1;", "retainedSizeColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$retainedSizeColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$retainedSizeColumn$1;", "columns", "", "Lcom/intellij/util/ui/ColumnInfo;", "", "[Lcom/intellij/util/ui/ColumnInfo;", "table", "Lcom/intellij/profiler/ui/ArbitraryFirstSortOrderTableView;", "getTable", "()Lcom/intellij/profiler/ui/ArbitraryFirstSortOrderTableView;", "openObjectView", "", "type", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)V", "loadMore", "panel", "Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel;", "(Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel;Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)V", "collectObjects", "", "limit", "", "values", "Lit/unimi/dsi/fastutil/longs/LongSet;", "localIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;ILit/unimi/dsi/fastutil/longs/LongSet;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/util/List;", "collectViewObjectIds", "createComparator", "Ljava/util/Comparator;", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)Ljava/util/Comparator;", "isSimpleInsertion", "", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)Z", "getTabName", "createRightComponent", "Ljavax/swing/JComponent;", "createCenterComponent", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nClassHistogramPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassHistogramPanel.kt\ncom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,460:1\n32#2,2:461\n1869#3,2:463\n1869#3,2:465\n1068#3:468\n1#4:467\n*S KotlinDebug\n*F\n+ 1 ClassHistogramPanel.kt\ncom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel\n*L\n237#1:461,2\n378#1:463,2\n386#1:465,2\n418#1:468\n*E\n"})
public final class ClassHistogramPanel<T extends MuiType, I extends MuiInstance>
extends BorderLayoutPanel
implements MemoryViewComponentTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MuiSnapshot<T, I> snapshot;
    @NotNull
    private final Project project;
    @NotNull
    private final MemoryViewTopLevelComponent topLevelComponent;
    @NotNull
    private final Convertor<MuiType, String> hprofClassToStringConvertor;
    @NotNull
    private final classColumn.1 classColumn;
    @NotNull
    private final instanceColumn.1 instanceColumn;
    @NotNull
    private final shallowSizeColumn.1 shallowSizeColumn;
    @NotNull
    private final retainedSizeColumn.1 retainedSizeColumn;
    @NotNull
    private final ColumnInfo<MuiType, ? extends Object>[] columns;
    @NotNull
    private final ArbitraryFirstSortOrderTableView<MuiType> table;

    public ClassHistogramPanel(@NotNull MuiSnapshot<T, I> snapshot, @NotNull Project project, @NotNull MemoryViewTopLevelComponent topLevelComponent) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)topLevelComponent), (String)"topLevelComponent");
        this.snapshot = snapshot;
        this.project = project;
        this.topLevelComponent = topLevelComponent;
        this.hprofClassToStringConvertor = ClassHistogramPanel::hprofClassToStringConvertor$lambda$0;
        Function1 function1 = UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.class", new Object[0]);
        this.classColumn = new ColumnInfo<MuiType, MuiType>(this, (String)function1){
            final /* synthetic */ ClassHistogramPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public MuiType valueOf(MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item;
            }

            public Class<?> getColumnClass() {
                return MuiType.class;
            }

            public Comparator<MuiType> getComparator() {
                Convertor convertor = ClassHistogramPanel.access$getHprofClassToStringConvertor$p(this.this$0);
                return new Comparator(convertor){
                    final /* synthetic */ Convertor $receiver$inlined;
                    {
                        this.$receiver$inlined = convertor;
                    }

                    public final int compare(T a, T b) {
                        MuiType p0 = (MuiType)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)this.$receiver$inlined.convert((Object)p0)));
                        p0 = (MuiType)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)this.$receiver$inlined.convert((Object)p0)))));
                    }
                };
            }
        };
        function1 = UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.count", new Object[0]);
        this.instanceColumn = new ColumnInfo<MuiType, Percentage>(this, (String)function1){
            final /* synthetic */ ClassHistogramPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public Percentage valueOf(MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Double d = (double)item.getInstanceCount() / (double)this.this$0.getSnapshot().getTotalInstances();
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                Double d2 = !Double.isNaN(it) ? d : null;
                double value = d2 != null ? d2 : 0.0;
                return new Percentage(value, (Number)item.getInstanceCount());
            }

            public Class<?> getColumnClass() {
                return Percentage.class;
            }

            public Comparator<MuiType> getComparator() {
                return new Comparator(){

                    public final int compare(T a, T b) {
                        MuiType it = (MuiType)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getInstanceCount());
                        it = (MuiType)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInstanceCount()));
                    }
                };
            }

            public String getMaxStringValue() {
                return "999,999,999,999";
            }
        };
        function1 = UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.size", new Object[0]);
        this.shallowSizeColumn = new ColumnInfo<MuiType, Percentage>(this, (String)function1){
            final /* synthetic */ ClassHistogramPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public Percentage valueOf(MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Double d = (double)item.getTotalSize() / (double)this.this$0.getSnapshot().getTotalBytes();
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                Double d2 = !Double.isNaN(it) ? d : null;
                double value = d2 != null ? d2 : 0.0;
                return new Percentage(value, (Number)item.getTotalSize());
            }

            public Class<?> getColumnClass() {
                return Percentage.class;
            }

            public Comparator<MuiType> getComparator() {
                return new Comparator(){

                    public final int compare(T a, T b) {
                        MuiType it = (MuiType)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTotalSize());
                        it = (MuiType)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalSize()));
                    }
                };
            }

            public String getMaxStringValue() {
                return "999,999,999,999";
            }
        };
        function1 = UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.retained", new Object[0]);
        this.retainedSizeColumn = new ColumnInfo<MuiType, Percentage>(this, (String)function1){
            final /* synthetic */ ClassHistogramPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public Percentage valueOf(MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Long retainedSize = item.getRetainedSize();
                if (retainedSize == null) {
                    return null;
                }
                Double d = (double)retainedSize.longValue() / (double)this.this$0.getSnapshot().getTotalBytes();
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                Double d2 = !Double.isNaN(it) ? d : null;
                double value = d2 != null ? d2 : 0.0;
                return new Percentage(Math.min(value, 1.0), (Number)retainedSize);
            }

            public Class<?> getColumnClass() {
                return Percentage.class;
            }

            public Comparator<MuiType> getComparator() {
                return new Comparator(){

                    public final int compare(T a, T b) {
                        MuiType it = (MuiType)a;
                        boolean bl = false;
                        Long l = it.getRetainedSize();
                        it = (MuiType)b;
                        Comparable comparable = l != null ? (Comparable)l : (Comparable)Long.valueOf(0L);
                        bl = false;
                        Long l2 = it.getRetainedSize();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(l2 != null ? (Comparable)l2 : (Comparable)Long.valueOf(0L)));
                    }
                };
            }

            public String getMaxStringValue() {
                return "999,999,999,999";
            }
        };
        function1 = new Function1[]{this.classColumn, this.instanceColumn, this.shallowSizeColumn, this.retainedSizeColumn};
        this.columns = function1;
        function1 = arg_0 -> ClassHistogramPanel.table$lambda$1(this, arg_0);
        this.table = (ArbitraryFirstSortOrderTableView)new ArbitraryFirstSortOrderTableView<MuiType>(this, function1){
            private final TableRowsProportionRule proportionRule;
            {
                this.proportionRule = (TableRowsProportionRule)new TableRowsProportionRule.CustomFirst(0.15f);
                this.setModel((TableModel)new ListTableModel(ClassHistogramPanel.access$getColumns$p($receiver), MuiUtils.collectTypes($receiver.getSnapshot()), ArraysKt.indexOf((Object[])ClassHistogramPanel.access$getColumns$p($receiver), (Object)((Object)ClassHistogramPanel.access$getShallowSizeColumn$p($receiver))), SortOrder.DESCENDING));
            }

            public TableRowsProportionRule getProportionRule() {
                return this.proportionRule;
            }

            public int getRowHeight() {
                return com.intellij.profiler.ultimate.hprof.ui.ClassHistogramPanel$Companion.access$getROW_HEIGHT(ClassHistogramPanel.Companion);
            }
        };
        ProfilerUIUtilsKt.filteringTableViewSpeedSearch((TableView)((TableView)this.table), arg_0 -> ClassHistogramPanel._init_$lambda$2(this, arg_0));
        this.table.setMaxItemsForSizeCalculation(this.table.getColumnCount());
        this.table.getSelectionModel().setSelectionMode(0);
        HashSet<KeyStroke> forward = new HashSet<KeyStroke>(this.table.getFocusTraversalKeys(0));
        forward.add(KeyStroke.getKeyStroke("TAB"));
        this.table.setFocusTraversalKeys(0, (Set)forward);
        HashSet<KeyStroke> backward = new HashSet<KeyStroke>(this.table.getFocusTraversalKeys(1));
        backward.add(KeyStroke.getKeyStroke("shift TAB"));
        this.table.setFocusTraversalKeys(1, (Set)backward);
        this.table.setDefaultRenderer(MuiType.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table2, Object value, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                this.setBackground(selected ? UIUtil.getTableSelectionBackground((boolean)table2.hasFocus()) : table2.getBackground());
                if (value instanceof MuiType) {
                    String text;
                    int index;
                    String string = ((MuiType)value).getName();
                    if (string == null) {
                        string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.unknown.class", new Object[0]);
                    }
                    if ((index = StringUtil.lastIndexOf((CharSequence)(text = string), (char)'.', (int)0, (int)text.length())) > 0) {
                        String packageName = RenderUtilsKt.substring(text, 0, index + 1);
                        this.append(packageName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    String className = RenderUtilsKt.substring(text, index + 1, text.length());
                    this.append(className, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table2, (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)false, (boolean)selected);
                }
            }
        });
        this.table.setDefaultRenderer(Percentage.class, (TableCellRenderer)new CallUsageTableCellRenderer((ValueMetric)AllocationSizeMetric.INSTANCE, ClassHistogramPanel::_init_$lambda$3));
        AnAction[] anActionArray = new AnAction[1];
        String string = UltimateProfilerBundleKt.profilerMessage("hprof.action.open.new.tab", new Object[0]);
        anActionArray[0] = new DumbAwareAction(this, string){
            final /* synthetic */ ClassHistogramPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
                Shortcut[] shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null), new MouseShortcut(1, 0, 2)};
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)$receiver.getTable(), ClassHistogramPanel.access$getTopLevelComponent$p($receiver));
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = this.this$0.getTable().getSelectedRow();
                if (row >= 0) {
                    TableModel tableModel = this.this$0.getTable().getModel();
                    Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type com.intellij.util.ui.ListTableModel<*>");
                    Object object = ((ListTableModel)tableModel).getItem(this.this$0.getTable().convertRowIndexToModel(row));
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.intellij.profiler.ultimate.hprof.ui.ClassHistogramPanel");
                    MuiType item = (MuiType)object;
                    this.this$0.openObjectView(item);
                }
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.this$0.getTable().getSelectedRow() >= 0);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        final DefaultActionGroup popup2 = new DefaultActionGroup(anActionArray);
        this.table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                ActionManager.getInstance().createActionPopupMenu("ClassHistogramPanel", (ActionGroup)popup2).getComponent().show(comp, x, y);
            }
        });
        this.add(ScrollPaneFactory.createScrollPane((Component)((Component)this.table)));
    }

    @NotNull
    public final MuiSnapshot<T, I> getSnapshot() {
        return this.snapshot;
    }

    @NotNull
    public final ArbitraryFirstSortOrderTableView<MuiType> getTable() {
        return this.table;
    }

    public final void openObjectView(@NotNull T type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getShortName();
        if (string == null) {
            string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.unknown.class", new Object[0]);
        }
        ObjectViewPanel panel2 = new ObjectViewPanel(this.project, this.topLevelComponent, string, CollectionsKt.emptyList(), this.snapshot, null, 32, null);
        this.topLevelComponent.addTab(panel2);
        this.loadMore(panel2, type);
    }

    private final void loadMore(ObjectViewPanel<?, ?> panel2, T type) {
        ThreadingAssertions.assertEventDispatchThread();
        String string = panel2.getEmptyText().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String emptyText = string;
        panel2.getEmptyText().setText(UltimateProfilerBundleKt.profilerMessage("hprof.object.view.loading", new Object[0]));
        Project project = this.project;
        String string2 = UltimateProfilerBundleKt.profilerMessage("hprof.status.objects", new Object[0]);
        new Task.Backgroundable(this, panel2, type, emptyText, project, string2){
            final /* synthetic */ ClassHistogramPanel<T, I> this$0;
            final /* synthetic */ ObjectViewPanel<?, ?> $panel;
            final /* synthetic */ T $type;
            final /* synthetic */ String $emptyText;
            {
                this.this$0 = $receiver;
                this.$panel = $panel;
                this.$type = $type;
                this.$emptyText = $emptyText;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                int n;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                OnePercentProgressIndicator localIndicator = new OnePercentProgressIndicator(indicator, (arg_0, arg_1) -> loadMore.1.run$lambda$0(this.$panel, arg_0, arg_1));
                localIndicator.setIndeterminate(false);
                localIndicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.objects", new Object[0]));
                LongSet values = ClassHistogramPanel.access$collectViewObjectIds(this.this$0, this.$panel);
                if (this.$type.getId() == this.this$0.getSnapshot().getIdOfType(MuiTypes.CLASS)) {
                    T t = this.this$0.getSnapshot().getTypeById(this.$type.getId());
                    Intrinsics.checkNotNull(t);
                    n = t.getInstanceCount();
                } else {
                    n = 100000;
                }
                int limit = n;
                List result = ClassHistogramPanel.access$collectObjects(this.this$0, this.$type, limit, values, (ProgressIndicator)localIndicator);
                ApplicationManager.getApplication().invokeLater(() -> loadMore.1.run$lambda$2(this.$panel, this.$emptyText, result, this.$type, this.this$0));
            }

            private static final void run$lambda$0(ObjectViewPanel $panel, ProgressIndicator d, double d2) {
                if (Disposer.isDisposed((Disposable)$panel)) {
                    throw new ProcessCanceledException();
                }
                d.checkCanceled();
            }

            private static final Unit run$lambda$2$lambda$1(ClassHistogramPanel this$0, ObjectViewPanel $panel, MuiType $type) {
                ClassHistogramPanel.access$loadMore(this$0, $panel, $type);
                return Unit.INSTANCE;
            }

            private static final void run$lambda$2(ObjectViewPanel $panel, String $emptyText, List $result, MuiType $type, ClassHistogramPanel this$0) {
                $panel.getEmptyText().setText($emptyText);
                $panel.removeTrailingLink();
                $panel.addResults($result);
                if ($panel.count() < $type.getInstanceCount()) {
                    String string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.first.results", new Object[0]);
                    Object[] objectArray = new Object[]{$panel.count()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    $panel.addTrailingLink(string2, (Function0<Unit>)((Function0)() -> loadMore.1.run$lambda$2$lambda$1(this$0, $panel, $type)));
                }
            }
        }.queue();
    }

    private final List<Object> collectObjects(T type, int limit, LongSet values, ProgressIndicator localIndicator) {
        MuiVisitorWithComparator muiVisitorWithComparator;
        int n = type.getInstanceCount();
        Comparator<I> comparator2 = this.createComparator(type);
        MuiVisitorWithComparator $this$collectObjects_u24lambda_u244 = muiVisitorWithComparator = new MuiVisitorWithComparator<I>(limit, type, localIndicator, values, n, comparator2){
            private int counter;
            final /* synthetic */ int $limit;
            final /* synthetic */ T $type;
            final /* synthetic */ ProgressIndicator $localIndicator;
            final /* synthetic */ LongSet $values;
            {
                this.$limit = $limit;
                this.$type = $type;
                this.$localIndicator = $localIndicator;
                this.$values = $values;
                super($super_call_param$1, $limit, $super_call_param$2);
            }

            public final int getCounter() {
                return this.counter;
            }

            public final void setCounter(int n) {
                this.counter = n;
            }

            public boolean accept(I value) {
                double d;
                Intrinsics.checkNotNullParameter(value, (String)"value");
                if (this.$limit > 0 && this.getComparator() == null) {
                    var4_2 = this.counter;
                    this.counter = var4_2 + 1;
                    d = (double)var4_2 / (double)this.$limit;
                } else {
                    var4_2 = this.counter;
                    this.counter = var4_2 + 1;
                    d = (double)var4_2 / (double)this.$type.getInstanceCount();
                }
                double fraction = d;
                this.$localIndicator.setFraction(fraction);
                return super.accept((MuiElement)value);
            }

            public boolean isIgnored(I value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return this.$values.contains(value.getId());
            }
        };
        boolean bl = false;
        this.snapshot.forEachInstance(type, (MuiVisitor)$this$collectObjects_u24lambda_u244);
        return muiVisitorWithComparator.getResult();
    }

    private final LongSet collectViewObjectIds(ObjectViewPanel<?, ?> panel2) {
        LongOpenHashSet longOpenHashSet;
        LongOpenHashSet set = longOpenHashSet = new LongOpenHashSet(panel2.count());
        boolean bl = false;
        Iterator<Object> $this$forEach$iv = panel2.elements();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (!(it instanceof MuiInstance)) continue;
            set.add(((MuiInstance)it).getId());
        }
        return (LongSet)longOpenHashSet;
    }

    private final Comparator<I> createComparator(T type) {
        return !this.isSimpleInsertion(type) ? Collections.reverseOrder(Comparator.comparingLong(arg_0 -> ClassHistogramPanel.createComparator$lambda$8(ClassHistogramPanel::createComparator$lambda$7, arg_0)).thenComparingLong(arg_0 -> ClassHistogramPanel.createComparator$lambda$10(ClassHistogramPanel::createComparator$lambda$9, arg_0)).thenComparingInt(arg_0 -> ClassHistogramPanel.createComparator$lambda$12(ClassHistogramPanel::createComparator$lambda$11, arg_0))) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimpleInsertion(T type) {
        if (type.getId() == this.snapshot.getIdOfType(MuiTypes.CLASS)) return false;
        if (type.isArray()) return false;
        MuiSnapshot<MuiType, I> it = this.snapshot;
        boolean bl = false;
        Ref.BooleanRef result = new Ref.BooleanRef();
        result.element = true;
        it.forEachType(arg_0 -> ClassHistogramPanel.isSimpleInsertion$lambda$14$lambda$13(result, arg_0));
        if (!result.element) return false;
        return true;
    }

    @Override
    @NotNull
    public String getTabName() {
        return UltimateProfilerBundleKt.profilerMessage("hprof.tab.classes", new Object[0]);
    }

    @Override
    @NotNull
    public JComponent createRightComponent() {
        LazyPanel it;
        LazyPanel lazyPanel2;
        JBRunnerClosableTabs tabs = new JBRunnerClosableTabs(this.project, (Disposable)this.topLevelComponent);
        boolean autoload = this.snapshot.isAutoload();
        ClassHistogramPanel it2 = this;
        boolean bl = false;
        LazyPanel lazyPanel3 = lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.dominators.view", new Object[0]), false, autoload, false, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$20$lambda$18(this, arg_0), 20, null);
        JBRunnerClosableTabs jBRunnerClosableTabs = tabs;
        boolean bl2 = false;
        Disposer.register((Disposable)this.topLevelComponent, (Disposable)((Disposable)it));
        JComponent jComponent = (JComponent)lazyPanel2;
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.biggest.objects", new Object[0])));
        it2 = this;
        boolean bl3 = false;
        it = lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.roots.view", new Object[0]), false, true, false, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$30$lambda$28(this, arg_0), 16, null);
        jBRunnerClosableTabs = tabs;
        boolean bl4 = false;
        Disposer.register((Disposable)this.topLevelComponent, (Disposable)((Disposable)it));
        JComponent jComponent2 = (JComponent)lazyPanel2;
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent2).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.roots", new Object[0])));
        it2 = this;
        boolean bl5 = false;
        LazyPanel lazyPanel4 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.merged.paths", new Object[0]), false, autoload, false, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$34$lambda$32(this, arg_0), 20, null);
        Disposer.register((Disposable)this.topLevelComponent, (Disposable)((Disposable)lazyPanel4));
        lazyPanel4.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(arg_0 -> ClassHistogramPanel.createRightComponent$lambda$34$lambda$33(lazyPanel4, this, arg_0));
        tabs.addTab(new TabInfo((JComponent)lazyPanel4).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.merged.paths", new Object[0])));
        tabs.addTab(new TabInfo((JComponent)((Object)new SummarySnapshotPanel<T, I>(this.snapshot, this.project, this.topLevelComponent))).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary", new Object[0])));
        it2 = this;
        boolean bl6 = false;
        SunburstPanel<T, I> panel2 = SunburstPanel.Companion.withModel(this.project, ClassHistogramPanel::createRightComponent$lambda$47$lambda$46);
        tabs.addTab(new TabInfo((JComponent)((Object)panel2)).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.packages", new Object[0])));
        panel2.updateDiagram(this.snapshot);
        if (Registry.Companion.is("idea.profiler.hprof.show.duplicated.strings")) {
            it2 = this;
            boolean bl7 = false;
            lazyPanel4 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.duplicated.strings", new Object[0]), false, false, false, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$53$lambda$52(this, arg_0), 20, null);
            Disposer.register((Disposable)this.topLevelComponent, (Disposable)((Disposable)lazyPanel4));
            tabs.addTab(new TabInfo((JComponent)lazyPanel4).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.duplicated.strings", new Object[0])));
        }
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        return (JComponent)tabs;
    }

    @Override
    @NotNull
    public JComponent createCenterComponent() {
        return (JComponent)((Object)this);
    }

    private static final String hprofClassToStringConvertor$lambda$0(MuiType it) {
        String string = it.getName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final boolean table$lambda$1(ClassHistogramPanel this$0, Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((Object)((Object)this$0.classColumn)).getClass().isAssignableFrom(it);
    }

    private static final String _init_$lambda$2(ClassHistogramPanel this$0, MuiType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)this$0.hprofClassToStringConvertor.convert((Object)it);
    }

    private static final String _init_$lambda$3() {
        return UltimateProfilerBundleKt.profilerMessage("hprof.object.view.na", new Object[0]);
    }

    private static final long createComparator$lambda$7(MuiInstance it) {
        Long l = it.getRetainedSize();
        return l != null ? l : 0L;
    }

    private static final long createComparator$lambda$8(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final long createComparator$lambda$9(MuiInstance it) {
        return it.getInstanceSize();
    }

    private static final long createComparator$lambda$10(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final int createComparator$lambda$11(MuiInstance it) {
        MuiInstance muiInstance = it;
        return muiInstance instanceof MuiRecord ? ((MuiRecord)it).getFieldCount() : (muiInstance instanceof MuiArray ? ((MuiArray)it).getValueCount() : 0);
    }

    private static final int createComparator$lambda$12(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final boolean isSimpleInsertion$lambda$14$lambda$13(Ref.BooleanRef $result, MuiType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $result.element = $result.element && value.getRetainedSize() == null;
        return $result.element;
    }

    private static final void createRightComponent$lambda$20$lambda$18$lambda$15(ClassHistogramPanel this$0) {
        this$0.repaint();
    }

    private static final long createRightComponent$lambda$20$lambda$18$lambda$16(MuiInstance it) {
        Long l = it.getRetainedSize();
        return l != null ? l : 0L;
    }

    private static final long createRightComponent$lambda$20$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final ObjectViewPanel createRightComponent$lambda$20$lambda$18(ClassHistogramPanel this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this$0.snapshot.doCalculateRetainedSize(indicator);
        ApplicationManager.getApplication().invokeLater(() -> ClassHistogramPanel.createRightComponent$lambda$20$lambda$18$lambda$15(this$0));
        indicator.setIndeterminate(false);
        indicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.dominators", new Object[0]));
        indicator.setFraction(0.0);
        int limit = 1000;
        MuiVisitorWithComparator<Object> visitor2 = new MuiVisitorWithComparator<Object>(limit, limit, Comparator.comparingLong(arg_0 -> ClassHistogramPanel.createRightComponent$lambda$20$lambda$18$lambda$17(ClassHistogramPanel::createRightComponent$lambda$20$lambda$18$lambda$16, arg_0)).reversed());
        this$0.snapshot.getDominators(indicator, (MuiVisitor)visitor2);
        List<Object> collection = visitor2.getResult();
        if (collection.size() == limit) {
            Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.ultimate.hprof.api.MuiElement>");
            List list = TypeIntrinsics.asMutableList(collection);
            String string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.first.results", new Object[0]);
            Object[] objectArray = new Object[]{limit};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            list.add(new MuiStub(string2));
        }
        return new ObjectViewPanel(this$0.project, this$0.topLevelComponent, "", collection, this$0.snapshot, null, 32, null);
    }

    private static final List createRightComponent$lambda$30$lambda$28$lambda$21(MuiType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List createRightComponent$lambda$30$lambda$28$lambda$22(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean createRightComponent$lambda$30$lambda$28$lambda$25(MuiType aClass) {
        return aClass != null;
    }

    private static final boolean createRightComponent$lambda$30$lambda$28$lambda$26(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List createRightComponent$lambda$30$lambda$28$lambda$27(Map $objects, MuiType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = $objects.get(it);
        Intrinsics.checkNotNull(v);
        return (List)v;
    }

    private static final ObjectViewPanel createRightComponent$lambda$30$lambda$28(ClassHistogramPanel this$0, ProgressIndicator it) {
        Object root2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List roots = new ArrayList();
        this$0.snapshot.getRootInstances(new CollectMuiVisitor(roots));
        Map objects = new HashMap();
        Iterable iterable = roots;
        Comparator<MuiElement> comparator2 = MuiComparators.comparingElements().reversed();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"reversed(...)");
        CollectionsKt.sortedWith((Iterable)iterable, comparator2);
        for (Object root2 : roots) {
            MuiType t;
            if (root2.getId() < 0L) continue;
            Intrinsics.checkNotNull((Object)root2.getType(), (String)"null cannot be cast to non-null type T of com.intellij.profiler.ultimate.hprof.ui.ClassHistogramPanel");
            objects.computeIfAbsent(t, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$30$lambda$28$lambda$22(ClassHistogramPanel::createRightComponent$lambda$30$lambda$28$lambda$21, arg_0)).add(root2);
        }
        root2 = new Comparator(objects){
            final /* synthetic */ Map $objects$inlined;
            {
                this.$objects$inlined = map;
            }

            public final int compare(T a, T b) {
                MuiType it = (MuiType)a;
                boolean bl = false;
                V v = this.$objects$inlined.get(it);
                Intrinsics.checkNotNull(v);
                Function1 function1 = createRightComponent.2.1.comparator.1.1.INSTANCE;
                it = (MuiType)b;
                Comparable comparable = Long.valueOf(((List)v).stream().mapToLong(new ToLongFunction(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ long applyAsLong(Object p0) {
                        return ((Number)this.function.invoke(p0)).longValue();
                    }
                }).sum());
                bl = false;
                V v2 = this.$objects$inlined.get(it);
                Intrinsics.checkNotNull(v2);
                function1 = createRightComponent.2.1.comparator.1.1.INSTANCE;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(((List)v2).stream().mapToLong(new /* invalid duplicate definition of identical inner class */).sum()));
            }
        };
        Comparator comparator3 = ((Comparator)new Comparator((Comparator)root2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    MuiType it = (MuiType)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getInstanceSize());
                    it = (MuiType)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getInstanceSize()));
                }
                return n;
            }
        }).reversed();
        List list = ContainerUtil.sorted((Collection)ContainerUtil.filter((Collection)objects.keySet(), arg_0 -> ClassHistogramPanel.createRightComponent$lambda$30$lambda$28$lambda$26(ClassHistogramPanel::createRightComponent$lambda$30$lambda$28$lambda$25, arg_0)), comparator3);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sorted(...)");
        List classes = list;
        return new ObjectViewPanel(this$0.project, this$0.topLevelComponent, "", classes, this$0.snapshot, (Function1<? super MuiType, ? extends List<? extends MuiInstance>>)((Function1)arg_0 -> ClassHistogramPanel.createRightComponent$lambda$30$lambda$28$lambda$27(objects, arg_0)));
    }

    private static final boolean createRightComponent$lambda$34$lambda$32$lambda$31(ProgressIndicator $indicator, LongArrayList $list, MuiInstance value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if ($indicator.isCanceled()) {
            throw new ProcessCanceledException();
        }
        $list.add(value.getId());
        return true;
    }

    private static final MergedPathPanel createRightComponent$lambda$34$lambda$32(ClassHistogramPanel this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object object = this$0.table.getSelectedObject();
        Intrinsics.checkNotNull((Object)object);
        MuiType type = (MuiType)object;
        LongArrayList list = new LongArrayList(type.getInstanceCount());
        this$0.snapshot.forEachInstance(type, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$34$lambda$32$lambda$31(indicator, list, arg_0));
        return new MergedPathPanel(this$0.snapshot, type, (LongList)list);
    }

    private static final void createRightComponent$lambda$34$lambda$33(LazyPanel $lazyPanel, ClassHistogramPanel this$0, ListSelectionEvent it) {
        if (!it.getValueIsAdjusting()) {
            $lazyPanel.setEnabled(this$0.table.getSelectedObject() != null);
            $lazyPanel.clear();
            if ($lazyPanel.isAutoloadEnable()) {
                $lazyPanel.loadLater(false);
            }
        }
    }

    private static final String createRightComponent$lambda$47$lambda$46$parent(String $this$createRightComponent_u24lambda_u2447_u24lambda_u2446_u24parent, String rootDisplayName, String delimiter) {
        if (Intrinsics.areEqual((Object)$this$createRightComponent_u24lambda_u2447_u24lambda_u2446_u24parent, (Object)rootDisplayName)) {
            return null;
        }
        int indexOf = StringsKt.lastIndexOf$default((CharSequence)$this$createRightComponent_u24lambda_u2447_u24lambda_u2446_u24parent, (String)delimiter, (int)0, (boolean)false, (int)6, null);
        if (indexOf < 0) {
            return rootDisplayName;
        }
        return RenderUtilsKt.substring($this$createRightComponent_u24lambda_u2447_u24lambda_u2446_u24parent, 0, indexOf);
    }

    static /* synthetic */ String createRightComponent$lambda$47$lambda$46$parent$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = ".";
        }
        return ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$parent(string, string2, string3);
    }

    private static final Color createRightComponent$lambda$47$lambda$46$lambda$35() {
        Color color = UIUtil.getEditorPaneBackground();
        if (color == null) {
            color = UIUtil.getPanelBackground();
        }
        return color;
    }

    private static final SunburstPanelElement createRightComponent$lambda$47$lambda$46$lambda$43$lambda$36(String $displayName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SunburstPanelElement($displayName, SunburstPanel.Companion.getColor($displayName));
    }

    private static final SunburstPanelElement createRightComponent$lambda$47$lambda$46$lambda$43$lambda$37(Function1 $tmp0, Object p0) {
        return (SunburstPanelElement)$tmp0.invoke(p0);
    }

    private static final String createRightComponent$lambda$47$lambda$46$lambda$43$lambda$38(String $rootDisplayName, String p) {
        Intrinsics.checkNotNull((Object)p);
        return ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$parent$default(p, $rootDisplayName, null, 2, null);
    }

    private static final String createRightComponent$lambda$47$lambda$46$lambda$43$lambda$39(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final SunburstPanelElement createRightComponent$lambda$47$lambda$46$lambda$43$lambda$42$lambda$40(String $displayName, String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SunburstPanelElement(name, SunburstPanel.Companion.getColor($displayName));
    }

    private static final SunburstPanelElement createRightComponent$lambda$47$lambda$46$lambda$43$lambda$42$lambda$41(Function1 $tmp0, Object p0) {
        return (SunburstPanelElement)$tmp0.invoke(p0);
    }

    private static final boolean createRightComponent$lambda$47$lambda$46$lambda$43(Ref.LongRef $totalSizeCheck, Map $elements, String $rootDisplayName, MuiType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        if (string == null) {
            string = "unknown";
        }
        String displayName = string;
        long totalSize = it.getTotalSize();
        $totalSizeCheck.element += totalSize;
        $elements.computeIfAbsent(displayName, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$lambda$43$lambda$37(arg_0 -> ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$lambda$43$lambda$36(displayName, arg_0), arg_0));
        JBIterable jBIterable = JBIterable.generate((Object)displayName, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$lambda$43$lambda$39(arg_0 -> ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$lambda$43$lambda$38($rootDisplayName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"generate(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SunburstPanelElement element;
            String parent = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$elements.computeIfAbsent(parent, arg_0 -> ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$lambda$43$lambda$42$lambda$41(arg_0 -> ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$lambda$43$lambda$42$lambda$40(displayName, arg_0), arg_0)), (String)"computeIfAbsent(...)");
            element.setSize(element.getSize() + totalSize);
        }
        return true;
    }

    private static final SunburstPanelModel createRightComponent$lambda$47$lambda$46(MuiSnapshot dump) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        String rootDisplayName = "All";
        JBColor jBColor = JBColor.lazy(ClassHistogramPanel::createRightComponent$lambda$47$lambda$46$lambda$35);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        SunburstPanelElement root = new SunburstPanelElement(rootDisplayName, (Color)jBColor);
        Map elements2 = new LinkedHashMap();
        elements2.put(rootDisplayName, root);
        Ref.LongRef totalSizeCheck = new Ref.LongRef();
        dump.forEachType(arg_0 -> ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$lambda$43(totalSizeCheck, elements2, rootDisplayName, arg_0));
        Comparator comparator2 = ((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SunburstPanelElement p0 = (SunburstPanelElement)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getSize());
                p0 = (SunburstPanelElement)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getSize()));
            }
        }).reversed();
        Iterable $this$forEach$iv = elements2.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int result;
            SunburstPanelElement parent;
            SunburstPanelElement element = (SunburstPanelElement)element$iv;
            boolean bl2 = false;
            String string = ClassHistogramPanel.createRightComponent$lambda$47$lambda$46$parent$default(element.getDisplayName(), rootDisplayName, null, 2, null);
            if (string == null) continue;
            if ((SunburstPanelElement)elements2.get(string) == null) {
                throw new IllegalStateException(("cannot find parent for " + element.getDisplayName()).toString());
            }
            element.setParent(parent);
            if (parent.getDisplayName().length() < element.getDisplayName().length() && StringsKt.startsWith$default((String)element.getDisplayName(), (String)parent.getDisplayName(), (boolean)false, (int)2, null)) {
                String string2 = element.getDisplayName().substring(parent.getDisplayName().length() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                element.setShortName(string2);
            }
            if ((result = Collections.binarySearch(parent.getChildren(), element, comparator2)) < 0) {
                result = -result - 1;
            }
            parent.getChildren().add(result, element);
        }
        boolean bl3 = bl = totalSizeCheck.element == root.getSize();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Bad size: " + root.getSize() + " != " + totalSizeCheck.element + " (expected)";
            throw new AssertionError((Object)string);
        }
        return new SunburstPanelModel(root);
    }

    private static final void createRightComponent$lambda$53$lambda$52$lambda$48(ClassHistogramPanel this$0) {
        this$0.repaint();
    }

    private static final JPanel createRightComponent$lambda$53$lambda$52(ClassHistogramPanel this$0, ProgressIndicator indicator) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ApplicationManager.getApplication().invokeLater(() -> ClassHistogramPanel.createRightComponent$lambda$53$lambda$52$lambda$48(this$0));
        indicator.setIndeterminate(false);
        indicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.compute.duplicated.strings", new Object[0]));
        indicator.setFraction(0.0);
        Iterable $this$sortedByDescending$iv = StringDuplicatesAnalyzer.calculateDuplicatedStrings$default(StringDuplicatesAnalyzer.INSTANCE, this$0.snapshot, indicator, 0L, 4, null);
        boolean $i$f$sortedByDescending = false;
        List duplicatedStrings = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                StringDuplicatesAnalyzer.DuplicatedString it = (StringDuplicatesAnalyzer.DuplicatedString)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getWastedBytes());
                it = (StringDuplicatesAnalyzer.DuplicatedString)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getWastedBytes()));
            }
        });
        JPanel $this$createRightComponent_u24lambda_u2453_u24lambda_u2452_u24lambda_u2451 = jPanel = new JPanel();
        boolean bl = false;
        $this$createRightComponent_u24lambda_u2453_u24lambda_u2452_u24lambda_u2451.setLayout(new BoxLayout($this$createRightComponent_u24lambda_u2453_u24lambda_u2452_u24lambda_u2451, 1));
        ColumnInfo[] columnInfoArray = new ColumnInfo[3];
        String string = UltimateProfilerBundleKt.profilerMessage("hprof.duplicates.column.value", new Object[0]);
        columnInfoArray[0] = new ColumnInfo<StringDuplicatesAnalyzer.DuplicatedString, String>(string){

            public String valueOf(StringDuplicatesAnalyzer.DuplicatedString item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getValue();
            }
        };
        string = UltimateProfilerBundleKt.profilerMessage("hprof.duplicates.column.instances.count", new Object[0]);
        columnInfoArray[1] = new ColumnInfo<StringDuplicatesAnalyzer.DuplicatedString, Long>(string){

            public Long valueOf(StringDuplicatesAnalyzer.DuplicatedString item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getDuplicatesCount();
            }

            public Comparator<StringDuplicatesAnalyzer.DuplicatedString> getComparator() {
                return new Comparator(){

                    public final int compare(T a, T b) {
                        StringDuplicatesAnalyzer.DuplicatedString it = (StringDuplicatesAnalyzer.DuplicatedString)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getDuplicatesCount());
                        it = (StringDuplicatesAnalyzer.DuplicatedString)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getDuplicatesCount()));
                    }
                };
            }
        };
        string = UltimateProfilerBundleKt.profilerMessage("hprof.duplicates.column.waste", new Object[0]);
        columnInfoArray[2] = new ColumnInfo<StringDuplicatesAnalyzer.DuplicatedString, Long>(string){

            public Long valueOf(StringDuplicatesAnalyzer.DuplicatedString item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getWastedBytes();
            }

            public Comparator<StringDuplicatesAnalyzer.DuplicatedString> getComparator() {
                return new Comparator(){

                    public final int compare(T a, T b) {
                        StringDuplicatesAnalyzer.DuplicatedString it = (StringDuplicatesAnalyzer.DuplicatedString)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getWastedBytes());
                        it = (StringDuplicatesAnalyzer.DuplicatedString)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getWastedBytes()));
                    }
                };
            }
        };
        ListTableModel model2 = new ListTableModel(columnInfoArray, duplicatedStrings);
        String $this$createRightComponent_u24lambda_u2453_u24lambda_u2452_u24lambda_u2451_u24lambda_u2450 = string = new JBTable((TableModel)model2);
        boolean bl2 = false;
        $this$createRightComponent_u24lambda_u2453_u24lambda_u2452_u24lambda_u2451_u24lambda_u2450.setRowHeight(ClassHistogramPanel.Companion.getROW_HEIGHT());
        UiUtils.setEmptyState((Component)((Component)((Object)$this$createRightComponent_u24lambda_u2453_u24lambda_u2452_u24lambda_u2451_u24lambda_u2450)), (String)UltimateProfilerBundleKt.profilerMessage("hprof.duplicates.empty", new Object[0]));
        String table2 = string;
        $this$createRightComponent_u24lambda_u2453_u24lambda_u2452_u24lambda_u2451.add((Component)new JBScrollPane((Component)((Object)table2)));
        return jPanel;
    }

    public static final /* synthetic */ LongSet access$collectViewObjectIds(ClassHistogramPanel $this, ObjectViewPanel panel2) {
        return $this.collectViewObjectIds(panel2);
    }

    public static final /* synthetic */ List access$collectObjects(ClassHistogramPanel $this, MuiType type, int limit, LongSet values, ProgressIndicator localIndicator) {
        return $this.collectObjects(type, limit, values, localIndicator);
    }

    public static final /* synthetic */ void access$loadMore(ClassHistogramPanel $this, ObjectViewPanel panel2, MuiType type) {
        $this.loadMore(panel2, type);
    }

    public static final /* synthetic */ Convertor access$getHprofClassToStringConvertor$p(ClassHistogramPanel $this) {
        return $this.hprofClassToStringConvertor;
    }

    public static final /* synthetic */ ColumnInfo[] access$getColumns$p(ClassHistogramPanel $this) {
        return $this.columns;
    }

    public static final /* synthetic */ shallowSizeColumn.1 access$getShallowSizeColumn$p(ClassHistogramPanel $this) {
        return $this.shallowSizeColumn;
    }

    public static final /* synthetic */ MemoryViewTopLevelComponent access$getTopLevelComponent$p(ClassHistogramPanel $this) {
        return $this.topLevelComponent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$Companion;", "", "<init>", "()V", "ROW_HEIGHT", "", "getROW_HEIGHT", "()I", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        private final int getROW_HEIGHT() {
            return JBUIScale.scale((int)24);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

