/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.dnd;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.editor.handlers.DataframeVariableNameSuggester;
import com.intellij.jupyter.core.editor.handlers.LanguageTableDataFileDropHandler;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.kotlin.jupyter.core.editor.dnd.KotlinDataframeVariableNameSuggester;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerPerFileService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0018\u001a\u00020\u0011*\u00020\u000fH\u0002J\f\u0010\u0019\u001a\u00020\u0011*\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/dnd/AbstractKotlinDataframeDropHandler;", "Lcom/intellij/jupyter/core/editor/handlers/LanguageTableDataFileDropHandler;", "commandName", "", "fileExtensions", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "nameSuggester", "Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "getNameSuggester", "()Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "generateImportExpression", "dataFilePath", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "isTargetLibrary", "", "file", "Ljava/io/File;", "getUseStatement", "getCellResultStatement", "variableName", "generateCellCode", "shouldGenerateUseStatement", "shouldAlwaysGenerateUseStatement", "Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;", "isDataFrameInClasspath", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "generateCode", "importExpression", "dfName", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinDataframeDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinDataframeDropHandler.kt\ncom/intellij/kotlin/jupyter/core/editor/dnd/AbstractKotlinDataframeDropHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1761#2,3:93\n1#3:96\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinDataframeDropHandler.kt\ncom/intellij/kotlin/jupyter/core/editor/dnd/AbstractKotlinDataframeDropHandler\n*L\n74#1:93,3\n*E\n"})
public abstract class AbstractKotlinDataframeDropHandler
extends LanguageTableDataFileDropHandler {
    public AbstractKotlinDataframeDropHandler(@Nls @NotNull String commandName, @NotNull Set<String> fileExtensions) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        Intrinsics.checkNotNullParameter(fileExtensions, (String)"fileExtensions");
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
        super((Language)kotlinLanguage, commandName, fileExtensions);
    }

    @NotNull
    public DataframeVariableNameSuggester getNameSuggester() {
        return KotlinDataframeVariableNameSuggester.INSTANCE;
    }

    @NotNull
    protected abstract String generateImportExpression(@NotNull String var1, @NotNull TableDataFileDropHandlerContext var2);

    protected boolean isTargetLibrary(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"dataframe-core", (boolean)false, (int)2, null);
    }

    @NotNull
    protected String getUseStatement() {
        return "%use dataframe\n";
    }

    @NotNull
    protected String getCellResultStatement(@NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        return variableName;
    }

    @NotNull
    public String generateCellCode(@NotNull TableDataFileDropHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String dataFilePath = context.resolveFilePath();
        String string = context.getDataframeName();
        if (string == null) {
            string = this.getNameSuggester().createDataframeName(context.getProjectOrNull(), context.getDataFileNameWithoutExtension());
        }
        String dfName = string;
        String importExpression = this.generateImportExpression(dataFilePath, context);
        return this.generateCode(importExpression, dfName, this.shouldGenerateUseStatement(context));
    }

    private final boolean shouldGenerateUseStatement(TableDataFileDropHandlerContext $this$shouldGenerateUseStatement) {
        boolean bl;
        if (this.shouldAlwaysGenerateUseStatement($this$shouldGenerateUseStatement.getGenerationContext())) {
            return true;
        }
        if ($this$shouldGenerateUseStatement.getFileIndex() != 0) {
            return false;
        }
        TableDataFileDropHandlerContext.PathData pathData = $this$shouldGenerateUseStatement.getPathData();
        if (pathData instanceof TableDataFileDropHandlerContext.PathData.FileBased) {
            bl = !this.isDataFrameInClasspath(((TableDataFileDropHandlerContext.PathData.FileBased)pathData).getNotebookFile(), ((TableDataFileDropHandlerContext.PathData.FileBased)pathData).getProject());
        } else if (pathData instanceof TableDataFileDropHandlerContext.PathData.Lightweight) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean shouldAlwaysGenerateUseStatement(DataInputCodeGenerationContext $this$shouldAlwaysGenerateUseStatement) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$shouldAlwaysGenerateUseStatement.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> false;
            case 4 -> true;
            case 5 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isDataFrameInClasspath(BackedNotebookVirtualFile notebookFile, Project project) {
        boolean bl;
        block3: {
            JupyterCompilerPerFileService compilerService = JupyterCompilerService.Companion.getForFile(project, notebookFile);
            Iterable $this$any$iv = compilerService.getCurrentClasspath();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File file = (File)element$iv;
                    boolean bl2 = false;
                    if (!this.isTargetLibrary(file)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String generateCode(String importExpression, String dfName, boolean shouldGenerateUseStatement) {
        String string;
        Object[] objectArray = new String[2];
        String string2 = string = this.getUseStatement();
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = shouldGenerateUseStatement;
        objectArray2[n] = bl2 ? string : null;
        objectArray[1] = StringsKt.trimIndent((String)("\n            val " + dfName + " = " + importExpression + "\n            " + this.getCellResultStatement(dfName) + "\n            "));
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataInputCodeGenerationContext.values().length];
            try {
                nArray[DataInputCodeGenerationContext.ON_DROP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataInputCodeGenerationContext.FOR_EXECUTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataInputCodeGenerationContext.AFTER_LOADING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataInputCodeGenerationContext.BEFORE_SAVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataInputCodeGenerationContext.FOR_CONVERSION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

