/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.ui.AcceptUserDialogService;
import com.intellij.cwm.plugin.common.ui.CWMBaseAcceptUserDialog;
import com.intellij.cwm.plugin.common.ui.UserInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remoteDev.tests.DistributedTestApiKt;
import com.intellij.ui.AppIcon;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bJ$\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bH\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/cwm/plugin/common/ui/AccessNotification;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "currentlyVisibleDialogs", "Ljava/util/HashMap;", "Lcom/intellij/codeWithMe/ClientId;", "Lcom/intellij/cwm/plugin/common/ui/CWMBaseAcceptUserDialog;", "Lkotlin/collections/HashMap;", "showNewAccessNotification", "Ljava/util/concurrent/CompletableFuture;", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "userName", "", "clientId", "fingerprint", "connectionLifetime", "userInfo", "Lcom/intellij/cwm/plugin/common/ui/UserInfo;", "dialogFactory", "Lkotlin/Function0;", "getCurrentlyVisibleDialogs", "getDialogOrNull", "addDialog", "", "dialog", "removeDialog", "intellij.cwm.plugin.common"})
public final class AccessNotification {
    @NotNull
    public static final AccessNotification INSTANCE = new AccessNotification();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final HashMap<ClientId, CWMBaseAcceptUserDialog> currentlyVisibleDialogs;

    private AccessNotification() {
    }

    @NotNull
    public final CompletableFuture<Boolean> showNewAccessNotification(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull String userName, @NotNull ClientId clientId, @NotNull String fingerprint, @Nullable Lifetime connectionLifetime, @Nullable UserInfo userInfo, @NotNull Function0<? extends CWMBaseAcceptUserDialog> dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter(dialogFactory, (String)"dialogFactory");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ApplicationKt.getApplication().invokeLater(() -> AccessNotification.showNewAccessNotification$lambda$6(clientId, dialogFactory, fingerprint, userInfo, connectionLifetime, userName, future, project, lifetime));
        return future;
    }

    public static /* synthetic */ CompletableFuture showNewAccessNotification$default(AccessNotification accessNotification, Project project, Lifetime lifetime, String string, ClientId clientId, String string2, Lifetime lifetime2, UserInfo userInfo, Function0 function0, int n, Object object) {
        if ((n & 0x80) != 0) {
            function0 = () -> AccessNotification.showNewAccessNotification$lambda$1(project, string, clientId);
        }
        return accessNotification.showNewAccessNotification(project, lifetime, string, clientId, string2, lifetime2, userInfo, (Function0<? extends CWMBaseAcceptUserDialog>)function0);
    }

    @TestOnly
    @NotNull
    public final HashMap<ClientId, CWMBaseAcceptUserDialog> getCurrentlyVisibleDialogs() {
        return currentlyVisibleDialogs;
    }

    private final CWMBaseAcceptUserDialog getDialogOrNull(ClientId clientId) {
        return currentlyVisibleDialogs.get(clientId);
    }

    private final void addDialog(ClientId clientId, CWMBaseAcceptUserDialog dialog2) {
        CWMBaseAcceptUserDialog existingDialog = this.getDialogOrNull(clientId);
        if (existingDialog != null) {
            this.removeDialog(clientId);
        }
        ((Map)currentlyVisibleDialogs).put(clientId, dialog2);
    }

    private final void removeDialog(ClientId clientId) {
        LOG.info("Remove Access dialog for client (id: " + clientId + ") if visible");
        CWMBaseAcceptUserDialog existingDialog = currentlyVisibleDialogs.get(clientId);
        if (existingDialog != null && existingDialog.isShowing()) {
            ApplicationManager.getApplication().invokeLater(() -> AccessNotification.removeDialog$lambda$7(existingDialog));
        }
        currentlyVisibleDialogs.remove(clientId);
    }

    private static final CWMBaseAcceptUserDialog showNewAccessNotification$lambda$1$lambda$0(Project $project, String $userName, ClientId $clientId) {
        return AcceptUserDialogService.Companion.getInstance().createAcceptUserDialog($project, $userName, $clientId);
    }

    private static final CWMBaseAcceptUserDialog showNewAccessNotification$lambda$1(Project $project, String $userName, ClientId $clientId) {
        return (CWMBaseAcceptUserDialog)((Object)ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> AccessNotification.showNewAccessNotification$lambda$1$lambda$0($project, $userName, $clientId)));
    }

    private static final Unit showNewAccessNotification$lambda$6$lambda$2(ClientId $clientId, CompletableFuture $future) {
        LOG.info("Transport lifetime has been terminated");
        INSTANCE.removeDialog($clientId);
        $future.complete(false);
        return Unit.INSTANCE;
    }

    private static final Unit showNewAccessNotification$lambda$6$lambda$3(ClientId $clientId, CompletableFuture $future, Boolean r, Throwable ex) {
        INSTANCE.removeDialog($clientId);
        boolean bl = ex != null ? $future.completeExceptionally(ex) : $future.complete(r);
        return Unit.INSTANCE;
    }

    private static final void showNewAccessNotification$lambda$6$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit showNewAccessNotification$lambda$6$lambda$5(CWMBaseAcceptUserDialog $dialog, CompletableFuture $future, ClientId $clientId) {
        if ($dialog.isShowing()) {
            $future.complete(false);
            INSTANCE.removeDialog($clientId);
        }
        return Unit.INSTANCE;
    }

    private static final void showNewAccessNotification$lambda$6(ClientId $clientId, Function0 $dialogFactory, String $fingerprint, UserInfo $userInfo, Lifetime $connectionLifetime, String $userName, CompletableFuture $future, Project $project, Lifetime $lifetime) {
        CWMBaseAcceptUserDialog existingDialog = INSTANCE.getDialogOrNull($clientId);
        if (existingDialog != null) {
            INSTANCE.removeDialog($clientId);
        }
        CWMBaseAcceptUserDialog dialog2 = (CWMBaseAcceptUserDialog)((Object)$dialogFactory.invoke());
        dialog2.setFingerprintString($fingerprint);
        dialog2.consumeUserInfos(null, $userInfo);
        Lifetime lifetime = $connectionLifetime;
        if (lifetime != null) {
            lifetime.onTermination(() -> AccessNotification.showNewAccessNotification$lambda$6$lambda$2($clientId, $future));
        }
        if (DistributedTestApiKt.isDistributedTestMode((Application)ApplicationKt.getApplication())) {
            if (Intrinsics.areEqual((Object)ClientId.Companion.getDefaultLocalId(), (Object)ClientId.Companion.getLocalId())) {
                LOG.warn("Host was launched as a part of a distributed test, automatically providing access to userName=" + $userName + ".");
                $future.complete(true);
                return;
            }
            dialog2.setModal(false);
        }
        INSTANCE.addDialog($clientId, dialog2);
        AppIcon.getInstance().requestAttention($project, true);
        dialog2.show();
        dialog2.getResult().whenComplete((arg_0, arg_1) -> AccessNotification.showNewAccessNotification$lambda$6$lambda$4((arg_0, arg_1) -> AccessNotification.showNewAccessNotification$lambda$6$lambda$3($clientId, $future, arg_0, arg_1), arg_0, arg_1));
        $lifetime.onTermination(() -> AccessNotification.showNewAccessNotification$lambda$6$lambda$5(dialog2, $future, $clientId));
    }

    private static final void removeDialog$lambda$7(CWMBaseAcceptUserDialog $existingDialog) {
        $existingDialog.close(1);
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        currentlyVisibleDialogs = new HashMap();
    }
}

