/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/util/text/LineTokenizer;", "", "myText", "", "<init>", "(Ljava/lang/CharSequence;)V", "text", "", "startOffset", "", "endOffset", "([CII)V", "value", "offset", "getOffset", "()I", "length", "getLength", "lineSeparatorLength", "getLineSeparatorLength", "atEnd", "", "advance", "", "Companion", "intellij.platform.util.base.multiplatform"})
public final class LineTokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence myText;
    private int offset;
    private int length;
    private int lineSeparatorLength;
    private boolean atEnd;
    @NotNull
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public LineTokenizer(@NotNull CharSequence myText) {
        Intrinsics.checkNotNullParameter(myText, "myText");
        this.myText = myText;
        this.advance();
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getLineSeparatorLength() {
        return this.lineSeparatorLength;
    }

    public LineTokenizer(@NotNull char[] text, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter(text, "text");
        this(new CharArrayCharSequence(text, startOffset, endOffset));
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final void advance() {
        int i = this.offset + this.length + this.lineSeparatorLength;
        int textLength = this.myText.length();
        if (i >= textLength) {
            this.atEnd = true;
            return;
        }
        block6: while (i < textLength) {
            char c = this.myText.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    break block6;
                }
                default: {
                    ++i;
                    continue block6;
                }
            }
        }
        this.offset += this.length + this.lineSeparatorLength;
        this.length = i - this.offset;
        this.lineSeparatorLength = 0;
        if (i == textLength) {
            return;
        }
        char first2 = this.myText.charAt(i);
        switch (first2) {
            case '\n': 
            case '\r': {
                this.lineSeparatorLength = 1;
            }
        }
        if (++i == textLength) {
            return;
        }
        char second2 = this.myText.charAt(i);
        if (first2 == '\r' && second2 == '\n') {
            this.lineSeparatorLength = 2;
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return Companion.tokenize(chars, includeSeparators, skipLastEmptyLine);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return Companion.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
    }

    @JvmStatic
    public static final int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
        return Companion.calcLineCount(chars, skipLastEmptyLine);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@NotNull char[] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return Companion.tokenize(chars, includeSeparators, skipLastEmptyLine);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators) {
        return Companion.tokenize(chars, includeSeparators);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators) {
        return Companion.tokenizeIntoList(chars, includeSeparators);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@NotNull char[] chars, boolean includeSeparators) {
        return Companion.tokenize(chars, includeSeparators);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\fJ*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0014J=\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/util/text/LineTokenizer$Companion;", "", "<init>", "()V", "tokenize", "", "", "chars", "", "includeSeparators", "", "skipLastEmptyLine", "(Ljava/lang/CharSequence;ZZ)[Ljava/lang/String;", "EMPTY_STRING_ARRAY", "[Ljava/lang/String;", "tokenizeIntoList", "", "calcLineCount", "", "", "([CZZ)[Ljava/lang/String;", "startOffset", "endOffset", "([CIIZZ)[Ljava/lang/String;", "stringEndsWithSeparator", "tokenizer", "Lcom/intellij/openapi/util/text/LineTokenizer;", "intellij.platform.util.base.multiplatform"})
    @SourceDebugExtension(value={"SMAP\nLineTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineTokenizer.kt\ncom/intellij/openapi/util/text/LineTokenizer$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,134:1\n37#2:135\n36#2,3:136\n*S KotlinDebug\n*F\n+ 1 LineTokenizer.kt\ncom/intellij/openapi/util/text/LineTokenizer$Companion\n*L\n65#1:135\n65#1:136,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
            String[] stringArray;
            List<String> strings = this.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
            if (strings.isEmpty()) {
                stringArray = EMPTY_STRING_ARRAY;
            } else {
                Collection $this$toTypedArray$iv = strings;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            }
            return stringArray;
        }

        public static /* synthetic */ String[] tokenize$default(Companion companion, CharSequence charSequence, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.tokenize(charSequence, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
            if (chars == null || chars.length() == 0) {
                return new ArrayList();
            }
            LineTokenizer tokenizer = new LineTokenizer(chars);
            List lines = new ArrayList();
            while (!tokenizer.atEnd()) {
                int offset = tokenizer.getOffset();
                String line = includeSeparators ? ((Object)chars.subSequence(offset, offset + tokenizer.getLength() + tokenizer.getLineSeparatorLength())).toString() : ((Object)chars.subSequence(offset, offset + tokenizer.getLength())).toString();
                lines.add(line);
                tokenizer.advance();
            }
            if (!skipLastEmptyLine && this.stringEndsWithSeparator(tokenizer)) {
                lines.add("");
            }
            return lines;
        }

        public static /* synthetic */ List tokenizeIntoList$default(Companion companion, CharSequence charSequence, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.tokenizeIntoList(charSequence, bl, bl2);
        }

        @JvmStatic
        public final int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
            Intrinsics.checkNotNullParameter(chars, "chars");
            int lineCount = 0;
            if (chars.length() > 0) {
                LineTokenizer tokenizer = new LineTokenizer(chars);
                while (!tokenizer.atEnd()) {
                    ++lineCount;
                    tokenizer.advance();
                }
                if (!skipLastEmptyLine && this.stringEndsWithSeparator(tokenizer)) {
                    ++lineCount;
                }
            }
            return lineCount;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
            Intrinsics.checkNotNullParameter(chars, "chars");
            return this.tokenize(chars, 0, chars.length, includeSeparators, skipLastEmptyLine);
        }

        public static /* synthetic */ String[] tokenize$default(Companion companion, char[] cArray, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.tokenize(cArray, bl, bl2);
        }

        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators, boolean skipLastEmptyLine) {
            Intrinsics.checkNotNullParameter(chars, "chars");
            return this.tokenize(new CharArrayCharSequence(chars, startOffset, endOffset), includeSeparators, skipLastEmptyLine);
        }

        public static /* synthetic */ String[] tokenize$default(Companion companion, char[] cArray, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                bl2 = true;
            }
            return companion.tokenize(cArray, n, n2, bl, bl2);
        }

        private final boolean stringEndsWithSeparator(LineTokenizer tokenizer) {
            return tokenizer.getLineSeparatorLength() > 0;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators) {
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenize$default(this, chars, includeSeparators, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators) {
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenizeIntoList$default(this, chars, includeSeparators, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, boolean includeSeparators) {
            Intrinsics.checkNotNullParameter(chars, "chars");
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenize$default(this, chars, includeSeparators, false, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators) {
            Intrinsics.checkNotNullParameter(chars, "chars");
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenize$default(this, chars, startOffset, endOffset, includeSeparators, false, 16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

