/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.pubsub;

import java.util.ArrayDeque;
import java.util.Deque;
import zmq.Ctx;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.pipe.Pipe;
import zmq.socket.pubsub.Dist;
import zmq.socket.pubsub.Mtrie;
import zmq.util.Blob;

public class XPub
extends SocketBase {
    private final Mtrie subscriptions;
    private final Mtrie manualSubscriptions;
    private final Dist dist;
    private boolean verboseSubs;
    private boolean verboseUnsubs;
    private boolean more;
    private boolean lossy;
    private boolean manual;
    private Pipe lastPipe;
    private final Deque<Pipe> pendingPipes;
    private final Deque<Blob> pendingData;
    private final Deque<Integer> pendingFlags;
    private static final Mtrie.IMtrieHandler markAsMatching = new MarkAsMatching();
    private static final Mtrie.IMtrieHandler sendUnsubscription = new SendUnsubscription();

    public XPub(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 9;
        this.verboseSubs = false;
        this.verboseUnsubs = false;
        this.more = false;
        this.lossy = true;
        this.manual = false;
        this.subscriptions = new Mtrie();
        this.manualSubscriptions = new Mtrie();
        this.dist = new Dist();
        this.lastPipe = null;
        this.pendingPipes = new ArrayDeque<Pipe>();
        this.pendingData = new ArrayDeque<Blob>();
        this.pendingFlags = new ArrayDeque<Integer>();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribeToAll, boolean isLocallyInitiated) {
        assert (pipe != null);
        this.dist.attach(pipe);
        if (subscribeToAll) {
            this.subscriptions.addOnTop(pipe);
        }
        this.xreadActivated(pipe);
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        Msg sub;
        while ((sub = pipe.read()) != null) {
            boolean notify;
            int size = sub.size();
            if (size <= 0 || sub.get(0) != 0 && sub.get(0) != 1) {
                this.pendingData.add(Blob.createBlob(sub));
                this.pendingFlags.add(sub.flags());
                continue;
            }
            boolean subscribe = sub.get(0) == 1;
            if (this.manual) {
                if (!subscribe) {
                    this.manualSubscriptions.rm(sub, pipe);
                } else {
                    this.manualSubscriptions.add(sub, pipe);
                }
                this.pendingPipes.add(pipe);
                this.pendingData.add(Blob.createBlob(sub));
                this.pendingFlags.add(0);
                continue;
            }
            if (!subscribe) {
                notify = this.subscriptions.rm(sub, pipe) || this.verboseUnsubs;
            } else {
                boolean bl = notify = this.subscriptions.add(sub, pipe) || this.verboseSubs;
            }
            if (this.options.type != 9 || !notify) continue;
            this.pendingData.add(Blob.createBlob(sub));
            this.pendingFlags.add(0);
        }
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.dist.activated(pipe);
    }

    @Override
    public boolean xsetsockopt(int option2, Object optval) {
        if (option2 == 40 || option2 == 78 || option2 == 69 || option2 == 71) {
            if (option2 == 40) {
                this.verboseSubs = Options.parseBoolean(option2, optval);
                this.verboseUnsubs = false;
            } else if (option2 == 78) {
                this.verboseUnsubs = this.verboseSubs = Options.parseBoolean(option2, optval);
            } else if (option2 == 69) {
                this.lossy = !Options.parseBoolean(option2, optval);
            } else if (option2 == 71) {
                this.manual = Options.parseBoolean(option2, optval);
            }
        } else if (option2 == 6 && this.manual) {
            if (null != this.lastPipe) {
                String val = Options.parseString(option2, optval);
                this.subscriptions.add(new Msg(val.getBytes()), this.lastPipe);
            }
        } else if (option2 == 7 && this.manual) {
            if (null != this.lastPipe) {
                String val = Options.parseString(option2, optval);
                this.subscriptions.rm(new Msg(val.getBytes()), this.lastPipe);
            }
        } else {
            this.errno.set(22);
            return false;
        }
        return true;
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        if (this.manual) {
            this.manualSubscriptions.rm(pipe, sendUnsubscription, this);
            this.subscriptions.rm(pipe, (p, d, s, self) -> {}, this);
        } else {
            this.subscriptions.rm(pipe, sendUnsubscription, this);
        }
        this.dist.terminated(pipe);
    }

    private void markAsMatching(Pipe pipe) {
        this.dist.match(pipe);
    }

    @Override
    protected boolean xsend(Msg msg) {
        boolean msgMore = msg.hasMore();
        if (!this.more) {
            this.subscriptions.match(msg.buf(), msg.size(), markAsMatching, this);
        }
        if (this.lossy || this.dist.checkHwm()) {
            if (this.dist.sendToMatching(msg)) {
                if (!msgMore) {
                    this.dist.unmatch();
                }
                this.more = msgMore;
                return true;
            }
        } else {
            this.errno.set(35);
        }
        return false;
    }

    @Override
    protected boolean xhasOut() {
        return this.dist.hasOut();
    }

    @Override
    protected Msg xrecv() {
        if (this.pendingData.isEmpty()) {
            this.errno.set(35);
            return null;
        }
        if (this.manual && !this.pendingPipes.isEmpty()) {
            this.lastPipe = this.pendingPipes.pollFirst();
        }
        Blob first = this.pendingData.pollFirst();
        Msg msg = new Msg(first.data());
        int flags = this.pendingFlags.pollFirst();
        msg.setFlags(flags);
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return !this.pendingData.isEmpty();
    }

    private void sendUnsubscription(byte[] data, int size) {
        if (this.options.type != 1) {
            byte[] unsub = new byte[size + 1];
            unsub[0] = 0;
            System.arraycopy(data, 0, unsub, 1, size);
            this.pendingData.add(Blob.createBlob(unsub));
            this.pendingFlags.add(0);
            if (this.manual) {
                this.lastPipe = null;
                this.pendingPipes.clear();
            }
        }
    }

    private static final class MarkAsMatching
    implements Mtrie.IMtrieHandler {
        private MarkAsMatching() {
        }

        @Override
        public void invoke(Pipe pipe, byte[] data, int size, XPub self) {
            self.markAsMatching(pipe);
        }
    }

    private static final class SendUnsubscription
    implements Mtrie.IMtrieHandler {
        private SendUnsubscription() {
        }

        @Override
        public void invoke(Pipe pipe, byte[] data, int size, XPub self) {
            self.sendUnsubscription(data, size);
        }
    }
}

