/*
 * Decompiled with CFR 0.152.
 */
package zmq.poll;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import zmq.Ctx;
import zmq.ZError;
import zmq.poll.IPollEvents;
import zmq.poll.PollerBase;

public final class Poller
extends PollerBase
implements Runnable {
    private final Ctx ctx;
    private final Set<Handle> fdTable;
    private boolean retired = false;
    private final AtomicBoolean stopping = new AtomicBoolean();
    private final CountDownLatch stopped = new CountDownLatch(1);
    private final Thread.UncaughtExceptionHandler exnotification;
    private Selector selector;

    public Poller(Ctx ctx, String name) {
        super(name, ctx.getThreadFactory());
        this.ctx = ctx;
        this.exnotification = ctx.getNotificationExceptionHandler();
        this.fdTable = new HashSet<Handle>();
        this.selector = ctx.createSelector();
    }

    public void destroy() {
        try {
            this.stop();
            this.stopped.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.ctx.closeSelector(this.selector);
        }
    }

    public Handle addHandle(SelectableChannel fd, IPollEvents events) {
        assert (Thread.currentThread() == this.worker || !this.worker.isAlive());
        Handle handle = new Handle(fd, events);
        this.fdTable.add(handle);
        this.adjustLoad(1);
        return handle;
    }

    public void removeHandle(Handle handle) {
        assert (Thread.currentThread() == this.worker || !this.worker.isAlive());
        handle.cancelled = true;
        this.retired = true;
        this.adjustLoad(-1);
    }

    public void setPollIn(Handle handle) {
        this.register(handle, 1, true);
    }

    public void resetPollIn(Handle handle) {
        this.register(handle, 1, false);
    }

    public void setPollOut(Handle handle) {
        this.register(handle, 4, true);
    }

    public void resetPollOut(Handle handle) {
        this.register(handle, 4, false);
    }

    public void setPollConnect(Handle handle) {
        this.register(handle, 8, true);
    }

    public void setPollAccept(Handle handle) {
        this.register(handle, 16, true);
    }

    private void register(Handle handle, int ops, boolean add) {
        assert (Thread.currentThread() == this.worker || !this.worker.isAlive());
        if (add) {
            handle.ops |= ops;
        } else {
            handle.ops &= ~ops;
        }
        this.retired = true;
    }

    public void start() {
        this.worker.start();
    }

    public void stop() {
        this.stopping.set(true);
        this.retired = false;
        this.selector.wakeup();
    }

    @Override
    public void run() {
        int returnsImmediately = 0;
        while (!this.stopping.get()) {
            int rc;
            long timeout = this.executeTimers();
            if (this.retired) {
                this.retired = false;
                Iterator<Handle> iter = this.fdTable.iterator();
                while (iter.hasNext()) {
                    Handle handle = iter.next();
                    SelectionKey key = handle.fd.keyFor(this.selector);
                    if (handle.cancelled || !handle.fd.isOpen()) {
                        if (key != null) {
                            key.cancel();
                        }
                        iter.remove();
                        continue;
                    }
                    if (key == null) {
                        if (!handle.fd.isOpen()) continue;
                        try {
                            key = handle.fd.register(this.selector, handle.ops, handle);
                            assert (key != null);
                            continue;
                        }
                        catch (CancelledKeyException | ClosedChannelException | ClosedSelectorException e) {
                            this.exnotification.uncaughtException(this.worker, e);
                            continue;
                        }
                    }
                    if (!key.isValid()) continue;
                    key.interestOps(handle.ops);
                }
            }
            long start = System.currentTimeMillis();
            try {
                rc = this.selector.select(timeout);
            }
            catch (ClosedSelectorException e) {
                this.rebuildSelector();
                this.exnotification.uncaughtException(this.worker, e);
                this.ctx.errno().set(4);
                continue;
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
            if (rc == 0) {
                returnsImmediately = this.maybeRebuildSelector(returnsImmediately, timeout, start);
                continue;
            }
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                Handle pollset = (Handle)key.attachment();
                it.remove();
                if (pollset.cancelled) continue;
                try {
                    if (key.isValid() && key.isAcceptable()) {
                        pollset.handler.acceptEvent();
                    }
                    if (key.isValid() && key.isConnectable()) {
                        pollset.handler.connectEvent();
                    }
                    if (key.isValid() && key.isWritable()) {
                        pollset.handler.outEvent();
                    }
                    if (!key.isValid() || !key.isReadable()) continue;
                    pollset.handler.inEvent();
                }
                catch (RuntimeException e) {
                    this.exnotification.uncaughtException(this.worker, e);
                }
            }
        }
        this.stopped.countDown();
    }

    private int maybeRebuildSelector(int returnsImmediately, long timeout, long start) {
        returnsImmediately = timeout == 0L || System.currentTimeMillis() - start < timeout / 2L ? ++returnsImmediately : 0;
        if (returnsImmediately > 10) {
            this.rebuildSelector();
            returnsImmediately = 0;
        }
        return returnsImmediately;
    }

    private void rebuildSelector() {
        Selector oldSelector = this.selector;
        this.selector = this.ctx.createSelector();
        this.retired = true;
        this.ctx.closeSelector(oldSelector);
    }

    public static final class Handle {
        private final SelectableChannel fd;
        private final IPollEvents handler;
        private int ops;
        private boolean cancelled;

        public Handle(SelectableChannel fd, IPollEvents handler) {
            assert (fd != null);
            assert (handler != null);
            this.fd = fd;
            this.handler = handler;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fd.hashCode();
            result = 31 * result + this.handler.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Handle)) {
                return false;
            }
            Handle that = (Handle)other;
            return this.fd.equals(that.fd) && this.handler.equals(that.handler);
        }

        public String toString() {
            return "Handle-" + this.fd;
        }
    }
}

