/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.util.containers.JBIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GridWrapperNestedTable
implements NestedTable {
    private final GridListModelBase<GridRow, GridColumn> myGridModel;

    public GridWrapperNestedTable(GridListModelBase<GridRow, GridColumn> gridModel) {
        this.myGridModel = gridModel;
    }

    @Override
    public HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode getColumnsHierarchy() {
        return null;
    }

    @Override
    public Object getValueAt(int rowIdx, int colIdx) {
        return this.myGridModel.getValueAt((GridRow)((Object)ModelIndex.forRow(this.myGridModel, rowIdx)), (GridColumn)((Object)ModelIndex.forColumn(this.myGridModel, colIdx)));
    }

    @Override
    public Object getValueAt(GridRow row, GridColumn column) {
        return this.myGridModel.getValueAt(row, column);
    }

    @Override
    public void setValueAt(int rowIdx, int colIdx, Object value) {
        GridRow row = this.myGridModel.getRow(ModelIndex.forRow(this.myGridModel, rowIdx));
        if (row == null) {
            throw new IllegalStateException("Unable to set value. No GridRow found at row index: " + rowIdx);
        }
        row.setValue(colIdx, value);
    }

    @Override
    public void addRow(GridRow value) {
        this.myGridModel.addRow(value);
    }

    @Override
    public int getRowsNum() {
        return this.myGridModel.getRowCount();
    }

    @Override
    public int getColumnsNum() {
        return this.myGridModel.getColumnCount();
    }

    @Override
    public boolean isValidRowIdx(int rowIdx) {
        return this.myGridModel.isValidRowIdx(ModelIndex.forRow(this.myGridModel, rowIdx));
    }

    @Override
    public boolean isValidColumnIdx(int colIdx) {
        return this.myGridModel.isValidColumnIdx(ModelIndex.forColumn(this.myGridModel, colIdx));
    }

    @Override
    public int getColumnType(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalStateException("Given column index " + colIdx + " is not valid.");
        }
        return Objects.requireNonNull(this.myGridModel.getColumn(ModelIndex.forColumn(this.myGridModel, colIdx))).getType();
    }

    @Override
    public String getColumnTypeName(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalStateException("Given column index " + colIdx + " is not valid.");
        }
        return Objects.requireNonNull(this.myGridModel.getColumn(ModelIndex.forColumn(this.myGridModel, colIdx))).getTypeName();
    }

    @Override
    public String getColumnName(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalStateException("Given column index " + colIdx + " is not valid.");
        }
        return Objects.requireNonNull(this.myGridModel.getColumn(ModelIndex.forColumn(this.myGridModel, colIdx))).getName();
    }

    @Override
    @NotNull
    public Iterator<Map<String, Object>> iterator() {
        return new JBIterator<Map<String, Object>>(){
            private int myNextValueIdx;

            protected Map<String, Object> nextImpl() {
                return this.myNextValueIdx < GridWrapperNestedTable.this.getRowsNum() ? GridWrapperNestedTable.this.toMap(this.myNextValueIdx++) : (Map<String, Object>)this.stop();
            }
        };
    }

    private Map<String, Object> toMap(int rowIdx) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GridRow row = this.myGridModel.getRow(ModelIndex.forRow(this.myGridModel, rowIdx));
        for (GridColumn column : this.myGridModel.getColumns()) {
            result.put(column.getName(), this.getValueAt(row, column));
        }
        return result;
    }
}

