/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitConfigurationModel {
    public static final int ALL_IN_PACKAGE = 0;
    public static final int CLASS = 1;
    public static final int METHOD = 2;
    public static final int PATTERN = 3;
    public static final int DIR = 4;
    public static final int CATEGORY = 5;
    public static final int UNIQUE_ID = 6;
    public static final int TAGS = 7;
    public static final int BY_SOURCE_POSITION = 8;
    public static final int BY_SOURCE_CHANGES = 9;
    private static final List<String> ourTestObjects = Arrays.asList("package", "class", "method", "pattern", "directory", "category", "uniqueId", "tags", "source location", "changes");
    private BiConsumer<Integer, Integer> myListener;
    private int myType = -1;
    private final Object[] myJUnitDocuments = new Object[6];
    private final Project myProject;

    public JUnitConfigurationModel(Project project) {
        this.myProject = project;
    }

    public boolean setType(int type) {
        if (type == this.myType) {
            return false;
        }
        int oldType = this.myType;
        if (type < 0 || type >= ourTestObjects.size()) {
            type = 1;
        }
        this.myType = type;
        this.fireTypeChanged(oldType, type);
        return true;
    }

    private void fireTypeChanged(int oldType, int newType) {
        this.myListener.accept(oldType, newType);
    }

    public void setListener(BiConsumer<Integer, Integer> listener) {
        this.myListener = listener;
    }

    public void setJUnitDocument(int i, Object doc) {
        this.myJUnitDocuments[i] = doc;
    }

    public void apply(Module module, JUnitConfiguration configuration, @Nullable ClassEditorField classField) {
        boolean shouldUpdateName = configuration.isGeneratedName();
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-359592");){
            this.applyTo(configuration.getPersistentData(), module, classField);
        }
        if (shouldUpdateName && !JavaExecutionUtil.isNewName((String)configuration.getName())) {
            configuration.setGeneratedName();
        }
    }

    private void applyTo(JUnitConfiguration.Data data, Module module, @Nullable ClassEditorField classField) {
        block23: {
            String testObject = this.getTestObject();
            String className = this.getJUnitTextValue(1);
            data.TEST_OBJECT = testObject;
            if (!("package".equals(testObject) || "pattern".equals(testObject) || "directory".equals(testObject) || "category".equals(testObject) || "changes".equals(testObject))) {
                data.METHOD_NAME = this.getJUnitTextValue(2);
                if (classField != null) {
                    String jvmName = classField.getClassName();
                    if (jvmName != null) {
                        data.MAIN_CLASS_NAME = jvmName;
                        data.PACKAGE_NAME = StringUtil.getPackageName((String)jvmName);
                    } else {
                        data.MAIN_CLASS_NAME = className;
                    }
                    return;
                }
                if (!className.equals(JUnitConfigurationModel.replaceRuntimeClassName(data.getMainClassName()))) {
                    try {
                        PsiClass testClass;
                        if (!this.myProject.isDefault() && !StringUtil.isEmptyOrSpaces((String)className)) {
                            JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.myProject, true);
                            configurationModule.setModule(module);
                            testClass = configurationModule.findClass(className);
                        } else {
                            testClass = null;
                        }
                        if (testClass != null && testClass.isValid()) {
                            data.setMainClass(testClass);
                            break block23;
                        }
                        data.MAIN_CLASS_NAME = className;
                    }
                    catch (ProcessCanceledException | IndexNotReadyException e) {
                        data.MAIN_CLASS_NAME = className;
                    }
                }
            } else if (!"changes".equals(testObject)) {
                switch (testObject) {
                    case "package": {
                        data.PACKAGE_NAME = this.getJUnitTextValue(0);
                        break;
                    }
                    case "directory": {
                        data.setDirName(this.getJUnitTextValue(4));
                        break;
                    }
                    case "category": {
                        data.setCategoryName(this.getJUnitTextValue(5));
                        break;
                    }
                    default: {
                        String[] patterns;
                        LinkedHashSet<String> set = new LinkedHashSet<String>();
                        for (String pattern : patterns = this.getJUnitTextValue(3).split("\\|\\|")) {
                            if (pattern.isEmpty()) continue;
                            set.add(pattern);
                        }
                        data.setPatterns(set);
                    }
                }
                data.MAIN_CLASS_NAME = "";
                data.METHOD_NAME = "";
            }
        }
    }

    private String getTestObject() {
        return ourTestObjects.get(this.myType);
    }

    private String getJUnitTextValue(int index) {
        return JUnitConfigurationModel.getDocumentText(index, this.myJUnitDocuments);
    }

    private static String getDocumentText(int index, Object[] documents) {
        Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                return ((PlainDocument)document).getText(0, ((PlainDocument)document).getLength());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return ((Document)document).getText();
    }

    public void reset(JUnitConfiguration configuration) {
        JUnitConfiguration.Data data = configuration.getPersistentData();
        this.setTestType(data.TEST_OBJECT);
        this.setJUnitTextValue(0, data.getPackageName());
        this.setJUnitTextValue(1, JUnitConfigurationModel.replaceRuntimeClassName(data.getMainClassName()));
        this.setJUnitTextValue(2, data.getMethodNameWithSignature());
        this.setJUnitTextValue(3, data.getPatternPresentation());
        this.setJUnitTextValue(4, data.getDirName());
        this.setJUnitTextValue(5, data.getCategory());
    }

    private static String replaceRuntimeClassName(String mainClassName) {
        return mainClassName.replace('$', '.');
    }

    private void setJUnitTextValue(int index, String text) {
        this.setDocumentText(index, text, this.myJUnitDocuments);
    }

    private void setDocumentText(int index, String text, Object[] documents) {
        Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                ((PlainDocument)document).remove(0, ((PlainDocument)document).getLength());
                ((PlainDocument)document).insertString(0, text, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, null, null, () -> ((Document)document).replaceString(0, ((Document)document).getTextLength(), (CharSequence)text), (PsiFile[])new PsiFile[0]);
        }
    }

    private void setTestType(String testObject) {
        this.setType(ourTestObjects.indexOf(testObject));
    }

    @NlsContexts.Label
    @NotNull
    public static String getKindName(int value) {
        String string = switch (value) {
            case 0 -> JUnitBundle.message("junit.configuration.kind.all.in.package", new Object[0]);
            case 4 -> JUnitBundle.message("junit.configuration.kind.all.in.directory", new Object[0]);
            case 3 -> JUnitBundle.message("junit.configuration.kind.by.pattern", new Object[0]);
            case 1 -> JUnitBundle.message("junit.configuration.kind.class", new Object[0]);
            case 2 -> JUnitBundle.message("junit.configuration.kind.method", new Object[0]);
            case 5 -> JUnitBundle.message("junit.configuration.kind.category", new Object[0]);
            case 6 -> JUnitBundle.message("junit.configuration.kind.by.unique.id", new Object[0]);
            case 7 -> JUnitBundle.message("junit.configuration.kind.by.tags", new Object[0]);
            case 8 -> "Through source location";
            case 9 -> "Over changes in sources";
            default -> throw new IllegalArgumentException(String.valueOf(value));
        };
        if (string == null) {
            JUnitConfigurationModel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsContexts.Label
    @NotNull
    public static String getRepeatModeName(@NotNull @NonNls String value) {
        if (value == null) {
            JUnitConfigurationModel.$$$reportNull$$$0(1);
        }
        String string = JUnitBundle.message(switch (value) {
            case "Once" -> "junit.configuration.repeat.mode.once";
            case "N Times" -> "junit.configuration.repeat.mode.n.times";
            case "Until Failure" -> "junit.configuration.repeat.mode.until.failure";
            case "Until Success" -> "junit.configuration.repeat.mode.until.success";
            case "Until Stopped" -> "junit.configuration.repeat.mode.until.stopped";
            default -> throw new IllegalArgumentException(value);
        }, new Object[0]);
        if (string == null) {
            JUnitConfigurationModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsContexts.Label
    @NotNull
    public static String getForkModeName(@NotNull @NonNls String value) {
        if (value == null) {
            JUnitConfigurationModel.$$$reportNull$$$0(3);
        }
        String string = JUnitBundle.message(switch (value) {
            case "none" -> "junit.configuration.fork.mode.none";
            case "method" -> "junit.configuration.fork.mode.method";
            case "class" -> "junit.configuration.fork.mode.class";
            case "repeat" -> "junit.configuration.fork.mode.repeat";
            default -> throw new IllegalArgumentException(value);
        }, new Object[0]);
        if (string == null) {
            JUnitConfigurationModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void reloadTestKindModel(JComboBox<Integer> comboBox, Module module, @Nullable Runnable onDone) {
        Object selectedItem = comboBox.getSelectedItem();
        ReadAction.nonBlocking(() -> {
            GlobalSearchScope searchScope;
            DefaultComboBoxModel<Integer> aModel = new DefaultComboBoxModel<Integer>();
            aModel.addElement(0);
            aModel.addElement(4);
            aModel.addElement(3);
            aModel.addElement(1);
            aModel.addElement(2);
            GlobalSearchScope globalSearchScope = searchScope = module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)this.myProject);
            if (this.myProject.isDefault() || JavaPsiFacade.getInstance((Project)this.myProject).findPackage("org.junit") != null) {
                aModel.addElement(5);
            }
            if (this.myProject.isDefault() || JUnitUtil.isJUnit5((GlobalSearchScope)searchScope, (Project)this.myProject) || TestObject.hasJUnit5EnginesAPI(searchScope, JavaPsiFacade.getInstance((Project)this.myProject))) {
                aModel.addElement(6);
                aModel.addElement(7);
            }
            if (Registry.is((String)"testDiscovery.enabled")) {
                aModel.addElement(8);
                aModel.addElement(9);
            }
            return aModel;
        }).finishOnUiThread(ModalityState.any(), model -> {
            comboBox.setModel((ComboBoxModel<Integer>)model);
            comboBox.setSelectedItem(selectedItem == null ? Integer.valueOf(this.myType) : selectedItem);
            if (onDone != null) {
                onDone.run();
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public boolean disableModuleClasspath(boolean wholeProjectSelected) {
        return wholeProjectSelected && (this.myType == 0 || this.myType == 3 || this.myType == 5 || this.myType == 7 || this.myType == 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit2/configuration/JUnitConfigurationModel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit2/configuration/JUnitConfigurationModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepeatModeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getForkModeName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRepeatModeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getForkModeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

