/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.List;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.ChaCha20;
import net.i2p.crypto.EncType;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.ShortEncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;

abstract class BuildMessageGenerator {
    BuildMessageGenerator() {
    }

    public static void createRecord(int recordNum, int hop, TunnelBuildMessage msg, TunnelCreatorConfig cfg, Hash replyRouter, long replyTunnel, RouterContext ctx, PublicKey peerKey, Properties props) {
        EncryptedBuildRecord erec;
        boolean isShort;
        int mtype = msg.getType();
        boolean bl = isShort = mtype == 25;
        if (peerKey != null) {
            boolean isEC = peerKey.getType() == EncType.ECIES_X25519;
            BuildRequestRecord req = !cfg.isInbound() && hop + 1 == cfg.getLength() ? BuildMessageGenerator.createUnencryptedRecord(ctx, cfg, hop, replyRouter, replyTunnel, isEC, isShort, props) : BuildMessageGenerator.createUnencryptedRecord(ctx, cfg, hop, null, -1L, isEC, isShort, props);
            if (req == null) {
                throw new IllegalArgumentException("hop bigger than config");
            }
            Hash peer = cfg.getPeer(hop);
            if (isEC) {
                erec = req.encryptECIESRecord(ctx, peerKey, peer);
                cfg.setChaChaReplyKeys(hop, req.getChaChaReplyKey(), req.getChaChaReplyAD());
                if (isShort) {
                    HopConfig hopConfig = cfg.getConfig(hop);
                    hopConfig.setLayerKey(req.readLayerKey());
                    hopConfig.setIVKey(req.readIVKey());
                    if (!cfg.isInbound() && hop + 1 == cfg.getLength()) {
                        cfg.setGarlicReplyKeys(req.readGarlicKeys());
                    }
                }
            } else {
                erec = req.encryptRecord(ctx, peerKey, peer);
            }
        } else {
            int len = isShort ? 218 : 528;
            byte[] encrypted = new byte[len];
            if (cfg.isInbound() && hop + 1 == cfg.getLength()) {
                System.arraycopy(cfg.getPeer(hop).getData(), 0, encrypted, 0, 16);
                ctx.random().nextBytes(encrypted, 16, len - 16);
                byte[] h = new byte[32];
                ctx.sha().calculateHash(encrypted, 0, len, h, 0);
                cfg.setBlankHash(new Hash(h));
            } else {
                ctx.random().nextBytes(encrypted);
            }
            erec = isShort ? new ShortEncryptedBuildRecord(encrypted) : new EncryptedBuildRecord(encrypted);
        }
        msg.setRecord(recordNum, erec);
    }

    private static BuildRequestRecord createUnencryptedRecord(I2PAppContext ctx, TunnelCreatorConfig cfg, int hop, Hash replyRouter, long replyTunnel, boolean isEC, boolean isShort, Properties props) {
        if (isShort && !isEC) {
            throw new IllegalArgumentException();
        }
        if (hop < cfg.getLength()) {
            BuildRequestRecord rec;
            HopConfig hopConfig = cfg.getConfig(hop);
            Hash peer = cfg.getPeer(hop);
            long recvTunnelId = -1L;
            recvTunnelId = cfg.isInbound() || hop > 0 ? hopConfig.getReceiveTunnelId() : 0L;
            long nextTunnelId = -1L;
            Hash nextPeer = null;
            if (hop + 1 < cfg.getLength()) {
                nextTunnelId = cfg.getConfig(hop + 1).getReceiveTunnelId();
                nextPeer = cfg.getPeer(hop + 1);
            } else if (replyTunnel >= 0L && replyRouter != null) {
                nextTunnelId = replyTunnel;
                nextPeer = replyRouter;
            } else {
                nextTunnelId = 0L;
                nextPeer = peer;
            }
            boolean isInGW = cfg.isInbound() && hop == 0;
            boolean isOutEnd = !cfg.isInbound() && hop + 1 >= cfg.getLength();
            long nextMsgId = -1L;
            nextMsgId = isOutEnd || cfg.isInbound() && hop + 2 >= cfg.getLength() ? cfg.getReplyMessageId() : ctx.random().nextLong(0xFFFFFFFFL);
            if (isEC) {
                if (isShort) {
                    rec = new BuildRequestRecord(ctx, recvTunnelId, nextTunnelId, nextPeer, nextMsgId, isInGW, isOutEnd, props);
                } else {
                    SessionKey layerKey = hopConfig.getLayerKey();
                    SessionKey ivKey = hopConfig.getIVKey();
                    SessionKey replyKey = cfg.getAESReplyKey(hop);
                    byte[] iv = cfg.getAESReplyIV(hop);
                    if (iv == null) {
                        throw new IllegalStateException();
                    }
                    rec = new BuildRequestRecord(ctx, recvTunnelId, nextTunnelId, nextPeer, nextMsgId, layerKey, ivKey, replyKey, iv, isInGW, isOutEnd, props);
                }
            } else {
                SessionKey layerKey = hopConfig.getLayerKey();
                SessionKey ivKey = hopConfig.getIVKey();
                SessionKey replyKey = cfg.getAESReplyKey(hop);
                byte[] iv = cfg.getAESReplyIV(hop);
                if (iv == null) {
                    throw new IllegalStateException();
                }
                rec = new BuildRequestRecord(ctx, recvTunnelId, peer, nextTunnelId, nextPeer, nextMsgId, layerKey, ivKey, replyKey, iv, isInGW, isOutEnd);
            }
            return rec;
        }
        return null;
    }

    public static void layeredEncrypt(I2PAppContext ctx, TunnelBuildMessage msg, TunnelCreatorConfig cfg, List<Integer> order) {
        int mtype = msg.getType();
        boolean isShort = mtype == 25;
        int size = isShort ? 218 : 528;
        byte[] chachaIV = isShort ? new byte[12] : null;
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            EncryptedBuildRecord rec = msg.getRecord(i);
            Integer hopNum = order.get(i);
            int hop = hopNum;
            if (BuildMessageGenerator.isBlank(cfg, hop) && (!cfg.isInbound() || hop + 1 != cfg.getLength()) || !cfg.isInbound() && hop == 1) continue;
            int stop = cfg.isInbound() ? 0 : 1;
            for (int j = hop - 1; j >= stop; --j) {
                byte[] iv;
                SessionKey key;
                byte[] data = rec.getData();
                if (isShort) {
                    key = cfg.getChaChaReplyKey(j);
                    iv = chachaIV;
                    iv[4] = (byte)i;
                    ChaCha20.encrypt(key.getData(), iv, data, 0, data, 0, size);
                    continue;
                }
                key = cfg.getAESReplyKey(j);
                iv = cfg.getAESReplyIV(j);
                ctx.aes().decrypt(data, 0, data, 0, key, iv, size);
            }
        }
    }

    public static boolean isBlank(TunnelCreatorConfig cfg, int hop) {
        if (cfg.isInbound()) {
            return hop + 1 >= cfg.getLength();
        }
        if (hop == 0) {
            return true;
        }
        return hop >= cfg.getLength();
    }
}

