/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.lang.reflect.Field;
import java.util.TimeZone;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.VersionComparator;

public abstract class SystemVersion {
    public static final String DAEMON_USER = "i2psvc";
    public static final String GENTOO_USER = "i2p";
    private static final boolean _isWin;
    private static final boolean _isMac;
    private static final boolean _isArm;
    private static final boolean _isX86;
    private static final boolean _isGentoo;
    private static final boolean _isZero;
    private static final boolean _isAndroid;
    private static final boolean _isApache;
    private static final boolean _isGNU;
    private static final boolean _isOpenJDK;
    private static final boolean _is64;
    private static final boolean _hasWrapper;
    private static final boolean _isLinuxService;
    private static final boolean _isWindowsService;
    private static final boolean _isService;
    private static final boolean _isSlow;
    private static final boolean _oneDotSix;
    private static final boolean _oneDotSeven;
    private static final boolean _oneDotEight;
    private static final boolean _oneDotNine;
    private static final boolean _oneDotTen;
    private static final boolean _oneDotEleven;
    private static final int _androidSDK;

    public static String getOS() {
        if (SystemVersion.isWindows()) {
            return "windows";
        }
        if (SystemVersion.isMac()) {
            return "mac";
        }
        if (SystemVersion.isGNU()) {
            return "linux";
        }
        if (SystemVersion.isLinuxService()) {
            return "linux";
        }
        if (SystemVersion.isAndroid()) {
            return "android";
        }
        return "linux";
    }

    public static String getArch() {
        if (SystemVersion.is64Bit()) {
            if (SystemVersion.isARM()) {
                return "arm64";
            }
            if (SystemVersion.isX86()) {
                return "amd64";
            }
        }
        if (SystemVersion.isARM()) {
            return "arm";
        }
        if (SystemVersion.isX86()) {
            return "386";
        }
        return "unknown";
    }

    public static boolean isWindows() {
        return _isWin;
    }

    public static boolean isMac() {
        return _isMac;
    }

    public static boolean isAndroid() {
        return _isAndroid;
    }

    public static boolean isApache() {
        return _isApache || _isAndroid;
    }

    public static boolean isGNU() {
        return _isGNU;
    }

    public static boolean isGentoo() {
        return _isGentoo;
    }

    public static boolean isOpenJDK() {
        return _isOpenJDK;
    }

    public static boolean isARM() {
        return _isArm;
    }

    public static boolean isX86() {
        return _isX86;
    }

    public static boolean isZeroVM() {
        return _isZero;
    }

    public static boolean isSlow() {
        return _isSlow || !NativeBigInteger.isNative();
    }

    public static boolean isJava6() {
        return _oneDotSix;
    }

    public static boolean isJava7() {
        return _oneDotSeven;
    }

    public static boolean isJava8() {
        return _oneDotEight;
    }

    public static boolean isJava9() {
        return _oneDotNine;
    }

    public static boolean isJava10() {
        return _oneDotTen;
    }

    public static boolean isJava11() {
        return _oneDotEleven;
    }

    public static boolean isJava(int minVersion) {
        return SystemVersion.isJava("1." + minVersion);
    }

    public static boolean isJava(String minVersion) {
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.")) {
            version = "1." + version;
        }
        if (!minVersion.startsWith("1.")) {
            minVersion = "1." + minVersion;
        }
        if (_isAndroid) {
            if (minVersion.startsWith("1.6")) {
                return _oneDotSix;
            }
            if (minVersion.startsWith("1.7")) {
                return _oneDotSeven;
            }
            return false;
        }
        return VersionComparator.comp(version, minVersion) >= 0;
    }

    public static boolean is64Bit() {
        return _is64;
    }

    public static boolean isLinuxService() {
        return _isLinuxService;
    }

    public static boolean isWindowsService() {
        return _isWindowsService;
    }

    public static boolean isService() {
        return _isService;
    }

    public static int getAndroidVersion() {
        return _androidSDK;
    }

    public static boolean hasWrapper() {
        return _hasWrapper;
    }

    public static long getMaxMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory >= 0x3FFFFFFFFFFFFFFFL) {
            maxMemory = 0x6000000L;
        }
        return maxMemory;
    }

    public static int getCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static TimeZone getSystemTimeZone() {
        return SystemVersion.getSystemTimeZone(I2PAppContext.getGlobalContext());
    }

    public static TimeZone getSystemTimeZone(I2PAppContext ctx) {
        String systemTimeZone = ctx.getProperty("i2p.systemTimeZone");
        if (systemTimeZone != null) {
            return TimeZone.getTimeZone(systemTimeZone);
        }
        return TimeZone.getDefault();
    }

    public static void main(String[] args) {
        System.out.println("64 bit   : " + SystemVersion.is64Bit());
        System.out.println("Java 8   : " + SystemVersion.isJava8());
        System.out.println("Java 9   : " + SystemVersion.isJava9());
        System.out.println("Java 10  : " + SystemVersion.isJava10());
        System.out.println("Java 11  : " + SystemVersion.isJava11());
        for (int i = 12; i <= 24; ++i) {
            System.out.println("Java " + i + "  : " + SystemVersion.isJava(i));
        }
        System.out.println("Android  : " + SystemVersion.isAndroid());
        if (SystemVersion.isAndroid()) {
            System.out.println("  Version: " + SystemVersion.getAndroidVersion());
        }
        System.out.println("Apache   : " + SystemVersion.isApache());
        System.out.println("ARM      : " + SystemVersion.isARM());
        System.out.println("Cores    : " + SystemVersion.getCores());
        System.out.println("Gentoo   : " + SystemVersion.isGentoo());
        System.out.println("GNU      : " + SystemVersion.isGNU());
        System.out.println("Linux Svc: " + SystemVersion.isLinuxService());
        System.out.println("Mac      : " + SystemVersion.isMac());
        System.out.println("Max mem  : " + SystemVersion.getMaxMemory());
        System.out.println("OpenJDK  : " + SystemVersion.isOpenJDK());
        System.out.println("Slow     : " + SystemVersion.isSlow());
        System.out.println("Windows  : " + SystemVersion.isWindows());
        System.out.println("Win. Svc : " + SystemVersion.isWindowsService());
        System.out.println("Wrapper  : " + SystemVersion.hasWrapper());
        System.out.println("x86      : " + SystemVersion.isX86());
        System.out.println("Zero JVM : " + SystemVersion.isZeroVM());
        System.out.println("");
        System.out.println("System Properties:");
        TreeSet<String> keys = new TreeSet<String>(System.getProperties().stringPropertyNames());
        for (String k : keys) {
            String v = System.getProperty(k);
            if (k.equals("line.separator")) {
                if ("\n".equals(v)) {
                    v = "\\n";
                } else if ("\r\n".equals(v)) {
                    v = "\\r\\n";
                }
            }
            System.out.println(k + '=' + v);
        }
    }

    static {
        boolean is64;
        _isWin = System.getProperty("os.name").startsWith("Win");
        _isMac = System.getProperty("os.name").startsWith("Mac");
        _isArm = System.getProperty("os.arch").startsWith("arm") || System.getProperty("os.arch").startsWith("aarch");
        _isX86 = System.getProperty("os.arch").contains("86") || System.getProperty("os.arch").equals("amd64");
        _isGentoo = System.getProperty("os.version").contains("gentoo") || System.getProperty("os.version").contains("hardened");
        _isZero = System.getProperty("java.vm.name").contains("Zero");
        _hasWrapper = System.getProperty("wrapper.version") != null;
        _isWindowsService = _isWin && _hasWrapper && Boolean.parseBoolean(System.getProperty("wrapper.service"));
        boolean bl = is64 = "64".equals(System.getProperty("sun.arch.data.model")) || System.getProperty("os.arch").contains("64");
        if (_isWin && !is64) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            is64 = arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
        }
        _is64 = is64;
        String vendor = System.getProperty("java.vendor");
        _isAndroid = vendor.contains("Android");
        _isApache = vendor.startsWith("Apache");
        _isGNU = vendor.startsWith("GNU Classpath") || vendor.startsWith("Free Software Foundation");
        String runtime = System.getProperty("java.runtime.name");
        _isOpenJDK = runtime != null && runtime.contains("OpenJDK");
        _isLinuxService = !_isWin && !_isMac && !_isAndroid && (DAEMON_USER.equals(System.getProperty("user.name")) || _isGentoo && GENTOO_USER.equals(System.getProperty("user.name")));
        _isService = _isLinuxService || _isWindowsService;
        _isSlow = _isAndroid || _isApache || _isArm && (!_is64 || !_isMac && SystemVersion.getCores() < 5) || _isGNU || _isZero || SystemVersion.getMaxMemory() < 0x6000000L;
        int sdk = 0;
        if (_isAndroid) {
            try {
                Class<?> ver = Class.forName("android.os.Build$VERSION", true, ClassLoader.getSystemClassLoader());
                Field field = ver.getField("SDK_INT");
                sdk = field.getInt(null);
            }
            catch (Exception ver) {
                // empty catch block
            }
        }
        _androidSDK = sdk;
        if (_isAndroid) {
            _oneDotSix = _androidSDK >= 9;
            _oneDotSeven = _androidSDK >= 19;
            _oneDotEight = false;
            _oneDotNine = false;
            _oneDotTen = false;
            _oneDotEleven = false;
        } else {
            String version = System.getProperty("java.version");
            if (!version.startsWith("1.")) {
                version = "1." + version;
            }
            _oneDotSix = VersionComparator.comp(version, "1.6") >= 0;
            _oneDotSeven = _oneDotSix && VersionComparator.comp(version, "1.7") >= 0;
            _oneDotEight = _oneDotSeven && VersionComparator.comp(version, "1.8") >= 0;
            _oneDotNine = _oneDotEight && VersionComparator.comp(version, "1.9") >= 0;
            _oneDotTen = _oneDotNine && VersionComparator.comp(version, "1.10") >= 0;
            _oneDotEleven = _oneDotTen && VersionComparator.comp(version, "1.11") >= 0;
        }
    }
}

