/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json.user;

import com.google.common.io.BaseEncoding;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.guacamole.auth.json.user.UserData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDataDenylist {
    private static final Logger logger = LoggerFactory.getLogger(UserDataDenylist.class);
    private final ConcurrentMap<String, UserData> denylist = new ConcurrentHashMap<String, UserData>();

    public void removeExpired() {
        Iterator current = this.denylist.entrySet().iterator();
        while (current.hasNext()) {
            Map.Entry entry = current.next();
            if (!((UserData)entry.getValue()).isExpired()) continue;
            current.remove();
        }
    }

    public boolean add(UserData data, byte[] signature) {
        if (data.getExpires() == null) {
            logger.warn("An expiration timestamp MUST be provided for single-use data.");
            return false;
        }
        this.removeExpired();
        if (data.isExpired()) {
            return false;
        }
        String signatureHex = BaseEncoding.base16().encode(signature);
        return this.denylist.putIfAbsent(signatureHex, data) == null;
    }
}

