/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import groovy.lang.Closure;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class ClosureToSpecNotationConverter<T>
implements NotationConverter<Closure, Spec<T>> {
    private final Class<T> type;

    public ClosureToSpecNotationConverter(Class<T> type) {
        this.type = type;
    }

    public void convert(Closure notation, NotationConvertResult<? super Spec<T>> result) throws TypeConversionException {
        Spec spec = Specs.convertClosureToSpec((Closure)notation);
        result.converted((Object)spec);
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate(String.format("Closure that returns boolean and takes a single %s as a parameter.", this.type.getSimpleName()));
    }
}

